/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.BasisTypen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Fahrstrom</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.BasisTypen.BasisTypenPackage#getENUMFahrstrom()
 * @model extendedMetaData="name='ENUMFahrstrom'"
 * @generated
 */
public enum ENUMFahrstrom implements Enumerator {
	/**
	 * The '<em><b>ENUM Fahrstrom 1200V DC Stromschiene</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE(0, "ENUMFahrstrom_1200V_DC_Stromschiene", "1200V_DC_Stromschiene"),

	/**
	 * The '<em><b>ENUM Fahrstrom 1500V DC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_1500V_DC_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_1500V_DC(1, "ENUMFahrstrom_1500V_DC", "1500V_DC"),

	/**
	 * The '<em><b>ENUM Fahrstrom 15k V16 7Hz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_15K_V16_7HZ_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_15K_V16_7HZ(2, "ENUMFahrstrom_15kV_16_7Hz", "15kV_16_7Hz"),

	/**
	 * The '<em><b>ENUM Fahrstrom 2400V DC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_2400V_DC_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_2400V_DC(3, "ENUMFahrstrom_2400V_DC", "2400V_DC"),

	/**
	 * The '<em><b>ENUM Fahrstrom 25k V50 Hz</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_25K_V50_HZ_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_25K_V50_HZ(4, "ENUMFahrstrom_25kV_50Hz", "25kV_50Hz"),

	/**
	 * The '<em><b>ENUM Fahrstrom 3000V DC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_3000V_DC_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_3000V_DC(5, "ENUMFahrstrom_3000V_DC", "3000V_DC"),

	/**
	 * The '<em><b>ENUM Fahrstrom 750V DC Stromschiene</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_750V_DC_STROMSCHIENE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_750V_DC_STROMSCHIENE(6, "ENUMFahrstrom_750V_DC_Stromschiene", "750V_DC_Stromschiene"),

	/**
	 * The '<em><b>ENUM Fahrstrom sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_FAHRSTROM_SONSTIGE(7, "ENUMFahrstrom_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUM Fahrstrom 1200V DC Stromschiene</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE
	 * @model name="ENUMFahrstrom_1200V_DC_Stromschiene" literal="1200V_DC_Stromschiene"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE_VALUE = 0;

	/**
	 * The '<em><b>ENUM Fahrstrom 1500V DC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_1500V_DC
	 * @model name="ENUMFahrstrom_1500V_DC" literal="1500V_DC"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_1500V_DC_VALUE = 1;

	/**
	 * The '<em><b>ENUM Fahrstrom 15k V16 7Hz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_15K_V16_7HZ
	 * @model name="ENUMFahrstrom_15kV_16_7Hz" literal="15kV_16_7Hz"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_15K_V16_7HZ_VALUE = 2;

	/**
	 * The '<em><b>ENUM Fahrstrom 2400V DC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_2400V_DC
	 * @model name="ENUMFahrstrom_2400V_DC" literal="2400V_DC"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_2400V_DC_VALUE = 3;

	/**
	 * The '<em><b>ENUM Fahrstrom 25k V50 Hz</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_25K_V50_HZ
	 * @model name="ENUMFahrstrom_25kV_50Hz" literal="25kV_50Hz"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_25K_V50_HZ_VALUE = 4;

	/**
	 * The '<em><b>ENUM Fahrstrom 3000V DC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_3000V_DC
	 * @model name="ENUMFahrstrom_3000V_DC" literal="3000V_DC"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_3000V_DC_VALUE = 5;

	/**
	 * The '<em><b>ENUM Fahrstrom 750V DC Stromschiene</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_750V_DC_STROMSCHIENE
	 * @model name="ENUMFahrstrom_750V_DC_Stromschiene" literal="750V_DC_Stromschiene"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_750V_DC_STROMSCHIENE_VALUE = 6;

	/**
	 * The '<em><b>ENUM Fahrstrom sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_FAHRSTROM_SONSTIGE
	 * @model name="ENUMFahrstrom_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_FAHRSTROM_SONSTIGE_VALUE = 7;

	/**
	 * An array of all the '<em><b>ENUM Fahrstrom</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMFahrstrom[] VALUES_ARRAY =
		new ENUMFahrstrom[] {
			ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE,
			ENUM_FAHRSTROM_1500V_DC,
			ENUM_FAHRSTROM_15K_V16_7HZ,
			ENUM_FAHRSTROM_2400V_DC,
			ENUM_FAHRSTROM_25K_V50_HZ,
			ENUM_FAHRSTROM_3000V_DC,
			ENUM_FAHRSTROM_750V_DC_STROMSCHIENE,
			ENUM_FAHRSTROM_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Fahrstrom</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMFahrstrom> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Fahrstrom</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMFahrstrom get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMFahrstrom result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Fahrstrom</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMFahrstrom getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMFahrstrom result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Fahrstrom</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMFahrstrom get(int value) {
		switch (value) {
			case ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE_VALUE: return ENUM_FAHRSTROM_1200V_DC_STROMSCHIENE;
			case ENUM_FAHRSTROM_1500V_DC_VALUE: return ENUM_FAHRSTROM_1500V_DC;
			case ENUM_FAHRSTROM_15K_V16_7HZ_VALUE: return ENUM_FAHRSTROM_15K_V16_7HZ;
			case ENUM_FAHRSTROM_2400V_DC_VALUE: return ENUM_FAHRSTROM_2400V_DC;
			case ENUM_FAHRSTROM_25K_V50_HZ_VALUE: return ENUM_FAHRSTROM_25K_V50_HZ;
			case ENUM_FAHRSTROM_3000V_DC_VALUE: return ENUM_FAHRSTROM_3000V_DC;
			case ENUM_FAHRSTROM_750V_DC_STROMSCHIENE_VALUE: return ENUM_FAHRSTROM_750V_DC_STROMSCHIENE;
			case ENUM_FAHRSTROM_SONSTIGE_VALUE: return ENUM_FAHRSTROM_SONSTIGE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMFahrstrom(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMFahrstrom
