/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Bahnuebergang.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model11001.Bahnuebergang.util.BahnuebergangAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BahnuebergangItemProviderAdapterFactory extends BahnuebergangAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BahnuebergangItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Abstand_Gehweg_Fahrbahn_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_Gehweg_Fahrbahn_TypeClassItemProvider abstand_Gehweg_Fahrbahn_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Abstand_Gehweg_Fahrbahn_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_Gehweg_Fahrbahn_TypeClassAdapter() {
		if (abstand_Gehweg_Fahrbahn_TypeClassItemProvider == null) {
			abstand_Gehweg_Fahrbahn_TypeClassItemProvider = new Abstand_Gehweg_Fahrbahn_TypeClassItemProvider(this);
		}

		return abstand_Gehweg_Fahrbahn_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Akustik_Fussgaenger_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Akustik_Fussgaenger_TypeClassItemProvider akustik_Fussgaenger_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Akustik_Fussgaenger_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkustik_Fussgaenger_TypeClassAdapter() {
		if (akustik_Fussgaenger_TypeClassItemProvider == null) {
			akustik_Fussgaenger_TypeClassItemProvider = new Akustik_Fussgaenger_TypeClassItemProvider(this);
		}

		return akustik_Fussgaenger_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Ausrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausrichtung_TypeClassItemProvider ausrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Ausrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusrichtung_TypeClassAdapter() {
		if (ausrichtung_TypeClassItemProvider == null) {
			ausrichtung_TypeClassItemProvider = new Ausrichtung_TypeClassItemProvider(this);
		}

		return ausrichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Ausrichtung_Winkel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausrichtung_Winkel_TypeClassItemProvider ausrichtung_Winkel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Ausrichtung_Winkel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusrichtung_Winkel_TypeClassAdapter() {
		if (ausrichtung_Winkel_TypeClassItemProvider == null) {
			ausrichtung_Winkel_TypeClassItemProvider = new Ausrichtung_Winkel_TypeClassItemProvider(this);
		}

		return ausrichtung_Winkel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Auto_Het_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Auto_Het_TypeClassItemProvider auto_Het_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Auto_Het_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuto_Het_TypeClassAdapter() {
		if (auto_Het_TypeClassItemProvider == null) {
			auto_Het_TypeClassItemProvider = new Auto_Het_TypeClassItemProvider(this);
		}

		return auto_Het_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Baulast_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Baulast_TypeClassItemProvider baulast_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Baulast_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaulast_TypeClassAdapter() {
		if (baulast_TypeClassItemProvider == null) {
			baulast_TypeClassItemProvider = new Baulast_TypeClassItemProvider(this);
		}

		return baulast_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Baumprofil_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Baumprofil_TypeClassItemProvider baumprofil_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Baumprofil_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaumprofil_TypeClassAdapter() {
		if (baumprofil_TypeClassItemProvider == null) {
			baumprofil_TypeClassItemProvider = new Baumprofil_TypeClassItemProvider(this);
		}

		return baumprofil_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Beeinflussung_Strassenverkehr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Beeinflussung_Strassenverkehr_TypeClassItemProvider beeinflussung_Strassenverkehr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Beeinflussung_Strassenverkehr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBeeinflussung_Strassenverkehr_TypeClassAdapter() {
		if (beeinflussung_Strassenverkehr_TypeClassItemProvider == null) {
			beeinflussung_Strassenverkehr_TypeClassItemProvider = new Beeinflussung_Strassenverkehr_TypeClassItemProvider(this);
		}

		return beeinflussung_Strassenverkehr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Bez_Schrankenantrieb_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bez_Schrankenantrieb_TypeClassItemProvider bez_Schrankenantrieb_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Bez_Schrankenantrieb_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBez_Schrankenantrieb_TypeClassAdapter() {
		if (bez_Schrankenantrieb_TypeClassItemProvider == null) {
			bez_Schrankenantrieb_TypeClassItemProvider = new Bez_Schrankenantrieb_TypeClassItemProvider(this);
		}

		return bez_Schrankenantrieb_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_BUE_GFR_Eckpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_BUE_GFR_Eckpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_BUE_GFR_Eckpunkt_TypeClassAdapter() {
		if (bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider == null) {
			bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider = new Bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider(this);
		}

		return bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_GFR_Element_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_GFR_Element_TypeClassItemProvider bezeichnung_GFR_Element_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_GFR_Element_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_GFR_Element_TypeClassAdapter() {
		if (bezeichnung_GFR_Element_TypeClassItemProvider == null) {
			bezeichnung_GFR_Element_TypeClassItemProvider = new Bezeichnung_GFR_Element_TypeClassItemProvider(this);
		}

		return bezeichnung_GFR_Element_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_GFR_Tripelspiegel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_GFR_Tripelspiegel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_GFR_Tripelspiegel_TypeClassAdapter() {
		if (bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider == null) {
			bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider = new Bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider(this);
		}

		return bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_Verkehrszeichen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Verkehrszeichen_TypeClassItemProvider bezeichnung_Verkehrszeichen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Bezeichnung_Verkehrszeichen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Verkehrszeichen_TypeClassAdapter() {
		if (bezeichnung_Verkehrszeichen_TypeClassItemProvider == null) {
			bezeichnung_Verkehrszeichen_TypeClassItemProvider = new Bezeichnung_Verkehrszeichen_TypeClassItemProvider(this);
		}

		return bezeichnung_Verkehrszeichen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Blitzpfeil_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Blitzpfeil_TypeClassItemProvider blitzpfeil_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Blitzpfeil_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlitzpfeil_TypeClassAdapter() {
		if (blitzpfeil_TypeClassItemProvider == null) {
			blitzpfeil_TypeClassItemProvider = new Blitzpfeil_TypeClassItemProvider(this);
		}

		return blitzpfeil_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Abhaengigkeit_Fue_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Abhaengigkeit_Fue_AttributeGroupItemProvider buE_Abhaengigkeit_Fue_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Abhaengigkeit_Fue_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Abhaengigkeit_Fue_AttributeGroupAdapter() {
		if (buE_Abhaengigkeit_Fue_AttributeGroupItemProvider == null) {
			buE_Abhaengigkeit_Fue_AttributeGroupItemProvider = new BUE_Abhaengigkeit_Fue_AttributeGroupItemProvider(this);
		}

		return buE_Abhaengigkeit_Fue_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_AnlageItemProvider buE_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_AnlageAdapter() {
		if (buE_AnlageItemProvider == null) {
			buE_AnlageItemProvider = new BUE_AnlageItemProvider(this);
		}

		return buE_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Anlage_Allg_AttributeGroupItemProvider buE_Anlage_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Anlage_Allg_AttributeGroupAdapter() {
		if (buE_Anlage_Allg_AttributeGroupItemProvider == null) {
			buE_Anlage_Allg_AttributeGroupItemProvider = new BUE_Anlage_Allg_AttributeGroupItemProvider(this);
		}

		return buE_Anlage_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Fuss_Rad_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Anlage_Fuss_Rad_AttributeGroupItemProvider buE_Anlage_Fuss_Rad_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Fuss_Rad_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Anlage_Fuss_Rad_AttributeGroupAdapter() {
		if (buE_Anlage_Fuss_Rad_AttributeGroupItemProvider == null) {
			buE_Anlage_Fuss_Rad_AttributeGroupItemProvider = new BUE_Anlage_Fuss_Rad_AttributeGroupItemProvider(this);
		}

		return buE_Anlage_Fuss_Rad_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Strasse} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Anlage_StrasseItemProvider buE_Anlage_StrasseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Strasse}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Anlage_StrasseAdapter() {
		if (buE_Anlage_StrasseItemProvider == null) {
			buE_Anlage_StrasseItemProvider = new BUE_Anlage_StrasseItemProvider(this);
		}

		return buE_Anlage_StrasseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Strasse_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Anlage_Strasse_Allg_AttributeGroupItemProvider buE_Anlage_Strasse_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_Strasse_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Anlage_Strasse_Allg_AttributeGroupAdapter() {
		if (buE_Anlage_Strasse_Allg_AttributeGroupItemProvider == null) {
			buE_Anlage_Strasse_Allg_AttributeGroupItemProvider = new BUE_Anlage_Strasse_Allg_AttributeGroupItemProvider(this);
		}

		return buE_Anlage_Strasse_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_V} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Anlage_VItemProvider buE_Anlage_VItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_V}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Anlage_VAdapter() {
		if (buE_Anlage_VItemProvider == null) {
			buE_Anlage_VItemProvider = new BUE_Anlage_VItemProvider(this);
		}

		return buE_Anlage_VItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_V_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Anlage_V_Allg_AttributeGroupItemProvider buE_Anlage_V_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Anlage_V_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Anlage_V_Allg_AttributeGroupAdapter() {
		if (buE_Anlage_V_Allg_AttributeGroupItemProvider == null) {
			buE_Anlage_V_Allg_AttributeGroupItemProvider = new BUE_Anlage_V_Allg_AttributeGroupItemProvider(this);
		}

		return buE_Anlage_V_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Ausschaltung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_AusschaltungItemProvider buE_AusschaltungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Ausschaltung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_AusschaltungAdapter() {
		if (buE_AusschaltungItemProvider == null) {
			buE_AusschaltungItemProvider = new BUE_AusschaltungItemProvider(this);
		}

		return buE_AusschaltungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Bauart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Bauart_TypeClassItemProvider buE_Bauart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Bauart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Bauart_TypeClassAdapter() {
		if (buE_Bauart_TypeClassItemProvider == null) {
			buE_Bauart_TypeClassItemProvider = new BUE_Bauart_TypeClassItemProvider(this);
		}

		return buE_Bauart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Bedien_Anz_Element_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider buE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Bedien_Anz_Element_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Bedien_Anz_Element_Allg_AttributeGroupAdapter() {
		if (buE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider == null) {
			buE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider = new BUE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider(this);
		}

		return buE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Bedien_Anzeige_Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Bedien_Anzeige_ElementItemProvider buE_Bedien_Anzeige_ElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Bedien_Anzeige_Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Bedien_Anzeige_ElementAdapter() {
		if (buE_Bedien_Anzeige_ElementItemProvider == null) {
			buE_Bedien_Anzeige_ElementItemProvider = new BUE_Bedien_Anzeige_ElementItemProvider(this);
		}

		return buE_Bedien_Anzeige_ElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Buestra_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Buestra_TypeClassItemProvider buE_Buestra_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Buestra_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Buestra_TypeClassAdapter() {
		if (buE_Buestra_TypeClassItemProvider == null) {
			buE_Buestra_TypeClassItemProvider = new BUE_Buestra_TypeClassItemProvider(this);
		}

		return buE_Buestra_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Deckendes_Signal_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Deckendes_Signal_ZuordnungItemProvider buE_Deckendes_Signal_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Deckendes_Signal_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Deckendes_Signal_ZuordnungAdapter() {
		if (buE_Deckendes_Signal_ZuordnungItemProvider == null) {
			buE_Deckendes_Signal_ZuordnungItemProvider = new BUE_Deckendes_Signal_ZuordnungItemProvider(this);
		}

		return buE_Deckendes_Signal_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Einschaltung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_EinschaltungItemProvider buE_EinschaltungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Einschaltung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_EinschaltungAdapter() {
		if (buE_EinschaltungItemProvider == null) {
			buE_EinschaltungItemProvider = new BUE_EinschaltungItemProvider(this);
		}

		return buE_EinschaltungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Einschaltung_Hp_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Einschaltung_Hp_AttributeGroupItemProvider buE_Einschaltung_Hp_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Einschaltung_Hp_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Einschaltung_Hp_AttributeGroupAdapter() {
		if (buE_Einschaltung_Hp_AttributeGroupItemProvider == null) {
			buE_Einschaltung_Hp_AttributeGroupItemProvider = new BUE_Einschaltung_Hp_AttributeGroupItemProvider(this);
		}

		return buE_Einschaltung_Hp_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Einschaltung_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Einschaltung_ZuordnungItemProvider buE_Einschaltung_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Einschaltung_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Einschaltung_ZuordnungAdapter() {
		if (buE_Einschaltung_ZuordnungItemProvider == null) {
			buE_Einschaltung_ZuordnungItemProvider = new BUE_Einschaltung_ZuordnungItemProvider(this);
		}

		return buE_Einschaltung_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Funktionsueberwachung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Funktionsueberwachung_TypeClassItemProvider buE_Funktionsueberwachung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Funktionsueberwachung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Funktionsueberwachung_TypeClassAdapter() {
		if (buE_Funktionsueberwachung_TypeClassItemProvider == null) {
			buE_Funktionsueberwachung_TypeClassItemProvider = new BUE_Funktionsueberwachung_TypeClassItemProvider(this);
		}

		return buE_Funktionsueberwachung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Gefahrraum_Eckpunkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Gefahrraum_EckpunktItemProvider buE_Gefahrraum_EckpunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Gefahrraum_Eckpunkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Gefahrraum_EckpunktAdapter() {
		if (buE_Gefahrraum_EckpunktItemProvider == null) {
			buE_Gefahrraum_EckpunktItemProvider = new BUE_Gefahrraum_EckpunktItemProvider(this);
		}

		return buE_Gefahrraum_EckpunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider buE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupAdapter() {
		if (buE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider == null) {
			buE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider = new BUE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return buE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Gleisbezogener_Gefahrraum} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Gleisbezogener_GefahrraumItemProvider buE_Gleisbezogener_GefahrraumItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Gleisbezogener_Gefahrraum}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Gleisbezogener_GefahrraumAdapter() {
		if (buE_Gleisbezogener_GefahrraumItemProvider == null) {
			buE_Gleisbezogener_GefahrraumItemProvider = new BUE_Gleisbezogener_GefahrraumItemProvider(this);
		}

		return buE_Gleisbezogener_GefahrraumItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Handschalteinrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Handschalteinrichtung_TypeClassItemProvider buE_Handschalteinrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Handschalteinrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Handschalteinrichtung_TypeClassAdapter() {
		if (buE_Handschalteinrichtung_TypeClassItemProvider == null) {
			buE_Handschalteinrichtung_TypeClassItemProvider = new BUE_Handschalteinrichtung_TypeClassItemProvider(this);
		}

		return buE_Handschalteinrichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Kante} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_KanteItemProvider buE_KanteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Kante}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_KanteAdapter() {
		if (buE_KanteItemProvider == null) {
			buE_KanteItemProvider = new BUE_KanteItemProvider(this);
		}

		return buE_KanteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Kreuzungsplan} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_KreuzungsplanItemProvider buE_KreuzungsplanItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Kreuzungsplan}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_KreuzungsplanAdapter() {
		if (buE_KreuzungsplanItemProvider == null) {
			buE_KreuzungsplanItemProvider = new BUE_KreuzungsplanItemProvider(this);
		}

		return buE_KreuzungsplanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Kreuzungsplan_Koordinaten_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider buE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Kreuzungsplan_Koordinaten_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Kreuzungsplan_Koordinaten_AttributeGroupAdapter() {
		if (buE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider == null) {
			buE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider = new BUE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider(this);
		}

		return buE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Mit_GFR_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Mit_GFR_TypeClassItemProvider buE_Mit_GFR_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Mit_GFR_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Mit_GFR_TypeClassAdapter() {
		if (buE_Mit_GFR_TypeClassItemProvider == null) {
			buE_Mit_GFR_TypeClassItemProvider = new BUE_Mit_GFR_TypeClassItemProvider(this);
		}

		return buE_Mit_GFR_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Nachlaufzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Nachlaufzeit_TypeClassItemProvider buE_Nachlaufzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Nachlaufzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Nachlaufzeit_TypeClassAdapter() {
		if (buE_Nachlaufzeit_TypeClassItemProvider == null) {
			buE_Nachlaufzeit_TypeClassItemProvider = new BUE_Nachlaufzeit_TypeClassItemProvider(this);
		}

		return buE_Nachlaufzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Neigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Neigung_TypeClassItemProvider buE_Neigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Neigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Neigung_TypeClassAdapter() {
		if (buE_Neigung_TypeClassItemProvider == null) {
			buE_Neigung_TypeClassItemProvider = new BUE_Neigung_TypeClassItemProvider(this);
		}

		return buE_Neigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Schnittstelle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_SchnittstelleItemProvider buE_SchnittstelleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Schnittstelle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_SchnittstelleAdapter() {
		if (buE_SchnittstelleItemProvider == null) {
			buE_SchnittstelleItemProvider = new BUE_SchnittstelleItemProvider(this);
		}

		return buE_SchnittstelleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Schnittstelle_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Schnittstelle_Allg_AttributeGroupItemProvider buE_Schnittstelle_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Schnittstelle_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Schnittstelle_Allg_AttributeGroupAdapter() {
		if (buE_Schnittstelle_Allg_AttributeGroupItemProvider == null) {
			buE_Schnittstelle_Allg_AttributeGroupItemProvider = new BUE_Schnittstelle_Allg_AttributeGroupItemProvider(this);
		}

		return buE_Schnittstelle_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Sicherungsart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Sicherungsart_TypeClassItemProvider buE_Sicherungsart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Sicherungsart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Sicherungsart_TypeClassAdapter() {
		if (buE_Sicherungsart_TypeClassItemProvider == null) {
			buE_Sicherungsart_TypeClassItemProvider = new BUE_Sicherungsart_TypeClassItemProvider(this);
		}

		return buE_Sicherungsart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Sicherungszeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Sicherungszeit_TypeClassItemProvider buE_Sicherungszeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Sicherungszeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Sicherungszeit_TypeClassAdapter() {
		if (buE_Sicherungszeit_TypeClassItemProvider == null) {
			buE_Sicherungszeit_TypeClassItemProvider = new BUE_Sicherungszeit_TypeClassItemProvider(this);
		}

		return buE_Sicherungszeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Spezifisches_Signal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Spezifisches_SignalItemProvider buE_Spezifisches_SignalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Spezifisches_Signal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Spezifisches_SignalAdapter() {
		if (buE_Spezifisches_SignalItemProvider == null) {
			buE_Spezifisches_SignalItemProvider = new BUE_Spezifisches_SignalItemProvider(this);
		}

		return buE_Spezifisches_SignalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Strasse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Strasse_TypeClassItemProvider buE_Strasse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Strasse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Strasse_TypeClassAdapter() {
		if (buE_Strasse_TypeClassItemProvider == null) {
			buE_Strasse_TypeClassItemProvider = new BUE_Strasse_TypeClassItemProvider(this);
		}

		return buE_Strasse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Technik_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Technik_TypeClassItemProvider buE_Technik_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Technik_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Technik_TypeClassAdapter() {
		if (buE_Technik_TypeClassItemProvider == null) {
			buE_Technik_TypeClassItemProvider = new BUE_Technik_TypeClassItemProvider(this);
		}

		return buE_Technik_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Vorlaufzeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_Vorlaufzeit_TypeClassItemProvider buE_Vorlaufzeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_Vorlaufzeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_Vorlaufzeit_TypeClassAdapter() {
		if (buE_Vorlaufzeit_TypeClassItemProvider == null) {
			buE_Vorlaufzeit_TypeClassItemProvider = new BUE_Vorlaufzeit_TypeClassItemProvider(this);
		}

		return buE_Vorlaufzeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_WS_Fstr_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BUE_WS_Fstr_ZuordnungItemProvider buE_WS_Fstr_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.BUE_WS_Fstr_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBUE_WS_Fstr_ZuordnungAdapter() {
		if (buE_WS_Fstr_ZuordnungItemProvider == null) {
			buE_WS_Fstr_ZuordnungItemProvider = new BUE_WS_Fstr_ZuordnungItemProvider(this);
		}

		return buE_WS_Fstr_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Einschaltverz_Errechnet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einschaltverz_Errechnet_TypeClassItemProvider einschaltverz_Errechnet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Einschaltverz_Errechnet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinschaltverz_Errechnet_TypeClassAdapter() {
		if (einschaltverz_Errechnet_TypeClassItemProvider == null) {
			einschaltverz_Errechnet_TypeClassItemProvider = new Einschaltverz_Errechnet_TypeClassItemProvider(this);
		}

		return einschaltverz_Errechnet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Einschaltverz_Gewaehlt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einschaltverz_Gewaehlt_TypeClassItemProvider einschaltverz_Gewaehlt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Einschaltverz_Gewaehlt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinschaltverz_Gewaehlt_TypeClassAdapter() {
		if (einschaltverz_Gewaehlt_TypeClassItemProvider == null) {
			einschaltverz_Gewaehlt_TypeClassItemProvider = new Einschaltverz_Gewaehlt_TypeClassItemProvider(this);
		}

		return einschaltverz_Gewaehlt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Ersatzstecker_Gleisbezogen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ersatzstecker_Gleisbezogen_TypeClassItemProvider ersatzstecker_Gleisbezogen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Ersatzstecker_Gleisbezogen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErsatzstecker_Gleisbezogen_TypeClassAdapter() {
		if (ersatzstecker_Gleisbezogen_TypeClassItemProvider == null) {
			ersatzstecker_Gleisbezogen_TypeClassItemProvider = new Ersatzstecker_Gleisbezogen_TypeClassItemProvider(this);
		}

		return ersatzstecker_Gleisbezogen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Fahrbahn_Befestigung_Gleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fahrbahn_Befestigung_Gleis_TypeClassItemProvider fahrbahn_Befestigung_Gleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Fahrbahn_Befestigung_Gleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFahrbahn_Befestigung_Gleis_TypeClassAdapter() {
		if (fahrbahn_Befestigung_Gleis_TypeClassItemProvider == null) {
			fahrbahn_Befestigung_Gleis_TypeClassItemProvider = new Fahrbahn_Befestigung_Gleis_TypeClassItemProvider(this);
		}

		return fahrbahn_Befestigung_Gleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Fahrbahn_Befestigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fahrbahn_Befestigung_TypeClassItemProvider fahrbahn_Befestigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Fahrbahn_Befestigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFahrbahn_Befestigung_TypeClassAdapter() {
		if (fahrbahn_Befestigung_TypeClassItemProvider == null) {
			fahrbahn_Befestigung_TypeClassItemProvider = new Fahrbahn_Befestigung_TypeClassItemProvider(this);
		}

		return fahrbahn_Befestigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Fahrbahn_Breite_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fahrbahn_Breite_TypeClassItemProvider fahrbahn_Breite_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Fahrbahn_Breite_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFahrbahn_Breite_TypeClassAdapter() {
		if (fahrbahn_Breite_TypeClassItemProvider == null) {
			fahrbahn_Breite_TypeClassItemProvider = new Fahrbahn_Breite_TypeClassItemProvider(this);
		}

		return fahrbahn_Breite_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Fue_Schaltfall_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fue_Schaltfall_TypeClassItemProvider fue_Schaltfall_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Fue_Schaltfall_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFue_Schaltfall_TypeClassAdapter() {
		if (fue_Schaltfall_TypeClassItemProvider == null) {
			fue_Schaltfall_TypeClassItemProvider = new Fue_Schaltfall_TypeClassItemProvider(this);
		}

		return fue_Schaltfall_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Fuss_Radweg_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fuss_Radweg_Art_TypeClassItemProvider fuss_Radweg_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Fuss_Radweg_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFuss_Radweg_Art_TypeClassAdapter() {
		if (fuss_Radweg_Art_TypeClassItemProvider == null) {
			fuss_Radweg_Art_TypeClassItemProvider = new Fuss_Radweg_Art_TypeClassItemProvider(this);
		}

		return fuss_Radweg_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Fuss_Radweg_Seite_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fuss_Radweg_Seite_TypeClassItemProvider fuss_Radweg_Seite_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Fuss_Radweg_Seite_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFuss_Radweg_Seite_TypeClassAdapter() {
		if (fuss_Radweg_Seite_TypeClassItemProvider == null) {
			fuss_Radweg_Seite_TypeClassItemProvider = new Fuss_Radweg_Seite_TypeClassItemProvider(this);
		}

		return fuss_Radweg_Seite_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_AnlageItemProvider gfR_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_AnlageAdapter() {
		if (gfR_AnlageItemProvider == null) {
			gfR_AnlageItemProvider = new GFR_AnlageItemProvider(this);
		}

		return gfR_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Anlage_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Anlage_Allg_AttributeGroupItemProvider gfR_Anlage_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Anlage_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Anlage_Allg_AttributeGroupAdapter() {
		if (gfR_Anlage_Allg_AttributeGroupItemProvider == null) {
			gfR_Anlage_Allg_AttributeGroupItemProvider = new GFR_Anlage_Allg_AttributeGroupItemProvider(this);
		}

		return gfR_Anlage_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Art_TypeClassItemProvider gfR_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Art_TypeClassAdapter() {
		if (gfR_Art_TypeClassItemProvider == null) {
			gfR_Art_TypeClassItemProvider = new GFR_Art_TypeClassItemProvider(this);
		}

		return gfR_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_ElementItemProvider gfR_ElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_ElementAdapter() {
		if (gfR_ElementItemProvider == null) {
			gfR_ElementItemProvider = new GFR_ElementItemProvider(this);
		}

		return gfR_ElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Element_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Element_Bezeichnung_AttributeGroupItemProvider gfR_Element_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Element_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Element_Bezeichnung_AttributeGroupAdapter() {
		if (gfR_Element_Bezeichnung_AttributeGroupItemProvider == null) {
			gfR_Element_Bezeichnung_AttributeGroupItemProvider = new GFR_Element_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return gfR_Element_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Neigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Neigung_TypeClassItemProvider gfR_Neigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Neigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Neigung_TypeClassAdapter() {
		if (gfR_Neigung_TypeClassItemProvider == null) {
			gfR_Neigung_TypeClassItemProvider = new GFR_Neigung_TypeClassItemProvider(this);
		}

		return gfR_Neigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Tripelspiegel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_TripelspiegelItemProvider gfR_TripelspiegelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Tripelspiegel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_TripelspiegelAdapter() {
		if (gfR_TripelspiegelItemProvider == null) {
			gfR_TripelspiegelItemProvider = new GFR_TripelspiegelItemProvider(this);
		}

		return gfR_TripelspiegelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Tripelspiegel_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Tripelspiegel_Allg_AttributeGroupItemProvider gfR_Tripelspiegel_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Tripelspiegel_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Tripelspiegel_Allg_AttributeGroupAdapter() {
		if (gfR_Tripelspiegel_Allg_AttributeGroupItemProvider == null) {
			gfR_Tripelspiegel_Allg_AttributeGroupItemProvider = new GFR_Tripelspiegel_Allg_AttributeGroupItemProvider(this);
		}

		return gfR_Tripelspiegel_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Tripelspiegel_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider gfR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Tripelspiegel_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Tripelspiegel_Bezeichnung_AttributeGroupAdapter() {
		if (gfR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider == null) {
			gfR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider = new GFR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return gfR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFR_Typ_TypeClassItemProvider gfR_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.GFR_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFR_Typ_TypeClassAdapter() {
		if (gfR_Typ_TypeClassItemProvider == null) {
			gfR_Typ_TypeClassItemProvider = new GFR_Typ_TypeClassItemProvider(this);
		}

		return gfR_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Gitterbehang_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gitterbehang_TypeClassItemProvider gitterbehang_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Gitterbehang_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGitterbehang_TypeClassAdapter() {
		if (gitterbehang_TypeClassItemProvider == null) {
			gitterbehang_TypeClassItemProvider = new Gitterbehang_TypeClassItemProvider(this);
		}

		return gitterbehang_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Gleis_Am_Bue_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gleis_Am_Bue_TypeClassItemProvider gleis_Am_Bue_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Gleis_Am_Bue_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGleis_Am_Bue_TypeClassAdapter() {
		if (gleis_Am_Bue_TypeClassItemProvider == null) {
			gleis_Am_Bue_TypeClassItemProvider = new Gleis_Am_Bue_TypeClassItemProvider(this);
		}

		return gleis_Am_Bue_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Haltezeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Haltezeit_TypeClassItemProvider haltezeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Haltezeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHaltezeit_TypeClassAdapter() {
		if (haltezeit_TypeClassItemProvider == null) {
			haltezeit_TypeClassItemProvider = new Haltezeit_TypeClassItemProvider(this);
		}

		return haltezeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Hersteller_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hersteller_TypeClassItemProvider hersteller_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Hersteller_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHersteller_TypeClassAdapter() {
		if (hersteller_TypeClassItemProvider == null) {
			hersteller_TypeClassItemProvider = new Hersteller_TypeClassItemProvider(this);
		}

		return hersteller_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Hp_Ersatzstecker_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hp_Ersatzstecker_TypeClassItemProvider hp_Ersatzstecker_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Hp_Ersatzstecker_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHp_Ersatzstecker_TypeClassAdapter() {
		if (hp_Ersatzstecker_TypeClassItemProvider == null) {
			hp_Ersatzstecker_TypeClassItemProvider = new Hp_Ersatzstecker_TypeClassItemProvider(this);
		}

		return hp_Ersatzstecker_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Klassifizierung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Klassifizierung_TypeClassItemProvider klassifizierung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Klassifizierung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKlassifizierung_TypeClassAdapter() {
		if (klassifizierung_TypeClassItemProvider == null) {
			klassifizierung_TypeClassItemProvider = new Klassifizierung_TypeClassItemProvider(this);
		}

		return klassifizierung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Kontrastblende_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kontrastblende_TypeClassItemProvider kontrastblende_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Kontrastblende_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKontrastblende_TypeClassAdapter() {
		if (kontrastblende_TypeClassItemProvider == null) {
			kontrastblende_TypeClassItemProvider = new Kontrastblende_TypeClassItemProvider(this);
		}

		return kontrastblende_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Kreuzungswinkel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kreuzungswinkel_TypeClassItemProvider kreuzungswinkel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Kreuzungswinkel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKreuzungswinkel_TypeClassAdapter() {
		if (kreuzungswinkel_TypeClassItemProvider == null) {
			kreuzungswinkel_TypeClassItemProvider = new Kreuzungswinkel_TypeClassItemProvider(this);
		}

		return kreuzungswinkel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Kurzzugschaltung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Kurzzugschaltung_TypeClassItemProvider kurzzugschaltung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Kurzzugschaltung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKurzzugschaltung_TypeClassAdapter() {
		if (kurzzugschaltung_TypeClassItemProvider == null) {
			kurzzugschaltung_TypeClassItemProvider = new Kurzzugschaltung_TypeClassItemProvider(this);
		}

		return kurzzugschaltung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Lagerung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lagerung_Art_TypeClassItemProvider lagerung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Lagerung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLagerung_Art_TypeClassAdapter() {
		if (lagerung_Art_TypeClassItemProvider == null) {
			lagerung_Art_TypeClassItemProvider = new Lagerung_Art_TypeClassItemProvider(this);
		}

		return lagerung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.LFUE_Impuls_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LFUE_Impuls_TypeClassItemProvider lfuE_Impuls_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.LFUE_Impuls_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLFUE_Impuls_TypeClassAdapter() {
		if (lfuE_Impuls_TypeClassItemProvider == null) {
			lfuE_Impuls_TypeClassItemProvider = new LFUE_Impuls_TypeClassItemProvider(this);
		}

		return lfuE_Impuls_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Lieferlaenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lieferlaenge_TypeClassItemProvider lieferlaenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Lieferlaenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLieferlaenge_TypeClassAdapter() {
		if (lieferlaenge_TypeClassItemProvider == null) {
			lieferlaenge_TypeClassItemProvider = new Lieferlaenge_TypeClassItemProvider(this);
		}

		return lieferlaenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Montage_Ausgleichsgewichte_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Montage_Ausgleichsgewichte_TypeClassItemProvider montage_Ausgleichsgewichte_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Montage_Ausgleichsgewichte_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMontage_Ausgleichsgewichte_TypeClassAdapter() {
		if (montage_Ausgleichsgewichte_TypeClassItemProvider == null) {
			montage_Ausgleichsgewichte_TypeClassItemProvider = new Montage_Ausgleichsgewichte_TypeClassItemProvider(this);
		}

		return montage_Ausgleichsgewichte_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Montage_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Montage_Besonders_TypeClassItemProvider montage_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Montage_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMontage_Besonders_TypeClassAdapter() {
		if (montage_Besonders_TypeClassItemProvider == null) {
			montage_Besonders_TypeClassItemProvider = new Montage_Besonders_TypeClassItemProvider(this);
		}

		return montage_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Montagehoehe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Montagehoehe_TypeClassItemProvider montagehoehe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Montagehoehe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMontagehoehe_TypeClassAdapter() {
		if (montagehoehe_TypeClassItemProvider == null) {
			montagehoehe_TypeClassItemProvider = new Montagehoehe_TypeClassItemProvider(this);
		}

		return montagehoehe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Optik_Durchmesser_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Optik_Durchmesser_TypeClassItemProvider optik_Durchmesser_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Optik_Durchmesser_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOptik_Durchmesser_TypeClassAdapter() {
		if (optik_Durchmesser_TypeClassItemProvider == null) {
			optik_Durchmesser_TypeClassItemProvider = new Optik_Durchmesser_TypeClassItemProvider(this);
		}

		return optik_Durchmesser_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Optik_Symbolmaske_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Optik_Symbolmaske_TypeClassItemProvider optik_Symbolmaske_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Optik_Symbolmaske_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOptik_Symbolmaske_TypeClassAdapter() {
		if (optik_Symbolmaske_TypeClassItemProvider == null) {
			optik_Symbolmaske_TypeClassItemProvider = new Optik_Symbolmaske_TypeClassItemProvider(this);
		}

		return optik_Symbolmaske_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Pegel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Pegel_TypeClassItemProvider pegel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Pegel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPegel_TypeClassAdapter() {
		if (pegel_TypeClassItemProvider == null) {
			pegel_TypeClassItemProvider = new Pegel_TypeClassItemProvider(this);
		}

		return pegel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Pixel_Koordinate_X_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Pixel_Koordinate_X_TypeClassItemProvider pixel_Koordinate_X_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Pixel_Koordinate_X_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPixel_Koordinate_X_TypeClassAdapter() {
		if (pixel_Koordinate_X_TypeClassItemProvider == null) {
			pixel_Koordinate_X_TypeClassItemProvider = new Pixel_Koordinate_X_TypeClassItemProvider(this);
		}

		return pixel_Koordinate_X_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Pixel_Koordinate_Y_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Pixel_Koordinate_Y_TypeClassItemProvider pixel_Koordinate_Y_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Pixel_Koordinate_Y_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPixel_Koordinate_Y_TypeClassAdapter() {
		if (pixel_Koordinate_Y_TypeClassItemProvider == null) {
			pixel_Koordinate_Y_TypeClassItemProvider = new Pixel_Koordinate_Y_TypeClassItemProvider(this);
		}

		return pixel_Koordinate_Y_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DAB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Raeumstrecke_DAB_TypeClassItemProvider raeumstrecke_DAB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DAB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRaeumstrecke_DAB_TypeClassAdapter() {
		if (raeumstrecke_DAB_TypeClassItemProvider == null) {
			raeumstrecke_DAB_TypeClassItemProvider = new Raeumstrecke_DAB_TypeClassItemProvider(this);
		}

		return raeumstrecke_DAB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DBK_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Raeumstrecke_DBK_TypeClassItemProvider raeumstrecke_DBK_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DBK_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRaeumstrecke_DBK_TypeClassAdapter() {
		if (raeumstrecke_DBK_TypeClassItemProvider == null) {
			raeumstrecke_DBK_TypeClassItemProvider = new Raeumstrecke_DBK_TypeClassItemProvider(this);
		}

		return raeumstrecke_DBK_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DCK_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Raeumstrecke_DCK_TypeClassItemProvider raeumstrecke_DCK_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DCK_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRaeumstrecke_DCK_TypeClassAdapter() {
		if (raeumstrecke_DCK_TypeClassItemProvider == null) {
			raeumstrecke_DCK_TypeClassItemProvider = new Raeumstrecke_DCK_TypeClassItemProvider(this);
		}

		return raeumstrecke_DCK_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DSK_Strich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Raeumstrecke_DSK_Strich_TypeClassItemProvider raeumstrecke_DSK_Strich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_DSK_Strich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRaeumstrecke_DSK_Strich_TypeClassAdapter() {
		if (raeumstrecke_DSK_Strich_TypeClassItemProvider == null) {
			raeumstrecke_DSK_Strich_TypeClassItemProvider = new Raeumstrecke_DSK_Strich_TypeClassItemProvider(this);
		}

		return raeumstrecke_DSK_Strich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Raeumstrecke_TypeClassItemProvider raeumstrecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Raeumstrecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRaeumstrecke_TypeClassAdapter() {
		if (raeumstrecke_TypeClassItemProvider == null) {
			raeumstrecke_TypeClassItemProvider = new Raeumstrecke_TypeClassItemProvider(this);
		}

		return raeumstrecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Richtungspfeil_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Richtungspfeil_TypeClassItemProvider richtungspfeil_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Richtungspfeil_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRichtungspfeil_TypeClassAdapter() {
		if (richtungspfeil_TypeClassItemProvider == null) {
			richtungspfeil_TypeClassItemProvider = new Richtungspfeil_TypeClassItemProvider(this);
		}

		return richtungspfeil_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.SA_Schrankenbaum_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SA_Schrankenbaum_AttributeGroupItemProvider sA_Schrankenbaum_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.SA_Schrankenbaum_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSA_Schrankenbaum_AttributeGroupAdapter() {
		if (sA_Schrankenbaum_AttributeGroupItemProvider == null) {
			sA_Schrankenbaum_AttributeGroupItemProvider = new SA_Schrankenbaum_AttributeGroupItemProvider(this);
		}

		return sA_Schrankenbaum_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Schaltgruppe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schaltgruppe_TypeClassItemProvider schaltgruppe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Schaltgruppe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchaltgruppe_TypeClassAdapter() {
		if (schaltgruppe_TypeClassItemProvider == null) {
			schaltgruppe_TypeClassItemProvider = new Schaltgruppe_TypeClassItemProvider(this);
		}

		return schaltgruppe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Schaltmittel_Fstr_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schaltmittel_Fstr_ZuordnungItemProvider schaltmittel_Fstr_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Schaltmittel_Fstr_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchaltmittel_Fstr_ZuordnungAdapter() {
		if (schaltmittel_Fstr_ZuordnungItemProvider == null) {
			schaltmittel_Fstr_ZuordnungItemProvider = new Schaltmittel_Fstr_ZuordnungItemProvider(this);
		}

		return schaltmittel_Fstr_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Schrankenantrieb} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchrankenantriebItemProvider schrankenantriebItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Schrankenantrieb}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchrankenantriebAdapter() {
		if (schrankenantriebItemProvider == null) {
			schrankenantriebItemProvider = new SchrankenantriebItemProvider(this);
		}

		return schrankenantriebItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Schrankenantrieb_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schrankenantrieb_Allg_AttributeGroupItemProvider schrankenantrieb_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Schrankenantrieb_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchrankenantrieb_Allg_AttributeGroupAdapter() {
		if (schrankenantrieb_Allg_AttributeGroupItemProvider == null) {
			schrankenantrieb_Allg_AttributeGroupItemProvider = new Schrankenantrieb_Allg_AttributeGroupItemProvider(this);
		}

		return schrankenantrieb_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Schrankenantrieb_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schrankenantrieb_Bezeichnung_AttributeGroupItemProvider schrankenantrieb_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Schrankenantrieb_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchrankenantrieb_Bezeichnung_AttributeGroupAdapter() {
		if (schrankenantrieb_Bezeichnung_AttributeGroupItemProvider == null) {
			schrankenantrieb_Bezeichnung_AttributeGroupItemProvider = new Schrankenantrieb_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return schrankenantrieb_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Schutzbuegel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schutzbuegel_TypeClassItemProvider schutzbuegel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Schutzbuegel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchutzbuegel_TypeClassAdapter() {
		if (schutzbuegel_TypeClassItemProvider == null) {
			schutzbuegel_TypeClassItemProvider = new Schutzbuegel_TypeClassItemProvider(this);
		}

		return schutzbuegel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Sicherheitsabstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sicherheitsabstand_TypeClassItemProvider sicherheitsabstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Sicherheitsabstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSicherheitsabstand_TypeClassAdapter() {
		if (sicherheitsabstand_TypeClassItemProvider == null) {
			sicherheitsabstand_TypeClassItemProvider = new Sicherheitsabstand_TypeClassItemProvider(this);
		}

		return sicherheitsabstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Signalverz_Errechnet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalverz_Errechnet_TypeClassItemProvider signalverz_Errechnet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Signalverz_Errechnet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalverz_Errechnet_TypeClassAdapter() {
		if (signalverz_Errechnet_TypeClassItemProvider == null) {
			signalverz_Errechnet_TypeClassItemProvider = new Signalverz_Errechnet_TypeClassItemProvider(this);
		}

		return signalverz_Errechnet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Signalverz_Gewaehlt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalverz_Gewaehlt_TypeClassItemProvider signalverz_Gewaehlt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Signalverz_Gewaehlt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalverz_Gewaehlt_TypeClassAdapter() {
		if (signalverz_Gewaehlt_TypeClassItemProvider == null) {
			signalverz_Gewaehlt_TypeClassItemProvider = new Signalverz_Gewaehlt_TypeClassItemProvider(this);
		}

		return signalverz_Gewaehlt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Sperrlaenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sperrlaenge_TypeClassItemProvider sperrlaenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Sperrlaenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSperrlaenge_TypeClassAdapter() {
		if (sperrlaenge_TypeClassItemProvider == null) {
			sperrlaenge_TypeClassItemProvider = new Sperrlaenge_TypeClassItemProvider(this);
		}

		return sperrlaenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Sperrstrecke_Fussgaenger_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sperrstrecke_Fussgaenger_TypeClassItemProvider sperrstrecke_Fussgaenger_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Sperrstrecke_Fussgaenger_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSperrstrecke_Fussgaenger_TypeClassAdapter() {
		if (sperrstrecke_Fussgaenger_TypeClassItemProvider == null) {
			sperrstrecke_Fussgaenger_TypeClassItemProvider = new Sperrstrecke_Fussgaenger_TypeClassItemProvider(this);
		}

		return sperrstrecke_Fussgaenger_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Sperrstrecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sperrstrecke_TypeClassItemProvider sperrstrecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Sperrstrecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSperrstrecke_TypeClassAdapter() {
		if (sperrstrecke_TypeClassItemProvider == null) {
			sperrstrecke_TypeClassItemProvider = new Sperrstrecke_TypeClassItemProvider(this);
		}

		return sperrstrecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Stoerhalt_Haltfall_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Stoerhalt_Haltfall_TypeClassItemProvider stoerhalt_Haltfall_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Stoerhalt_Haltfall_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStoerhalt_Haltfall_TypeClassAdapter() {
		if (stoerhalt_Haltfall_TypeClassItemProvider == null) {
			stoerhalt_Haltfall_TypeClassItemProvider = new Stoerhalt_Haltfall_TypeClassItemProvider(this);
		}

		return stoerhalt_Haltfall_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Stoerhalt_Merkhinweis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Stoerhalt_Merkhinweis_TypeClassItemProvider stoerhalt_Merkhinweis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Stoerhalt_Merkhinweis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStoerhalt_Merkhinweis_TypeClassAdapter() {
		if (stoerhalt_Merkhinweis_TypeClassItemProvider == null) {
			stoerhalt_Merkhinweis_TypeClassItemProvider = new Stoerhalt_Merkhinweis_TypeClassItemProvider(this);
		}

		return stoerhalt_Merkhinweis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Teilsperrstrecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Teilsperrstrecke_TypeClassItemProvider teilsperrstrecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Teilsperrstrecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTeilsperrstrecke_TypeClassAdapter() {
		if (teilsperrstrecke_TypeClassItemProvider == null) {
			teilsperrstrecke_TypeClassItemProvider = new Teilsperrstrecke_TypeClassItemProvider(this);
		}

		return teilsperrstrecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Teilvorgabezeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Teilvorgabezeit_TypeClassItemProvider teilvorgabezeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Teilvorgabezeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTeilvorgabezeit_TypeClassAdapter() {
		if (teilvorgabezeit_TypeClassItemProvider == null) {
			teilvorgabezeit_TypeClassItemProvider = new Teilvorgabezeit_TypeClassItemProvider(this);
		}

		return teilvorgabezeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Tragkopf_Verstellbar_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Tragkopf_Verstellbar_TypeClassItemProvider tragkopf_Verstellbar_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Tragkopf_Verstellbar_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTragkopf_Verstellbar_TypeClassAdapter() {
		if (tragkopf_Verstellbar_TypeClassItemProvider == null) {
			tragkopf_Verstellbar_TypeClassItemProvider = new Tragkopf_Verstellbar_TypeClassItemProvider(this);
		}

		return tragkopf_Verstellbar_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Max_Schiene_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Max_Schiene_TypeClassItemProvider v_Max_Schiene_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Max_Schiene_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Max_Schiene_TypeClassAdapter() {
		if (v_Max_Schiene_TypeClassItemProvider == null) {
			v_Max_Schiene_TypeClassItemProvider = new V_Max_Schiene_TypeClassItemProvider(this);
		}

		return v_Max_Schiene_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Max_Strasse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Max_Strasse_TypeClassItemProvider v_Max_Strasse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Max_Strasse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Max_Strasse_TypeClassAdapter() {
		if (v_Max_Strasse_TypeClassItemProvider == null) {
			v_Max_Strasse_TypeClassItemProvider = new V_Max_Strasse_TypeClassItemProvider(this);
		}

		return v_Max_Strasse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Min_Fussweg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Min_Fussweg_TypeClassItemProvider v_Min_Fussweg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Min_Fussweg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Min_Fussweg_TypeClassAdapter() {
		if (v_Min_Fussweg_TypeClassItemProvider == null) {
			v_Min_Fussweg_TypeClassItemProvider = new V_Min_Fussweg_TypeClassItemProvider(this);
		}

		return v_Min_Fussweg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Min_Schiene_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Min_Schiene_TypeClassItemProvider v_Min_Schiene_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Min_Schiene_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Min_Schiene_TypeClassAdapter() {
		if (v_Min_Schiene_TypeClassItemProvider == null) {
			v_Min_Schiene_TypeClassItemProvider = new V_Min_Schiene_TypeClassItemProvider(this);
		}

		return v_Min_Schiene_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Min_Strasse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Min_Strasse_TypeClassItemProvider v_Min_Strasse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.V_Min_Strasse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Min_Strasse_TypeClassAdapter() {
		if (v_Min_Strasse_TypeClassItemProvider == null) {
			v_Min_Strasse_TypeClassItemProvider = new V_Min_Strasse_TypeClassItemProvider(this);
		}

		return v_Min_Strasse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VerkehrszeichenItemProvider verkehrszeichenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerkehrszeichenAdapter() {
		if (verkehrszeichenItemProvider == null) {
			verkehrszeichenItemProvider = new VerkehrszeichenItemProvider(this);
		}

		return verkehrszeichenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verkehrszeichen_Allg_AttributeGroupItemProvider verkehrszeichen_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerkehrszeichen_Allg_AttributeGroupAdapter() {
		if (verkehrszeichen_Allg_AttributeGroupItemProvider == null) {
			verkehrszeichen_Allg_AttributeGroupItemProvider = new Verkehrszeichen_Allg_AttributeGroupItemProvider(this);
		}

		return verkehrszeichen_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Andreaskreuz_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Andreaskreuz_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerkehrszeichen_Andreaskreuz_AttributeGroupAdapter() {
		if (verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider == null) {
			verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider = new Verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider(this);
		}

		return verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verkehrszeichen_Bezeichnung_AttributeGroupItemProvider verkehrszeichen_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerkehrszeichen_Bezeichnung_AttributeGroupAdapter() {
		if (verkehrszeichen_Bezeichnung_AttributeGroupItemProvider == null) {
			verkehrszeichen_Bezeichnung_AttributeGroupItemProvider = new Verkehrszeichen_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return verkehrszeichen_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Lz_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verkehrszeichen_Lz_AttributeGroupItemProvider verkehrszeichen_Lz_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Verkehrszeichen_Lz_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerkehrszeichen_Lz_AttributeGroupAdapter() {
		if (verkehrszeichen_Lz_AttributeGroupItemProvider == null) {
			verkehrszeichen_Lz_AttributeGroupItemProvider = new Verkehrszeichen_Lz_AttributeGroupItemProvider(this);
		}

		return verkehrszeichen_Lz_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Vorgeschaltet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vorgeschaltet_TypeClassItemProvider vorgeschaltet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Vorgeschaltet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVorgeschaltet_TypeClassAdapter() {
		if (vorgeschaltet_TypeClassItemProvider == null) {
			vorgeschaltet_TypeClassItemProvider = new Vorgeschaltet_TypeClassItemProvider(this);
		}

		return vorgeschaltet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Vz_Sperrstrecke_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vz_Sperrstrecke_AttributeGroupItemProvider vz_Sperrstrecke_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Vz_Sperrstrecke_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVz_Sperrstrecke_AttributeGroupAdapter() {
		if (vz_Sperrstrecke_AttributeGroupItemProvider == null) {
			vz_Sperrstrecke_AttributeGroupItemProvider = new Vz_Sperrstrecke_AttributeGroupItemProvider(this);
		}

		return vz_Sperrstrecke_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Vz_Sperrstrecke_Schranke_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vz_Sperrstrecke_Schranke_AttributeGroupItemProvider vz_Sperrstrecke_Schranke_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Vz_Sperrstrecke_Schranke_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVz_Sperrstrecke_Schranke_AttributeGroupAdapter() {
		if (vz_Sperrstrecke_Schranke_AttributeGroupItemProvider == null) {
			vz_Sperrstrecke_Schranke_AttributeGroupItemProvider = new Vz_Sperrstrecke_Schranke_AttributeGroupItemProvider(this);
		}

		return vz_Sperrstrecke_Schranke_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Vz_Sperrstrecke_Vorgeschaltet_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Vz_Sperrstrecke_Vorgeschaltet_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVz_Sperrstrecke_Vorgeschaltet_AttributeGroupAdapter() {
		if (vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider == null) {
			vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider = new Vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider(this);
		}

		return vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Winkel_Alpha_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Winkel_Alpha_TypeClassItemProvider winkel_Alpha_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Winkel_Alpha_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWinkel_Alpha_TypeClassAdapter() {
		if (winkel_Alpha_TypeClassItemProvider == null) {
			winkel_Alpha_TypeClassItemProvider = new Winkel_Alpha_TypeClassItemProvider(this);
		}

		return winkel_Alpha_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Zeitueberschreitungsmeldung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zeitueberschreitungsmeldung_TypeClassItemProvider zeitueberschreitungsmeldung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Zeitueberschreitungsmeldung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZeitueberschreitungsmeldung_TypeClassAdapter() {
		if (zeitueberschreitungsmeldung_TypeClassItemProvider == null) {
			zeitueberschreitungsmeldung_TypeClassItemProvider = new Zeitueberschreitungsmeldung_TypeClassItemProvider(this);
		}

		return zeitueberschreitungsmeldung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Bahnuebergang.Zusatzschild_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zusatzschild_TypeClassItemProvider zusatzschild_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Bahnuebergang.Zusatzschild_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZusatzschild_TypeClassAdapter() {
		if (zusatzschild_TypeClassItemProvider == null) {
			zusatzschild_TypeClassItemProvider = new Zusatzschild_TypeClassItemProvider(this);
		}

		return zusatzschild_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (abstand_Gehweg_Fahrbahn_TypeClassItemProvider != null) abstand_Gehweg_Fahrbahn_TypeClassItemProvider.dispose();
		if (akustik_Fussgaenger_TypeClassItemProvider != null) akustik_Fussgaenger_TypeClassItemProvider.dispose();
		if (ausrichtung_TypeClassItemProvider != null) ausrichtung_TypeClassItemProvider.dispose();
		if (ausrichtung_Winkel_TypeClassItemProvider != null) ausrichtung_Winkel_TypeClassItemProvider.dispose();
		if (auto_Het_TypeClassItemProvider != null) auto_Het_TypeClassItemProvider.dispose();
		if (baulast_TypeClassItemProvider != null) baulast_TypeClassItemProvider.dispose();
		if (baumprofil_TypeClassItemProvider != null) baumprofil_TypeClassItemProvider.dispose();
		if (beeinflussung_Strassenverkehr_TypeClassItemProvider != null) beeinflussung_Strassenverkehr_TypeClassItemProvider.dispose();
		if (bez_Schrankenantrieb_TypeClassItemProvider != null) bez_Schrankenantrieb_TypeClassItemProvider.dispose();
		if (bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider != null) bezeichnung_BUE_GFR_Eckpunkt_TypeClassItemProvider.dispose();
		if (bezeichnung_GFR_Element_TypeClassItemProvider != null) bezeichnung_GFR_Element_TypeClassItemProvider.dispose();
		if (bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider != null) bezeichnung_GFR_Tripelspiegel_TypeClassItemProvider.dispose();
		if (bezeichnung_Verkehrszeichen_TypeClassItemProvider != null) bezeichnung_Verkehrszeichen_TypeClassItemProvider.dispose();
		if (blitzpfeil_TypeClassItemProvider != null) blitzpfeil_TypeClassItemProvider.dispose();
		if (buE_Abhaengigkeit_Fue_AttributeGroupItemProvider != null) buE_Abhaengigkeit_Fue_AttributeGroupItemProvider.dispose();
		if (buE_AnlageItemProvider != null) buE_AnlageItemProvider.dispose();
		if (buE_Anlage_Allg_AttributeGroupItemProvider != null) buE_Anlage_Allg_AttributeGroupItemProvider.dispose();
		if (buE_Anlage_Fuss_Rad_AttributeGroupItemProvider != null) buE_Anlage_Fuss_Rad_AttributeGroupItemProvider.dispose();
		if (buE_Anlage_StrasseItemProvider != null) buE_Anlage_StrasseItemProvider.dispose();
		if (buE_Anlage_Strasse_Allg_AttributeGroupItemProvider != null) buE_Anlage_Strasse_Allg_AttributeGroupItemProvider.dispose();
		if (buE_Anlage_VItemProvider != null) buE_Anlage_VItemProvider.dispose();
		if (buE_Anlage_V_Allg_AttributeGroupItemProvider != null) buE_Anlage_V_Allg_AttributeGroupItemProvider.dispose();
		if (buE_AusschaltungItemProvider != null) buE_AusschaltungItemProvider.dispose();
		if (buE_Bauart_TypeClassItemProvider != null) buE_Bauart_TypeClassItemProvider.dispose();
		if (buE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider != null) buE_Bedien_Anz_Element_Allg_AttributeGroupItemProvider.dispose();
		if (buE_Bedien_Anzeige_ElementItemProvider != null) buE_Bedien_Anzeige_ElementItemProvider.dispose();
		if (buE_Buestra_TypeClassItemProvider != null) buE_Buestra_TypeClassItemProvider.dispose();
		if (buE_Deckendes_Signal_ZuordnungItemProvider != null) buE_Deckendes_Signal_ZuordnungItemProvider.dispose();
		if (buE_EinschaltungItemProvider != null) buE_EinschaltungItemProvider.dispose();
		if (buE_Einschaltung_Hp_AttributeGroupItemProvider != null) buE_Einschaltung_Hp_AttributeGroupItemProvider.dispose();
		if (buE_Einschaltung_ZuordnungItemProvider != null) buE_Einschaltung_ZuordnungItemProvider.dispose();
		if (buE_Funktionsueberwachung_TypeClassItemProvider != null) buE_Funktionsueberwachung_TypeClassItemProvider.dispose();
		if (buE_Gefahrraum_EckpunktItemProvider != null) buE_Gefahrraum_EckpunktItemProvider.dispose();
		if (buE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider != null) buE_Gefahrraum_Eckpunkt_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (buE_Gleisbezogener_GefahrraumItemProvider != null) buE_Gleisbezogener_GefahrraumItemProvider.dispose();
		if (buE_Handschalteinrichtung_TypeClassItemProvider != null) buE_Handschalteinrichtung_TypeClassItemProvider.dispose();
		if (buE_KanteItemProvider != null) buE_KanteItemProvider.dispose();
		if (buE_KreuzungsplanItemProvider != null) buE_KreuzungsplanItemProvider.dispose();
		if (buE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider != null) buE_Kreuzungsplan_Koordinaten_AttributeGroupItemProvider.dispose();
		if (buE_Mit_GFR_TypeClassItemProvider != null) buE_Mit_GFR_TypeClassItemProvider.dispose();
		if (buE_Nachlaufzeit_TypeClassItemProvider != null) buE_Nachlaufzeit_TypeClassItemProvider.dispose();
		if (buE_Neigung_TypeClassItemProvider != null) buE_Neigung_TypeClassItemProvider.dispose();
		if (buE_SchnittstelleItemProvider != null) buE_SchnittstelleItemProvider.dispose();
		if (buE_Schnittstelle_Allg_AttributeGroupItemProvider != null) buE_Schnittstelle_Allg_AttributeGroupItemProvider.dispose();
		if (buE_Sicherungsart_TypeClassItemProvider != null) buE_Sicherungsart_TypeClassItemProvider.dispose();
		if (buE_Sicherungszeit_TypeClassItemProvider != null) buE_Sicherungszeit_TypeClassItemProvider.dispose();
		if (buE_Spezifisches_SignalItemProvider != null) buE_Spezifisches_SignalItemProvider.dispose();
		if (buE_Strasse_TypeClassItemProvider != null) buE_Strasse_TypeClassItemProvider.dispose();
		if (buE_Technik_TypeClassItemProvider != null) buE_Technik_TypeClassItemProvider.dispose();
		if (buE_Vorlaufzeit_TypeClassItemProvider != null) buE_Vorlaufzeit_TypeClassItemProvider.dispose();
		if (buE_WS_Fstr_ZuordnungItemProvider != null) buE_WS_Fstr_ZuordnungItemProvider.dispose();
		if (einschaltverz_Errechnet_TypeClassItemProvider != null) einschaltverz_Errechnet_TypeClassItemProvider.dispose();
		if (einschaltverz_Gewaehlt_TypeClassItemProvider != null) einschaltverz_Gewaehlt_TypeClassItemProvider.dispose();
		if (ersatzstecker_Gleisbezogen_TypeClassItemProvider != null) ersatzstecker_Gleisbezogen_TypeClassItemProvider.dispose();
		if (fahrbahn_Befestigung_Gleis_TypeClassItemProvider != null) fahrbahn_Befestigung_Gleis_TypeClassItemProvider.dispose();
		if (fahrbahn_Befestigung_TypeClassItemProvider != null) fahrbahn_Befestigung_TypeClassItemProvider.dispose();
		if (fahrbahn_Breite_TypeClassItemProvider != null) fahrbahn_Breite_TypeClassItemProvider.dispose();
		if (fue_Schaltfall_TypeClassItemProvider != null) fue_Schaltfall_TypeClassItemProvider.dispose();
		if (fuss_Radweg_Art_TypeClassItemProvider != null) fuss_Radweg_Art_TypeClassItemProvider.dispose();
		if (fuss_Radweg_Seite_TypeClassItemProvider != null) fuss_Radweg_Seite_TypeClassItemProvider.dispose();
		if (gfR_AnlageItemProvider != null) gfR_AnlageItemProvider.dispose();
		if (gfR_Anlage_Allg_AttributeGroupItemProvider != null) gfR_Anlage_Allg_AttributeGroupItemProvider.dispose();
		if (gfR_Art_TypeClassItemProvider != null) gfR_Art_TypeClassItemProvider.dispose();
		if (gfR_ElementItemProvider != null) gfR_ElementItemProvider.dispose();
		if (gfR_Element_Bezeichnung_AttributeGroupItemProvider != null) gfR_Element_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (gfR_Neigung_TypeClassItemProvider != null) gfR_Neigung_TypeClassItemProvider.dispose();
		if (gfR_TripelspiegelItemProvider != null) gfR_TripelspiegelItemProvider.dispose();
		if (gfR_Tripelspiegel_Allg_AttributeGroupItemProvider != null) gfR_Tripelspiegel_Allg_AttributeGroupItemProvider.dispose();
		if (gfR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider != null) gfR_Tripelspiegel_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (gfR_Typ_TypeClassItemProvider != null) gfR_Typ_TypeClassItemProvider.dispose();
		if (gitterbehang_TypeClassItemProvider != null) gitterbehang_TypeClassItemProvider.dispose();
		if (gleis_Am_Bue_TypeClassItemProvider != null) gleis_Am_Bue_TypeClassItemProvider.dispose();
		if (haltezeit_TypeClassItemProvider != null) haltezeit_TypeClassItemProvider.dispose();
		if (hersteller_TypeClassItemProvider != null) hersteller_TypeClassItemProvider.dispose();
		if (hp_Ersatzstecker_TypeClassItemProvider != null) hp_Ersatzstecker_TypeClassItemProvider.dispose();
		if (klassifizierung_TypeClassItemProvider != null) klassifizierung_TypeClassItemProvider.dispose();
		if (kontrastblende_TypeClassItemProvider != null) kontrastblende_TypeClassItemProvider.dispose();
		if (kreuzungswinkel_TypeClassItemProvider != null) kreuzungswinkel_TypeClassItemProvider.dispose();
		if (kurzzugschaltung_TypeClassItemProvider != null) kurzzugschaltung_TypeClassItemProvider.dispose();
		if (lagerung_Art_TypeClassItemProvider != null) lagerung_Art_TypeClassItemProvider.dispose();
		if (lfuE_Impuls_TypeClassItemProvider != null) lfuE_Impuls_TypeClassItemProvider.dispose();
		if (lieferlaenge_TypeClassItemProvider != null) lieferlaenge_TypeClassItemProvider.dispose();
		if (montage_Ausgleichsgewichte_TypeClassItemProvider != null) montage_Ausgleichsgewichte_TypeClassItemProvider.dispose();
		if (montage_Besonders_TypeClassItemProvider != null) montage_Besonders_TypeClassItemProvider.dispose();
		if (montagehoehe_TypeClassItemProvider != null) montagehoehe_TypeClassItemProvider.dispose();
		if (optik_Durchmesser_TypeClassItemProvider != null) optik_Durchmesser_TypeClassItemProvider.dispose();
		if (optik_Symbolmaske_TypeClassItemProvider != null) optik_Symbolmaske_TypeClassItemProvider.dispose();
		if (pegel_TypeClassItemProvider != null) pegel_TypeClassItemProvider.dispose();
		if (pixel_Koordinate_X_TypeClassItemProvider != null) pixel_Koordinate_X_TypeClassItemProvider.dispose();
		if (pixel_Koordinate_Y_TypeClassItemProvider != null) pixel_Koordinate_Y_TypeClassItemProvider.dispose();
		if (raeumstrecke_DAB_TypeClassItemProvider != null) raeumstrecke_DAB_TypeClassItemProvider.dispose();
		if (raeumstrecke_DBK_TypeClassItemProvider != null) raeumstrecke_DBK_TypeClassItemProvider.dispose();
		if (raeumstrecke_DCK_TypeClassItemProvider != null) raeumstrecke_DCK_TypeClassItemProvider.dispose();
		if (raeumstrecke_DSK_Strich_TypeClassItemProvider != null) raeumstrecke_DSK_Strich_TypeClassItemProvider.dispose();
		if (raeumstrecke_TypeClassItemProvider != null) raeumstrecke_TypeClassItemProvider.dispose();
		if (richtungspfeil_TypeClassItemProvider != null) richtungspfeil_TypeClassItemProvider.dispose();
		if (sA_Schrankenbaum_AttributeGroupItemProvider != null) sA_Schrankenbaum_AttributeGroupItemProvider.dispose();
		if (schaltgruppe_TypeClassItemProvider != null) schaltgruppe_TypeClassItemProvider.dispose();
		if (schaltmittel_Fstr_ZuordnungItemProvider != null) schaltmittel_Fstr_ZuordnungItemProvider.dispose();
		if (schrankenantriebItemProvider != null) schrankenantriebItemProvider.dispose();
		if (schrankenantrieb_Allg_AttributeGroupItemProvider != null) schrankenantrieb_Allg_AttributeGroupItemProvider.dispose();
		if (schrankenantrieb_Bezeichnung_AttributeGroupItemProvider != null) schrankenantrieb_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (schutzbuegel_TypeClassItemProvider != null) schutzbuegel_TypeClassItemProvider.dispose();
		if (sicherheitsabstand_TypeClassItemProvider != null) sicherheitsabstand_TypeClassItemProvider.dispose();
		if (signalverz_Errechnet_TypeClassItemProvider != null) signalverz_Errechnet_TypeClassItemProvider.dispose();
		if (signalverz_Gewaehlt_TypeClassItemProvider != null) signalverz_Gewaehlt_TypeClassItemProvider.dispose();
		if (sperrlaenge_TypeClassItemProvider != null) sperrlaenge_TypeClassItemProvider.dispose();
		if (sperrstrecke_Fussgaenger_TypeClassItemProvider != null) sperrstrecke_Fussgaenger_TypeClassItemProvider.dispose();
		if (sperrstrecke_TypeClassItemProvider != null) sperrstrecke_TypeClassItemProvider.dispose();
		if (stoerhalt_Haltfall_TypeClassItemProvider != null) stoerhalt_Haltfall_TypeClassItemProvider.dispose();
		if (stoerhalt_Merkhinweis_TypeClassItemProvider != null) stoerhalt_Merkhinweis_TypeClassItemProvider.dispose();
		if (teilsperrstrecke_TypeClassItemProvider != null) teilsperrstrecke_TypeClassItemProvider.dispose();
		if (teilvorgabezeit_TypeClassItemProvider != null) teilvorgabezeit_TypeClassItemProvider.dispose();
		if (tragkopf_Verstellbar_TypeClassItemProvider != null) tragkopf_Verstellbar_TypeClassItemProvider.dispose();
		if (v_Max_Schiene_TypeClassItemProvider != null) v_Max_Schiene_TypeClassItemProvider.dispose();
		if (v_Max_Strasse_TypeClassItemProvider != null) v_Max_Strasse_TypeClassItemProvider.dispose();
		if (v_Min_Fussweg_TypeClassItemProvider != null) v_Min_Fussweg_TypeClassItemProvider.dispose();
		if (v_Min_Schiene_TypeClassItemProvider != null) v_Min_Schiene_TypeClassItemProvider.dispose();
		if (v_Min_Strasse_TypeClassItemProvider != null) v_Min_Strasse_TypeClassItemProvider.dispose();
		if (verkehrszeichenItemProvider != null) verkehrszeichenItemProvider.dispose();
		if (verkehrszeichen_Allg_AttributeGroupItemProvider != null) verkehrszeichen_Allg_AttributeGroupItemProvider.dispose();
		if (verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider != null) verkehrszeichen_Andreaskreuz_AttributeGroupItemProvider.dispose();
		if (verkehrszeichen_Bezeichnung_AttributeGroupItemProvider != null) verkehrszeichen_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (verkehrszeichen_Lz_AttributeGroupItemProvider != null) verkehrszeichen_Lz_AttributeGroupItemProvider.dispose();
		if (vorgeschaltet_TypeClassItemProvider != null) vorgeschaltet_TypeClassItemProvider.dispose();
		if (vz_Sperrstrecke_AttributeGroupItemProvider != null) vz_Sperrstrecke_AttributeGroupItemProvider.dispose();
		if (vz_Sperrstrecke_Schranke_AttributeGroupItemProvider != null) vz_Sperrstrecke_Schranke_AttributeGroupItemProvider.dispose();
		if (vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider != null) vz_Sperrstrecke_Vorgeschaltet_AttributeGroupItemProvider.dispose();
		if (winkel_Alpha_TypeClassItemProvider != null) winkel_Alpha_TypeClassItemProvider.dispose();
		if (zeitueberschreitungsmeldung_TypeClassItemProvider != null) zeitueberschreitungsmeldung_TypeClassItemProvider.dispose();
		if (zusatzschild_TypeClassItemProvider != null) zusatzschild_TypeClassItemProvider.dispose();
	}

}
