/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.BasisTypen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Regionalbereich</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.BasisTypen.BasisTypenPackage#getENUMRegionalbereich()
 * @model extendedMetaData="name='ENUMRegionalbereich'"
 * @generated
 */
public enum ENUMRegionalbereich implements Enumerator {
	/**
	 * The '<em><b>ENUM Regionalbereich Mitte</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_MITTE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_MITTE(0, "ENUMRegionalbereich_Mitte", "Mitte"),

	/**
	 * The '<em><b>ENUM Regionalbereich Nord</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_NORD_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_NORD(1, "ENUMRegionalbereich_Nord", "Nord"),

	/**
	 * The '<em><b>ENUM Regionalbereich Ost</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_OST_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_OST(2, "ENUMRegionalbereich_Ost", "Ost"),

	/**
	 * The '<em><b>ENUM Regionalbereich Süd</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_SÜD_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_SÜD(3, "ENUMRegionalbereich_Süd", "S\u00fcd"),

	/**
	 * The '<em><b>ENUM Regionalbereich Südost</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_SÜDOST_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_SÜDOST(4, "ENUMRegionalbereich_Südost", "S\u00fcdost"),

	/**
	 * The '<em><b>ENUM Regionalbereich Südwest</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_SÜDWEST_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_SÜDWEST(5, "ENUMRegionalbereich_Südwest", "S\u00fcdwest"),

	/**
	 * The '<em><b>ENUM Regionalbereich West</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_WEST_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_REGIONALBEREICH_WEST(6, "ENUMRegionalbereich_West", "West");

	/**
	 * The '<em><b>ENUM Regionalbereich Mitte</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_MITTE
	 * @model name="ENUMRegionalbereich_Mitte" literal="Mitte"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_MITTE_VALUE = 0;

	/**
	 * The '<em><b>ENUM Regionalbereich Nord</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_NORD
	 * @model name="ENUMRegionalbereich_Nord" literal="Nord"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_NORD_VALUE = 1;

	/**
	 * The '<em><b>ENUM Regionalbereich Ost</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_OST
	 * @model name="ENUMRegionalbereich_Ost" literal="Ost"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_OST_VALUE = 2;

	/**
	 * The '<em><b>ENUM Regionalbereich Süd</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_SÜD
	 * @model name="ENUMRegionalbereich_Süd" literal="S\374d"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_SÜD_VALUE = 3;

	/**
	 * The '<em><b>ENUM Regionalbereich Südost</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_SÜDOST
	 * @model name="ENUMRegionalbereich_Südost" literal="S\374dost"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_SÜDOST_VALUE = 4;

	/**
	 * The '<em><b>ENUM Regionalbereich Südwest</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_SÜDWEST
	 * @model name="ENUMRegionalbereich_Südwest" literal="S\374dwest"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_SÜDWEST_VALUE = 5;

	/**
	 * The '<em><b>ENUM Regionalbereich West</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_REGIONALBEREICH_WEST
	 * @model name="ENUMRegionalbereich_West" literal="West"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_REGIONALBEREICH_WEST_VALUE = 6;

	/**
	 * An array of all the '<em><b>ENUM Regionalbereich</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMRegionalbereich[] VALUES_ARRAY =
		new ENUMRegionalbereich[] {
			ENUM_REGIONALBEREICH_MITTE,
			ENUM_REGIONALBEREICH_NORD,
			ENUM_REGIONALBEREICH_OST,
			ENUM_REGIONALBEREICH_SÜD,
			ENUM_REGIONALBEREICH_SÜDOST,
			ENUM_REGIONALBEREICH_SÜDWEST,
			ENUM_REGIONALBEREICH_WEST,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Regionalbereich</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMRegionalbereich> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Regionalbereich</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMRegionalbereich get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMRegionalbereich result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Regionalbereich</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMRegionalbereich getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMRegionalbereich result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Regionalbereich</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMRegionalbereich get(int value) {
		switch (value) {
			case ENUM_REGIONALBEREICH_MITTE_VALUE: return ENUM_REGIONALBEREICH_MITTE;
			case ENUM_REGIONALBEREICH_NORD_VALUE: return ENUM_REGIONALBEREICH_NORD;
			case ENUM_REGIONALBEREICH_OST_VALUE: return ENUM_REGIONALBEREICH_OST;
			case ENUM_REGIONALBEREICH_SÜD_VALUE: return ENUM_REGIONALBEREICH_SÜD;
			case ENUM_REGIONALBEREICH_SÜDOST_VALUE: return ENUM_REGIONALBEREICH_SÜDOST;
			case ENUM_REGIONALBEREICH_SÜDWEST_VALUE: return ENUM_REGIONALBEREICH_SÜDWEST;
			case ENUM_REGIONALBEREICH_WEST_VALUE: return ENUM_REGIONALBEREICH_WEST;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMRegionalbereich(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMRegionalbereich
