/**
 * /**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Ansteuerung_Element.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Ansteuerung_Element.util.Ansteuerung_ElementAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class Ansteuerung_ElementItemProviderAdapterFactory extends Ansteuerung_ElementAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Ansteuerung_ElementItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AEA_Allg_AttributeGroupItemProvider aeA_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAEA_Allg_AttributeGroupAdapter() {
		if (aeA_Allg_AttributeGroupItemProvider == null) {
			aeA_Allg_AttributeGroupItemProvider = new AEA_Allg_AttributeGroupItemProvider(this);
		}

		return aeA_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_Energieversorgung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AEA_Energieversorgung_AttributeGroupItemProvider aeA_Energieversorgung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_Energieversorgung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAEA_Energieversorgung_AttributeGroupAdapter() {
		if (aeA_Energieversorgung_AttributeGroupItemProvider == null) {
			aeA_Energieversorgung_AttributeGroupItemProvider = new AEA_Energieversorgung_AttributeGroupItemProvider(this);
		}

		return aeA_Energieversorgung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_GFK_IP_Adressblock_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AEA_GFK_IP_Adressblock_AttributeGroupItemProvider aeA_GFK_IP_Adressblock_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.AEA_GFK_IP_Adressblock_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAEA_GFK_IP_Adressblock_AttributeGroupAdapter() {
		if (aeA_GFK_IP_Adressblock_AttributeGroupItemProvider == null) {
			aeA_GFK_IP_Adressblock_AttributeGroupItemProvider = new AEA_GFK_IP_Adressblock_AttributeGroupItemProvider(this);
		}

		return aeA_GFK_IP_Adressblock_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AussenelementansteuerungItemProvider aussenelementansteuerungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAussenelementansteuerungAdapter() {
		if (aussenelementansteuerungItemProvider == null) {
			aussenelementansteuerungItemProvider = new AussenelementansteuerungItemProvider(this);
		}

		return aussenelementansteuerungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Aussenelementansteuerung_Art_TypeClassItemProvider aussenelementansteuerung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAussenelementansteuerung_Art_TypeClassAdapter() {
		if (aussenelementansteuerung_Art_TypeClassItemProvider == null) {
			aussenelementansteuerung_Art_TypeClassItemProvider = new Aussenelementansteuerung_Art_TypeClassItemProvider(this);
		}

		return aussenelementansteuerung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Aussenelementansteuerung_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAussenelementansteuerung_Bezeichnung_AttributeGroupAdapter() {
		if (aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider == null) {
			aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider = new Aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bandbreite_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bandbreite_TypeClassItemProvider bandbreite_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bandbreite_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBandbreite_TypeClassAdapter() {
		if (bandbreite_TypeClassItemProvider == null) {
			bandbreite_TypeClassItemProvider = new Bandbreite_TypeClassItemProvider(this);
		}

		return bandbreite_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bauart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bauart_TypeClassItemProvider bauart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bauart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBauart_TypeClassAdapter() {
		if (bauart_TypeClassItemProvider == null) {
			bauart_TypeClassItemProvider = new Bauart_TypeClassItemProvider(this);
		}

		return bauart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_AEA_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_AEA_TypeClassItemProvider bezeichnung_AEA_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_AEA_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_AEA_TypeClassAdapter() {
		if (bezeichnung_AEA_TypeClassItemProvider == null) {
			bezeichnung_AEA_TypeClassItemProvider = new Bezeichnung_AEA_TypeClassItemProvider(this);
		}

		return bezeichnung_AEA_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_ESTW_ZE_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_ESTW_ZE_TypeClassItemProvider bezeichnung_ESTW_ZE_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_ESTW_ZE_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_ESTW_ZE_TypeClassAdapter() {
		if (bezeichnung_ESTW_ZE_TypeClassItemProvider == null) {
			bezeichnung_ESTW_ZE_TypeClassItemProvider = new Bezeichnung_ESTW_ZE_TypeClassItemProvider(this);
		}

		return bezeichnung_ESTW_ZE_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_Stellwerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Stellwerk_TypeClassItemProvider bezeichnung_Stellwerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_Stellwerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Stellwerk_TypeClassAdapter() {
		if (bezeichnung_Stellwerk_TypeClassItemProvider == null) {
			bezeichnung_Stellwerk_TypeClassItemProvider = new Bezeichnung_Stellwerk_TypeClassItemProvider(this);
		}

		return bezeichnung_Stellwerk_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_TSO_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_TSO_TypeClassItemProvider bezeichnung_TSO_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Bezeichnung_TSO_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_TSO_TypeClassAdapter() {
		if (bezeichnung_TSO_TypeClassItemProvider == null) {
			bezeichnung_TSO_TypeClassItemProvider = new Bezeichnung_TSO_TypeClassItemProvider(this);
		}

		return bezeichnung_TSO_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Energieversorgung_Art_Ersatz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Energieversorgung_Art_Ersatz_TypeClassItemProvider energieversorgung_Art_Ersatz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Energieversorgung_Art_Ersatz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnergieversorgung_Art_Ersatz_TypeClassAdapter() {
		if (energieversorgung_Art_Ersatz_TypeClassItemProvider == null) {
			energieversorgung_Art_Ersatz_TypeClassItemProvider = new Energieversorgung_Art_Ersatz_TypeClassItemProvider(this);
		}

		return energieversorgung_Art_Ersatz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Energieversorgung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Energieversorgung_Art_TypeClassItemProvider energieversorgung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Energieversorgung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnergieversorgung_Art_TypeClassAdapter() {
		if (energieversorgung_Art_TypeClassItemProvider == null) {
			energieversorgung_Art_TypeClassItemProvider = new Energieversorgung_Art_TypeClassItemProvider(this);
		}

		return energieversorgung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_ZE_Energieversorgung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESTW_ZE_Energieversorgung_AttributeGroupItemProvider estW_ZE_Energieversorgung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_ZE_Energieversorgung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESTW_ZE_Energieversorgung_AttributeGroupAdapter() {
		if (estW_ZE_Energieversorgung_AttributeGroupItemProvider == null) {
			estW_ZE_Energieversorgung_AttributeGroupItemProvider = new ESTW_ZE_Energieversorgung_AttributeGroupItemProvider(this);
		}

		return estW_ZE_Energieversorgung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_Zentraleinheit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESTW_ZentraleinheitItemProvider estW_ZentraleinheitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_Zentraleinheit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESTW_ZentraleinheitAdapter() {
		if (estW_ZentraleinheitItemProvider == null) {
			estW_ZentraleinheitItemProvider = new ESTW_ZentraleinheitItemProvider(this);
		}

		return estW_ZentraleinheitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_Zentraleinheit_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESTW_Zentraleinheit_Allg_AttributeGroupItemProvider estW_Zentraleinheit_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_Zentraleinheit_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESTW_Zentraleinheit_Allg_AttributeGroupAdapter() {
		if (estW_Zentraleinheit_Allg_AttributeGroupItemProvider == null) {
			estW_Zentraleinheit_Allg_AttributeGroupItemProvider = new ESTW_Zentraleinheit_Allg_AttributeGroupItemProvider(this);
		}

		return estW_Zentraleinheit_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_Zentraleinheit_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ESTW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider estW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.ESTW_Zentraleinheit_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createESTW_Zentraleinheit_Bezeichnung_AttributeGroupAdapter() {
		if (estW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider == null) {
			estW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider = new ESTW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return estW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.GFK_Kategorie_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GFK_Kategorie_TypeClassItemProvider gfK_Kategorie_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.GFK_Kategorie_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGFK_Kategorie_TypeClassAdapter() {
		if (gfK_Kategorie_TypeClassItemProvider == null) {
			gfK_Kategorie_TypeClassItemProvider = new GFK_Kategorie_TypeClassItemProvider(this);
		}

		return gfK_Kategorie_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Hersteller_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hersteller_TypeClassItemProvider hersteller_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Hersteller_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHersteller_TypeClassAdapter() {
		if (hersteller_TypeClassItemProvider == null) {
			hersteller_TypeClassItemProvider = new Hersteller_TypeClassItemProvider(this);
		}

		return hersteller_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Blau_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Blau_TypeClassItemProvider iP_Adressblock_Blau_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Blau_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Blau_TypeClassAdapter() {
		if (iP_Adressblock_Blau_TypeClassItemProvider == null) {
			iP_Adressblock_Blau_TypeClassItemProvider = new IP_Adressblock_Blau_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Blau_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Blau_V4_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Blau_V4_TypeClassItemProvider iP_Adressblock_Blau_V4_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Blau_V4_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Blau_V4_TypeClassAdapter() {
		if (iP_Adressblock_Blau_V4_TypeClassItemProvider == null) {
			iP_Adressblock_Blau_V4_TypeClassItemProvider = new IP_Adressblock_Blau_V4_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Blau_V4_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Blau_V6_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Blau_V6_TypeClassItemProvider iP_Adressblock_Blau_V6_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Blau_V6_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Blau_V6_TypeClassAdapter() {
		if (iP_Adressblock_Blau_V6_TypeClassItemProvider == null) {
			iP_Adressblock_Blau_V6_TypeClassItemProvider = new IP_Adressblock_Blau_V6_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Blau_V6_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Grau_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Grau_TypeClassItemProvider iP_Adressblock_Grau_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Grau_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Grau_TypeClassAdapter() {
		if (iP_Adressblock_Grau_TypeClassItemProvider == null) {
			iP_Adressblock_Grau_TypeClassItemProvider = new IP_Adressblock_Grau_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Grau_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Grau_V4_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Grau_V4_TypeClassItemProvider iP_Adressblock_Grau_V4_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Grau_V4_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Grau_V4_TypeClassAdapter() {
		if (iP_Adressblock_Grau_V4_TypeClassItemProvider == null) {
			iP_Adressblock_Grau_V4_TypeClassItemProvider = new IP_Adressblock_Grau_V4_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Grau_V4_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Grau_V6_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adressblock_Grau_V6_TypeClassItemProvider iP_Adressblock_Grau_V6_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.IP_Adressblock_Grau_V6_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adressblock_Grau_V6_TypeClassAdapter() {
		if (iP_Adressblock_Grau_V6_TypeClassItemProvider == null) {
			iP_Adressblock_Grau_V6_TypeClassItemProvider = new IP_Adressblock_Grau_V6_TypeClassItemProvider(this);
		}

		return iP_Adressblock_Grau_V6_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Medium_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Medium_Art_TypeClassItemProvider medium_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Medium_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMedium_Art_TypeClassAdapter() {
		if (medium_Art_TypeClassItemProvider == null) {
			medium_Art_TypeClassItemProvider = new Medium_Art_TypeClassItemProvider(this);
		}

		return medium_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Netz_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Netz_Art_TypeClassItemProvider netz_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Netz_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetz_Art_TypeClassAdapter() {
		if (netz_Art_TypeClassItemProvider == null) {
			netz_Art_TypeClassItemProvider = new Netz_Art_TypeClassItemProvider(this);
		}

		return netz_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Regionalbereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Regionalbereich_TypeClassItemProvider regionalbereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Regionalbereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegionalbereich_TypeClassAdapter() {
		if (regionalbereich_TypeClassItemProvider == null) {
			regionalbereich_TypeClassItemProvider = new Regionalbereich_TypeClassItemProvider(this);
		}

		return regionalbereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Standort_Beschreibung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Standort_Beschreibung_TypeClassItemProvider standort_Beschreibung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Standort_Beschreibung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStandort_Beschreibung_TypeClassAdapter() {
		if (standort_Beschreibung_TypeClassItemProvider == null) {
			standort_Beschreibung_TypeClassItemProvider = new Standort_Beschreibung_TypeClassItemProvider(this);
		}

		return standort_Beschreibung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Stell_Bereich} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Stell_BereichItemProvider stell_BereichItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Stell_Bereich}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStell_BereichAdapter() {
		if (stell_BereichItemProvider == null) {
			stell_BereichItemProvider = new Stell_BereichItemProvider(this);
		}

		return stell_BereichItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Stellelement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StellelementItemProvider stellelementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Stellelement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStellelementAdapter() {
		if (stellelementItemProvider == null) {
			stellelementItemProvider = new StellelementItemProvider(this);
		}

		return stellelementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technik_Art_TypeClassItemProvider technik_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnik_Art_TypeClassAdapter() {
		if (technik_Art_TypeClassItemProvider == null) {
			technik_Art_TypeClassItemProvider = new Technik_Art_TypeClassItemProvider(this);
		}

		return technik_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Beschreibung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technik_Beschreibung_TypeClassItemProvider technik_Beschreibung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Beschreibung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnik_Beschreibung_TypeClassAdapter() {
		if (technik_Beschreibung_TypeClassItemProvider == null) {
			technik_Beschreibung_TypeClassItemProvider = new Technik_Beschreibung_TypeClassItemProvider(this);
		}

		return technik_Beschreibung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Standort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technik_StandortItemProvider technik_StandortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Standort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnik_StandortAdapter() {
		if (technik_StandortItemProvider == null) {
			technik_StandortItemProvider = new Technik_StandortItemProvider(this);
		}

		return technik_StandortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Standort_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technik_Standort_Bezeichnung_AttributeGroupItemProvider technik_Standort_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Technik_Standort_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnik_Standort_Bezeichnung_AttributeGroupAdapter() {
		if (technik_Standort_Bezeichnung_AttributeGroupItemProvider == null) {
			technik_Standort_Bezeichnung_AttributeGroupItemProvider = new Technik_Standort_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return technik_Standort_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.TSO_IP_AB_Teilsystem_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TSO_IP_AB_Teilsystem_AttributeGroupItemProvider tsO_IP_AB_Teilsystem_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.TSO_IP_AB_Teilsystem_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTSO_IP_AB_Teilsystem_AttributeGroupAdapter() {
		if (tsO_IP_AB_Teilsystem_AttributeGroupItemProvider == null) {
			tsO_IP_AB_Teilsystem_AttributeGroupItemProvider = new TSO_IP_AB_Teilsystem_AttributeGroupItemProvider(this);
		}

		return tsO_IP_AB_Teilsystem_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.TSO_IP_Adressblock_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TSO_IP_Adressblock_AttributeGroupItemProvider tsO_IP_Adressblock_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.TSO_IP_Adressblock_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTSO_IP_Adressblock_AttributeGroupAdapter() {
		if (tsO_IP_Adressblock_AttributeGroupItemProvider == null) {
			tsO_IP_Adressblock_AttributeGroupItemProvider = new TSO_IP_Adressblock_AttributeGroupItemProvider(this);
		}

		return tsO_IP_Adressblock_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.TSO_Teilsystem_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TSO_Teilsystem_Art_TypeClassItemProvider tsO_Teilsystem_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.TSO_Teilsystem_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTSO_Teilsystem_Art_TypeClassAdapter() {
		if (tsO_Teilsystem_Art_TypeClassItemProvider == null) {
			tsO_Teilsystem_Art_TypeClassItemProvider = new TSO_Teilsystem_Art_TypeClassItemProvider(this);
		}

		return tsO_Teilsystem_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Tueranschlag_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Tueranschlag_TypeClassItemProvider tueranschlag_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Tueranschlag_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTueranschlag_TypeClassAdapter() {
		if (tueranschlag_TypeClassItemProvider == null) {
			tueranschlag_TypeClassItemProvider = new Tueranschlag_TypeClassItemProvider(this);
		}

		return tueranschlag_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Uebertragungsweg} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UebertragungswegItemProvider uebertragungswegItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Uebertragungsweg}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUebertragungswegAdapter() {
		if (uebertragungswegItemProvider == null) {
			uebertragungswegItemProvider = new UebertragungswegItemProvider(this);
		}

		return uebertragungswegItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Uebertragungsweg_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Uebertragungsweg_Art_TypeClassItemProvider uebertragungsweg_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Uebertragungsweg_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUebertragungsweg_Art_TypeClassAdapter() {
		if (uebertragungsweg_Art_TypeClassItemProvider == null) {
			uebertragungsweg_Art_TypeClassItemProvider = new Uebertragungsweg_Art_TypeClassItemProvider(this);
		}

		return uebertragungsweg_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Uebertragungsweg_Technik_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Uebertragungsweg_Technik_AttributeGroupItemProvider uebertragungsweg_Technik_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Uebertragungsweg_Technik_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUebertragungsweg_Technik_AttributeGroupAdapter() {
		if (uebertragungsweg_Technik_AttributeGroupItemProvider == null) {
			uebertragungsweg_Technik_AttributeGroupItemProvider = new Uebertragungsweg_Technik_AttributeGroupItemProvider(this);
		}

		return uebertragungsweg_Technik_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnterbringungItemProvider unterbringungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterbringungAdapter() {
		if (unterbringungItemProvider == null) {
			unterbringungItemProvider = new UnterbringungItemProvider(this);
		}

		return unterbringungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Unterbringung_Allg_AttributeGroupItemProvider unterbringung_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterbringung_Allg_AttributeGroupAdapter() {
		if (unterbringung_Allg_AttributeGroupItemProvider == null) {
			unterbringung_Allg_AttributeGroupItemProvider = new Unterbringung_Allg_AttributeGroupItemProvider(this);
		}

		return unterbringung_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Unterbringung_Art_TypeClassItemProvider unterbringung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterbringung_Art_TypeClassAdapter() {
		if (unterbringung_Art_TypeClassItemProvider == null) {
			unterbringung_Art_TypeClassItemProvider = new Unterbringung_Art_TypeClassItemProvider(this);
		}

		return unterbringung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Befestigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Unterbringung_Befestigung_TypeClassItemProvider unterbringung_Befestigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Befestigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterbringung_Befestigung_TypeClassAdapter() {
		if (unterbringung_Befestigung_TypeClassItemProvider == null) {
			unterbringung_Befestigung_TypeClassItemProvider = new Unterbringung_Befestigung_TypeClassItemProvider(this);
		}

		return unterbringung_Befestigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Polygonzug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Unterbringung_Polygonzug_TypeClassItemProvider unterbringung_Polygonzug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Polygonzug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterbringung_Polygonzug_TypeClassAdapter() {
		if (unterbringung_Polygonzug_TypeClassItemProvider == null) {
			unterbringung_Polygonzug_TypeClassItemProvider = new Unterbringung_Polygonzug_TypeClassItemProvider(this);
		}

		return unterbringung_Polygonzug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Zusatzinformation_Stellwerk_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zusatzinformation_Stellwerk_TypeClassItemProvider zusatzinformation_Stellwerk_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ansteuerung_Element.Zusatzinformation_Stellwerk_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZusatzinformation_Stellwerk_TypeClassAdapter() {
		if (zusatzinformation_Stellwerk_TypeClassItemProvider == null) {
			zusatzinformation_Stellwerk_TypeClassItemProvider = new Zusatzinformation_Stellwerk_TypeClassItemProvider(this);
		}

		return zusatzinformation_Stellwerk_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (aeA_Allg_AttributeGroupItemProvider != null) aeA_Allg_AttributeGroupItemProvider.dispose();
		if (aeA_Energieversorgung_AttributeGroupItemProvider != null) aeA_Energieversorgung_AttributeGroupItemProvider.dispose();
		if (aeA_GFK_IP_Adressblock_AttributeGroupItemProvider != null) aeA_GFK_IP_Adressblock_AttributeGroupItemProvider.dispose();
		if (aussenelementansteuerungItemProvider != null) aussenelementansteuerungItemProvider.dispose();
		if (aussenelementansteuerung_Art_TypeClassItemProvider != null) aussenelementansteuerung_Art_TypeClassItemProvider.dispose();
		if (aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider != null) aussenelementansteuerung_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bandbreite_TypeClassItemProvider != null) bandbreite_TypeClassItemProvider.dispose();
		if (bauart_TypeClassItemProvider != null) bauart_TypeClassItemProvider.dispose();
		if (bezeichnung_AEA_TypeClassItemProvider != null) bezeichnung_AEA_TypeClassItemProvider.dispose();
		if (bezeichnung_ESTW_ZE_TypeClassItemProvider != null) bezeichnung_ESTW_ZE_TypeClassItemProvider.dispose();
		if (bezeichnung_Stellwerk_TypeClassItemProvider != null) bezeichnung_Stellwerk_TypeClassItemProvider.dispose();
		if (bezeichnung_TSO_TypeClassItemProvider != null) bezeichnung_TSO_TypeClassItemProvider.dispose();
		if (energieversorgung_Art_Ersatz_TypeClassItemProvider != null) energieversorgung_Art_Ersatz_TypeClassItemProvider.dispose();
		if (energieversorgung_Art_TypeClassItemProvider != null) energieversorgung_Art_TypeClassItemProvider.dispose();
		if (estW_ZE_Energieversorgung_AttributeGroupItemProvider != null) estW_ZE_Energieversorgung_AttributeGroupItemProvider.dispose();
		if (estW_ZentraleinheitItemProvider != null) estW_ZentraleinheitItemProvider.dispose();
		if (estW_Zentraleinheit_Allg_AttributeGroupItemProvider != null) estW_Zentraleinheit_Allg_AttributeGroupItemProvider.dispose();
		if (estW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider != null) estW_Zentraleinheit_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (gfK_Kategorie_TypeClassItemProvider != null) gfK_Kategorie_TypeClassItemProvider.dispose();
		if (hersteller_TypeClassItemProvider != null) hersteller_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Blau_TypeClassItemProvider != null) iP_Adressblock_Blau_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Blau_V4_TypeClassItemProvider != null) iP_Adressblock_Blau_V4_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Blau_V6_TypeClassItemProvider != null) iP_Adressblock_Blau_V6_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Grau_TypeClassItemProvider != null) iP_Adressblock_Grau_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Grau_V4_TypeClassItemProvider != null) iP_Adressblock_Grau_V4_TypeClassItemProvider.dispose();
		if (iP_Adressblock_Grau_V6_TypeClassItemProvider != null) iP_Adressblock_Grau_V6_TypeClassItemProvider.dispose();
		if (medium_Art_TypeClassItemProvider != null) medium_Art_TypeClassItemProvider.dispose();
		if (netz_Art_TypeClassItemProvider != null) netz_Art_TypeClassItemProvider.dispose();
		if (regionalbereich_TypeClassItemProvider != null) regionalbereich_TypeClassItemProvider.dispose();
		if (standort_Beschreibung_TypeClassItemProvider != null) standort_Beschreibung_TypeClassItemProvider.dispose();
		if (stell_BereichItemProvider != null) stell_BereichItemProvider.dispose();
		if (stellelementItemProvider != null) stellelementItemProvider.dispose();
		if (technik_Art_TypeClassItemProvider != null) technik_Art_TypeClassItemProvider.dispose();
		if (technik_Beschreibung_TypeClassItemProvider != null) technik_Beschreibung_TypeClassItemProvider.dispose();
		if (technik_StandortItemProvider != null) technik_StandortItemProvider.dispose();
		if (technik_Standort_Bezeichnung_AttributeGroupItemProvider != null) technik_Standort_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (tsO_IP_AB_Teilsystem_AttributeGroupItemProvider != null) tsO_IP_AB_Teilsystem_AttributeGroupItemProvider.dispose();
		if (tsO_IP_Adressblock_AttributeGroupItemProvider != null) tsO_IP_Adressblock_AttributeGroupItemProvider.dispose();
		if (tsO_Teilsystem_Art_TypeClassItemProvider != null) tsO_Teilsystem_Art_TypeClassItemProvider.dispose();
		if (tueranschlag_TypeClassItemProvider != null) tueranschlag_TypeClassItemProvider.dispose();
		if (uebertragungswegItemProvider != null) uebertragungswegItemProvider.dispose();
		if (uebertragungsweg_Art_TypeClassItemProvider != null) uebertragungsweg_Art_TypeClassItemProvider.dispose();
		if (uebertragungsweg_Technik_AttributeGroupItemProvider != null) uebertragungsweg_Technik_AttributeGroupItemProvider.dispose();
		if (unterbringungItemProvider != null) unterbringungItemProvider.dispose();
		if (unterbringung_Allg_AttributeGroupItemProvider != null) unterbringung_Allg_AttributeGroupItemProvider.dispose();
		if (unterbringung_Art_TypeClassItemProvider != null) unterbringung_Art_TypeClassItemProvider.dispose();
		if (unterbringung_Befestigung_TypeClassItemProvider != null) unterbringung_Befestigung_TypeClassItemProvider.dispose();
		if (unterbringung_Polygonzug_TypeClassItemProvider != null) unterbringung_Polygonzug_TypeClassItemProvider.dispose();
		if (zusatzinformation_Stellwerk_TypeClassItemProvider != null) zusatzinformation_Stellwerk_TypeClassItemProvider.dispose();
	}

}
