/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Bahnuebergang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMBUE Handschalteinrichtung</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Bahnuebergang.BahnuebergangPackage#getENUMBUEHandschalteinrichtung()
 * @model extendedMetaData="name='ENUMBUE_Handschalteinrichtung'"
 * @generated
 */
public enum ENUMBUEHandschalteinrichtung implements Enumerator {
	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung AT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_AT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_AT(0, "ENUMBUE_Handschalteinrichtung_AT", "AT"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung ET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_ET_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_ET(1, "ENUMBUE_Handschalteinrichtung_ET", "ET"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung HAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_HAT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_HAT(2, "ENUMBUE_Handschalteinrichtung_HAT", "HAT"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung HET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_HET_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_HET(3, "ENUMBUE_Handschalteinrichtung_HET", "HET"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung RS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_RS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_RS(4, "ENUMBUE_Handschalteinrichtung_RS", "RS"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung RT ein aus</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS(5, "ENUMBUE_Handschalteinrichtung_RT_ein_aus", "RT_ein_aus"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung RT ein RT aus</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS(6, "ENUMBUE_Handschalteinrichtung_RT_ein_RT_aus", "RT_ein_RT_aus"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE(7, "ENUMBUE_Handschalteinrichtung_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung UT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_UT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMBUE_HANDSCHALTEINRICHTUNG_UT(8, "ENUMBUE_Handschalteinrichtung_UT", "UT");

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung AT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_AT
	 * @model name="ENUMBUE_Handschalteinrichtung_AT" literal="AT"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_AT_VALUE = 0;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung ET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_ET
	 * @model name="ENUMBUE_Handschalteinrichtung_ET" literal="ET"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_ET_VALUE = 1;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung HAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_HAT
	 * @model name="ENUMBUE_Handschalteinrichtung_HAT" literal="HAT"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_HAT_VALUE = 2;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung HET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_HET
	 * @model name="ENUMBUE_Handschalteinrichtung_HET" literal="HET"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_HET_VALUE = 3;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung RS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_RS
	 * @model name="ENUMBUE_Handschalteinrichtung_RS" literal="RS"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_RS_VALUE = 4;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung RT ein aus</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS
	 * @model name="ENUMBUE_Handschalteinrichtung_RT_ein_aus" literal="RT_ein_aus"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS_VALUE = 5;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung RT ein RT aus</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS
	 * @model name="ENUMBUE_Handschalteinrichtung_RT_ein_RT_aus" literal="RT_ein_RT_aus"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS_VALUE = 6;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE
	 * @model name="ENUMBUE_Handschalteinrichtung_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE_VALUE = 7;

	/**
	 * The '<em><b>ENUMBUE Handschalteinrichtung UT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMBUE_HANDSCHALTEINRICHTUNG_UT
	 * @model name="ENUMBUE_Handschalteinrichtung_UT" literal="UT"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMBUE_HANDSCHALTEINRICHTUNG_UT_VALUE = 8;

	/**
	 * An array of all the '<em><b>ENUMBUE Handschalteinrichtung</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMBUEHandschalteinrichtung[] VALUES_ARRAY =
		new ENUMBUEHandschalteinrichtung[] {
			ENUMBUE_HANDSCHALTEINRICHTUNG_AT,
			ENUMBUE_HANDSCHALTEINRICHTUNG_ET,
			ENUMBUE_HANDSCHALTEINRICHTUNG_HAT,
			ENUMBUE_HANDSCHALTEINRICHTUNG_HET,
			ENUMBUE_HANDSCHALTEINRICHTUNG_RS,
			ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS,
			ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS,
			ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE,
			ENUMBUE_HANDSCHALTEINRICHTUNG_UT,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMBUE Handschalteinrichtung</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMBUEHandschalteinrichtung> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMBUE Handschalteinrichtung</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMBUEHandschalteinrichtung get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMBUEHandschalteinrichtung result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMBUE Handschalteinrichtung</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMBUEHandschalteinrichtung getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMBUEHandschalteinrichtung result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMBUE Handschalteinrichtung</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMBUEHandschalteinrichtung get(int value) {
		switch (value) {
			case ENUMBUE_HANDSCHALTEINRICHTUNG_AT_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_AT;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_ET_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_ET;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_HAT_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_HAT;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_HET_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_HET;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_RS_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_RS;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_AUS;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_RT_EIN_RT_AUS;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_SONSTIGE;
			case ENUMBUE_HANDSCHALTEINRICHTUNG_UT_VALUE: return ENUMBUE_HANDSCHALTEINRICHTUNG_UT;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMBUEHandschalteinrichtung(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMBUEHandschalteinrichtung
