/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Balisentechnik_ETCS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMETCS Knoten Art Sonstige</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Balisentechnik_ETCS.Balisentechnik_ETCSPackage#getENUMETCSKnotenArtSonstige()
 * @model extendedMetaData="name='ENUMETCS_Knoten_Art_Sonstige'"
 * @generated
 */
public enum ENUMETCSKnotenArtSonstige implements Enumerator {
	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Gleisabschluss</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS(0, "ENUMETCS_Knoten_Art_Sonstige_Gleisabschluss", "Gleisabschluss"),

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Grenze Ausruestungsbereich</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH(1, "ENUMETCS_Knoten_Art_Sonstige_Grenze_Ausruestungsbereich", "Grenze_Ausruestungsbereich"),

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Km Sprung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG(2, "ENUMETCS_Knoten_Art_Sonstige_Km_Sprung", "Km_Sprung"),

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Kr W</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W(3, "ENUMETCS_Knoten_Art_Sonstige_KrW", "KrW"),

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE(4, "ENUMETCS_Knoten_Art_Sonstige_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Streckenende</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE(5, "ENUMETCS_Knoten_Art_Sonstige_Streckenende", "Streckenende"),

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Streckenwechsel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL(6, "ENUMETCS_Knoten_Art_Sonstige_Streckenwechsel", "Streckenwechsel");

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Gleisabschluss</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_Gleisabschluss" literal="Gleisabschluss"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS_VALUE = 0;

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Grenze Ausruestungsbereich</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_Grenze_Ausruestungsbereich" literal="Grenze_Ausruestungsbereich"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH_VALUE = 1;

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Km Sprung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_Km_Sprung" literal="Km_Sprung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG_VALUE = 2;

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Kr W</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_KrW" literal="KrW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W_VALUE = 3;

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE_VALUE = 4;

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Streckenende</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_Streckenende" literal="Streckenende"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE_VALUE = 5;

	/**
	 * The '<em><b>ENUMETCS Knoten Art Sonstige Streckenwechsel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL
	 * @model name="ENUMETCS_Knoten_Art_Sonstige_Streckenwechsel" literal="Streckenwechsel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL_VALUE = 6;

	/**
	 * An array of all the '<em><b>ENUMETCS Knoten Art Sonstige</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMETCSKnotenArtSonstige[] VALUES_ARRAY =
		new ENUMETCSKnotenArtSonstige[] {
			ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS,
			ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH,
			ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG,
			ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W,
			ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE,
			ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE,
			ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMETCS Knoten Art Sonstige</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMETCSKnotenArtSonstige> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMETCS Knoten Art Sonstige</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMETCSKnotenArtSonstige get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMETCSKnotenArtSonstige result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMETCS Knoten Art Sonstige</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMETCSKnotenArtSonstige getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMETCSKnotenArtSonstige result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMETCS Knoten Art Sonstige</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMETCSKnotenArtSonstige get(int value) {
		switch (value) {
			case ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_GLEISABSCHLUSS;
			case ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_GRENZE_AUSRUESTUNGSBEREICH;
			case ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_KM_SPRUNG;
			case ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_KR_W;
			case ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_SONSTIGE;
			case ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENENDE;
			case ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL_VALUE: return ENUMETCS_KNOTEN_ART_SONSTIGE_STRECKENWECHSEL;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMETCSKnotenArtSonstige(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMETCSKnotenArtSonstige
