/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Layoutinformationen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Linie Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Layoutinformationen.LayoutinformationenPackage#getENUMLinieArt()
 * @model extendedMetaData="name='ENUMLinie_Art'"
 * @generated
 */
public enum ENUMLinieArt implements Enumerator {
	/**
	 * The '<em><b>ENUM Linie Art Punktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_PUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_PUNKTLINIE(0, "ENUMLinie_Art_Punktlinie", "Punktlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strich Dreipunktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE(1, "ENUMLinie_Art_Strich_Dreipunktlinie", "Strich-Dreipunktlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strich Punktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_PUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICH_PUNKTLINIE(2, "ENUMLinie_Art_Strich_Punktlinie", "Strich-Punktlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strich Strichlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_STRICHLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICH_STRICHLINIE(3, "ENUMLinie_Art_Strich_Strichlinie", "Strich-Strichlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strich Zweipunktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE(4, "ENUMLinie_Art_Strich_Zweipunktlinie", "Strich-Zweipunktlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strich Zweistrichlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE(5, "ENUMLinie_Art_Strich_Zweistrichlinie", "Strich-Zweistrichlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strichlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICHLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICHLINIE(6, "ENUMLinie_Art_Strichlinie", "Strichlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Strichlinie lang</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICHLINIE_LANG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_STRICHLINIE_LANG(7, "ENUMLinie_Art_Strichlinie_lang", "Strichlinie lang"),

	/**
	 * The '<em><b>ENUM Linie Art Volllinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_VOLLLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_VOLLLINIE(8, "ENUMLinie_Art_Volllinie", "Volllinie"),

	/**
	 * The '<em><b>ENUM Linie Art Zweistrich Dreipunktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE(9, "ENUMLinie_Art_Zweistrich_Dreipunktlinie", "Zweistrich-Dreipunktlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Zweistrich Punktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE(10, "ENUMLinie_Art_Zweistrich_Punktlinie", "Zweistrich-Punktlinie"),

	/**
	 * The '<em><b>ENUM Linie Art Zweistrich Zweipunktlinie</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE(11, "ENUMLinie_Art_Zweistrich_Zweipunktlinie", "Zweistrich-Zweipunktlinie");

	/**
	 * The '<em><b>ENUM Linie Art Punktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_PUNKTLINIE
	 * @model name="ENUMLinie_Art_Punktlinie" literal="Punktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_PUNKTLINIE_VALUE = 0;

	/**
	 * The '<em><b>ENUM Linie Art Strich Dreipunktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE
	 * @model name="ENUMLinie_Art_Strich_Dreipunktlinie" literal="Strich-Dreipunktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE_VALUE = 1;

	/**
	 * The '<em><b>ENUM Linie Art Strich Punktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_PUNKTLINIE
	 * @model name="ENUMLinie_Art_Strich_Punktlinie" literal="Strich-Punktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICH_PUNKTLINIE_VALUE = 2;

	/**
	 * The '<em><b>ENUM Linie Art Strich Strichlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_STRICHLINIE
	 * @model name="ENUMLinie_Art_Strich_Strichlinie" literal="Strich-Strichlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICH_STRICHLINIE_VALUE = 3;

	/**
	 * The '<em><b>ENUM Linie Art Strich Zweipunktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE
	 * @model name="ENUMLinie_Art_Strich_Zweipunktlinie" literal="Strich-Zweipunktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE_VALUE = 4;

	/**
	 * The '<em><b>ENUM Linie Art Strich Zweistrichlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE
	 * @model name="ENUMLinie_Art_Strich_Zweistrichlinie" literal="Strich-Zweistrichlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE_VALUE = 5;

	/**
	 * The '<em><b>ENUM Linie Art Strichlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICHLINIE
	 * @model name="ENUMLinie_Art_Strichlinie" literal="Strichlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICHLINIE_VALUE = 6;

	/**
	 * The '<em><b>ENUM Linie Art Strichlinie lang</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_STRICHLINIE_LANG
	 * @model name="ENUMLinie_Art_Strichlinie_lang" literal="Strichlinie lang"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_STRICHLINIE_LANG_VALUE = 7;

	/**
	 * The '<em><b>ENUM Linie Art Volllinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_VOLLLINIE
	 * @model name="ENUMLinie_Art_Volllinie" literal="Volllinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_VOLLLINIE_VALUE = 8;

	/**
	 * The '<em><b>ENUM Linie Art Zweistrich Dreipunktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE
	 * @model name="ENUMLinie_Art_Zweistrich_Dreipunktlinie" literal="Zweistrich-Dreipunktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE_VALUE = 9;

	/**
	 * The '<em><b>ENUM Linie Art Zweistrich Punktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE
	 * @model name="ENUMLinie_Art_Zweistrich_Punktlinie" literal="Zweistrich-Punktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE_VALUE = 10;

	/**
	 * The '<em><b>ENUM Linie Art Zweistrich Zweipunktlinie</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE
	 * @model name="ENUMLinie_Art_Zweistrich_Zweipunktlinie" literal="Zweistrich-Zweipunktlinie"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE_VALUE = 11;

	/**
	 * An array of all the '<em><b>ENUM Linie Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMLinieArt[] VALUES_ARRAY =
		new ENUMLinieArt[] {
			ENUM_LINIE_ART_PUNKTLINIE,
			ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE,
			ENUM_LINIE_ART_STRICH_PUNKTLINIE,
			ENUM_LINIE_ART_STRICH_STRICHLINIE,
			ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE,
			ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE,
			ENUM_LINIE_ART_STRICHLINIE,
			ENUM_LINIE_ART_STRICHLINIE_LANG,
			ENUM_LINIE_ART_VOLLLINIE,
			ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE,
			ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE,
			ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Linie Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMLinieArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Linie Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMLinieArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMLinieArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Linie Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMLinieArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMLinieArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Linie Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMLinieArt get(int value) {
		switch (value) {
			case ENUM_LINIE_ART_PUNKTLINIE_VALUE: return ENUM_LINIE_ART_PUNKTLINIE;
			case ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE_VALUE: return ENUM_LINIE_ART_STRICH_DREIPUNKTLINIE;
			case ENUM_LINIE_ART_STRICH_PUNKTLINIE_VALUE: return ENUM_LINIE_ART_STRICH_PUNKTLINIE;
			case ENUM_LINIE_ART_STRICH_STRICHLINIE_VALUE: return ENUM_LINIE_ART_STRICH_STRICHLINIE;
			case ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE_VALUE: return ENUM_LINIE_ART_STRICH_ZWEIPUNKTLINIE;
			case ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE_VALUE: return ENUM_LINIE_ART_STRICH_ZWEISTRICHLINIE;
			case ENUM_LINIE_ART_STRICHLINIE_VALUE: return ENUM_LINIE_ART_STRICHLINIE;
			case ENUM_LINIE_ART_STRICHLINIE_LANG_VALUE: return ENUM_LINIE_ART_STRICHLINIE_LANG;
			case ENUM_LINIE_ART_VOLLLINIE_VALUE: return ENUM_LINIE_ART_VOLLLINIE;
			case ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE_VALUE: return ENUM_LINIE_ART_ZWEISTRICH_DREIPUNKTLINIE;
			case ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE_VALUE: return ENUM_LINIE_ART_ZWEISTRICH_PUNKTLINIE;
			case ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE_VALUE: return ENUM_LINIE_ART_ZWEISTRICH_ZWEIPUNKTLINIE;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMLinieArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMLinieArt
