/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Medien_und_Trassen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Trasse Kante Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * "frei"==Kabelverlegung ohne Kabeltiefbau (z. B. Verlegung auf Schotter, Verbindung benachbarter Schaltschränke)
 * <!-- end-model-doc -->
 * @see org.eclipse.set.toolboxmodel.Medien_und_Trassen.Medien_und_TrassenPackage#getENUMTrasseKanteArt()
 * @model extendedMetaData="name='ENUMTrasse_Kante_Art'"
 * @generated
 */
public enum ENUMTrasseKanteArt implements Enumerator {
	/**
	 * The '<em><b>ENUM Trasse Kante Art Erdtrasse</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_ERDTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_ERDTRASSE(0, "ENUMTrasse_Kante_Art_Erdtrasse", "Erdtrasse"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art frei</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_FREI_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_FREI(1, "ENUMTrasse_Kante_Art_frei", "frei"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art Kabelgestell Tunnel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL(2, "ENUMTrasse_Kante_Art_Kabelgestell_Tunnel", "Kabelgestell_Tunnel"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art Lufttrasse</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_LUFTTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_LUFTTRASSE(3, "ENUMTrasse_Kante_Art_Lufttrasse", "Lufttrasse"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art Rohrtrasse</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_ROHRTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_ROHRTRASSE(4, "ENUMTrasse_Kante_Art_Rohrtrasse", "Rohrtrasse"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_SONSTIGE(5, "ENUMTrasse_Kante_Art_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art Trogtrasse</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_TROGTRASSE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_TROGTRASSE(6, "ENUMTrasse_Kante_Art_Trogtrasse", "Trogtrasse"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art Trogtrasse aufgestaendert</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT(7, "ENUMTrasse_Kante_Art_Trogtrasse_aufgestaendert", "Trogtrasse_aufgestaendert"),

	/**
	 * The '<em><b>ENUM Trasse Kante Art Trogtrasse Behelf</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF(8, "ENUMTrasse_Kante_Art_Trogtrasse_Behelf", "Trogtrasse_Behelf");

	/**
	 * The '<em><b>ENUM Trasse Kante Art Erdtrasse</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_ERDTRASSE
	 * @model name="ENUMTrasse_Kante_Art_Erdtrasse" literal="Erdtrasse"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_ERDTRASSE_VALUE = 0;

	/**
	 * The '<em><b>ENUM Trasse Kante Art frei</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_FREI
	 * @model name="ENUMTrasse_Kante_Art_frei" literal="frei"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_FREI_VALUE = 1;

	/**
	 * The '<em><b>ENUM Trasse Kante Art Kabelgestell Tunnel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL
	 * @model name="ENUMTrasse_Kante_Art_Kabelgestell_Tunnel" literal="Kabelgestell_Tunnel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL_VALUE = 2;

	/**
	 * The '<em><b>ENUM Trasse Kante Art Lufttrasse</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_LUFTTRASSE
	 * @model name="ENUMTrasse_Kante_Art_Lufttrasse" literal="Lufttrasse"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_LUFTTRASSE_VALUE = 3;

	/**
	 * The '<em><b>ENUM Trasse Kante Art Rohrtrasse</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_ROHRTRASSE
	 * @model name="ENUMTrasse_Kante_Art_Rohrtrasse" literal="Rohrtrasse"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_ROHRTRASSE_VALUE = 4;

	/**
	 * The '<em><b>ENUM Trasse Kante Art sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_SONSTIGE
	 * @model name="ENUMTrasse_Kante_Art_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_SONSTIGE_VALUE = 5;

	/**
	 * The '<em><b>ENUM Trasse Kante Art Trogtrasse</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_TROGTRASSE
	 * @model name="ENUMTrasse_Kante_Art_Trogtrasse" literal="Trogtrasse"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_TROGTRASSE_VALUE = 6;

	/**
	 * The '<em><b>ENUM Trasse Kante Art Trogtrasse aufgestaendert</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT
	 * @model name="ENUMTrasse_Kante_Art_Trogtrasse_aufgestaendert" literal="Trogtrasse_aufgestaendert"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT_VALUE = 7;

	/**
	 * The '<em><b>ENUM Trasse Kante Art Trogtrasse Behelf</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF
	 * @model name="ENUMTrasse_Kante_Art_Trogtrasse_Behelf" literal="Trogtrasse_Behelf"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF_VALUE = 8;

	/**
	 * An array of all the '<em><b>ENUM Trasse Kante Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMTrasseKanteArt[] VALUES_ARRAY =
		new ENUMTrasseKanteArt[] {
			ENUM_TRASSE_KANTE_ART_ERDTRASSE,
			ENUM_TRASSE_KANTE_ART_FREI,
			ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL,
			ENUM_TRASSE_KANTE_ART_LUFTTRASSE,
			ENUM_TRASSE_KANTE_ART_ROHRTRASSE,
			ENUM_TRASSE_KANTE_ART_SONSTIGE,
			ENUM_TRASSE_KANTE_ART_TROGTRASSE,
			ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT,
			ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Trasse Kante Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMTrasseKanteArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Trasse Kante Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMTrasseKanteArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMTrasseKanteArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Trasse Kante Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMTrasseKanteArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMTrasseKanteArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Trasse Kante Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMTrasseKanteArt get(int value) {
		switch (value) {
			case ENUM_TRASSE_KANTE_ART_ERDTRASSE_VALUE: return ENUM_TRASSE_KANTE_ART_ERDTRASSE;
			case ENUM_TRASSE_KANTE_ART_FREI_VALUE: return ENUM_TRASSE_KANTE_ART_FREI;
			case ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL_VALUE: return ENUM_TRASSE_KANTE_ART_KABELGESTELL_TUNNEL;
			case ENUM_TRASSE_KANTE_ART_LUFTTRASSE_VALUE: return ENUM_TRASSE_KANTE_ART_LUFTTRASSE;
			case ENUM_TRASSE_KANTE_ART_ROHRTRASSE_VALUE: return ENUM_TRASSE_KANTE_ART_ROHRTRASSE;
			case ENUM_TRASSE_KANTE_ART_SONSTIGE_VALUE: return ENUM_TRASSE_KANTE_ART_SONSTIGE;
			case ENUM_TRASSE_KANTE_ART_TROGTRASSE_VALUE: return ENUM_TRASSE_KANTE_ART_TROGTRASSE;
			case ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT_VALUE: return ENUM_TRASSE_KANTE_ART_TROGTRASSE_AUFGESTAENDERT;
			case ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF_VALUE: return ENUM_TRASSE_KANTE_ART_TROGTRASSE_BEHELF;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMTrasseKanteArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMTrasseKanteArt
