/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.jdt.loaders;

import com.google.common.base.Objects;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class DelegatingCompositeBundleClassLoader
extends SecureClassLoader {
    private List<Bundle> bundles;
    private List<ClassLoader> bundleClassLoaders = null;

    public DelegatingCompositeBundleClassLoader(ClassLoader parent, List<Bundle> bundles) {
        super(parent);
        Assert.isNotNull(bundles);
        this.bundles = bundles;
    }

    public List<ClassLoader> getBundleClassLoaders() {
        List<ClassLoader> _xblockexpression = null;
        boolean _equals = Objects.equal(this.bundleClassLoaders, null);
        if (_equals) {
            Functions.Function1<Bundle, BundleWiring> _function = new Functions.Function1<Bundle, BundleWiring>(){

                public BundleWiring apply(Bundle it) {
                    return (BundleWiring)it.adapt(BundleWiring.class);
                }
            };
            Functions.Function1<BundleWiring, ClassLoader> _function_1 = new Functions.Function1<BundleWiring, ClassLoader>(){

                public ClassLoader apply(BundleWiring it) {
                    return it.getClassLoader();
                }
            };
            this.bundleClassLoaders = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(this.bundles, (Functions.Function1)_function)), (Functions.Function1)_function_1));
        }
        _xblockexpression = this.bundleClassLoaders;
        return _xblockexpression;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        List<ClassLoader> _bundleClassLoaders = this.getBundleClassLoaders();
        for (ClassLoader bundleClassLoader : _bundleClassLoaders) {
            try {
                Class<?> clazz = bundleClassLoader.loadClass(name);
                return clazz;
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) continue;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    public String toString() {
        String _name = this.getClass().getName();
        String _plus = String.valueOf(_name) + " [bundles=";
        String _string = Arrays.toString(this.bundles.toArray());
        String _plus_1 = String.valueOf(_plus) + _string;
        return String.valueOf(_plus_1) + "]";
    }
}

