/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.DbgpServer;
import org.eclipse.dltk.dbgp.DbgpServerException;
import org.eclipse.dltk.dbgp.IDbgpServer;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.debug.core.IDbgpService;

public class DbgpService
implements IDbgpService {
    private static final boolean DEBUG = DLTKCore.DEBUG;
    private static final int PORT_SEARCH_BEGIN = 10000;
    private static final int PORT_SEARCH_END = 50000;
    private static final int SERVER_TIMEOUT = 1000 * (DEBUG ? 30 : 3600);
    private static final int CLIENT_TIMEOUT = 1000 * (DEBUG ? 30 : 7200);
    private final IDbgpServer server = new DbgpServer(CLIENT_TIMEOUT, SERVER_TIMEOUT);

    public static IDbgpService getService() throws Exception {
        return new DbgpService(10000, 50000);
    }

    public static IDbgpService getService(int port) throws Exception {
        return new DbgpService(port);
    }

    public static IDbgpService getService(int portBegin, int portEnd) throws Exception {
        return new DbgpService(portBegin, portEnd);
    }

    protected DbgpService(int port) throws DbgpServerException {
        this.server.start(port);
    }

    protected DbgpService(int startPort, int endPort) throws DbgpServerException {
        this.server.start(startPort, endPort);
    }

    public int getPort() {
        try {
            return this.server.getPort();
        }
        catch (DbgpServerException e) {
            DebugPlugin.log((Throwable)e);
            return -1;
        }
    }

    public void registerAcceptor(String id, IDbgpThreadAcceptor acceptor) {
        try {
            this.server.registerAcceptor(id, acceptor);
        }
        catch (DbgpServerException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    public IDbgpThreadAcceptor unregisterAcceptor(String id) {
        return this.server.unregisterAcceptor(id);
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (DbgpServerException e) {
            DebugPlugin.log((Throwable)e);
        }
    }
}

