/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.text.edits.UndoEdit;

class UndoSourceModuleChange
extends UndoTextFileChange {
    private ISourceModule fCUnit;

    public UndoSourceModuleChange(String name, ISourceModule unit, UndoEdit undo, ContentStamp stampToRestore, int saveMode) throws CoreException {
        super(name, UndoSourceModuleChange.getFile(unit), undo, stampToRestore, saveMode);
        this.fCUnit = unit;
    }

    private static IFile getFile(ISourceModule cunit) throws CoreException {
        IFile file = (IFile)cunit.getResource();
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", 4, Messages.format(RefactoringCoreMessages.UndoSourceModuleChange_no_resource, cunit.getElementName()), null));
        }
        return file;
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoSourceModuleChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        try {
            change = super.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.fCUnit.discardWorkingCopy();
            throw throwable;
        }
        this.fCUnit.discardWorkingCopy();
        return change;
    }
}

