/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.model.binary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.model.binary.BinaryField;
import org.eclipse.dltk.core.model.binary.BinaryMethod;
import org.eclipse.dltk.core.model.binary.BinaryModuleElementInfo;
import org.eclipse.dltk.core.model.binary.BinaryModuleStructureRequestor;
import org.eclipse.dltk.core.model.binary.BinaryType;
import org.eclipse.dltk.core.model.binary.IBinaryElementParser;
import org.eclipse.dltk.core.model.binary.IBinaryModule;
import org.eclipse.dltk.core.model.binary.ISourceMapperProvider;
import org.eclipse.dltk.core.model.binary.SourceMapper;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelProviderManager;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.osgi.util.NLS;

public class BinaryModule
extends AbstractSourceModule
implements IBinaryModule,
IExternalSourceModule,
ISourceMapperProvider,
org.eclipse.dltk.compiler.env.ISourceModule {
    protected BinaryModule(ModelElement parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    protected Object createElementInfo() {
        return new BinaryModuleElementInfo();
    }

    protected IStatus validateSourceModule(IDLTKLanguageToolkit toolkit, IResource resource) {
        return Status.OK_STATUS;
    }

    protected IStatus validateSourceModule(IResource resource) {
        return Status.OK_STATUS;
    }

    public boolean exists() {
        return true;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        BinaryModuleElementInfo moduleInfo = (BinaryModuleElementInfo)info;
        IBinaryElementParser binaryParser = DLTKLanguageManager.getBinaryElementParser(this);
        if (binaryParser == null) {
            DLTKCore.error(NLS.bind((String)"Binary parser for {0} not found", (Object)this.getPath()));
            return false;
        }
        BinaryModuleStructureRequestor requestor = new BinaryModuleStructureRequestor(this, moduleInfo, this.getSourceMapper(), newElements);
        binaryParser.setRequestor(requestor);
        binaryParser.parseBinaryModule(this);
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        IModelProvider[] providers = ModelProviderManager.getProviders(toolkit.getNatureId());
        if (providers != null) {
            ArrayList<IModelElement> childrenSet = new ArrayList<IModelElement>(moduleInfo.getChildrenAsList());
            int i = 0;
            while (i < providers.length) {
                providers[i].provideModelChanges(this, childrenSet);
                ++i;
            }
            moduleInfo.setChildren(childrenSet);
        }
        return moduleInfo.isStructureKnown();
    }

    public IResource getResource() {
        return null;
    }

    public SourceMapper getSourceMapper() {
        IModelElement parent = this.getParent();
        if (parent instanceof ISourceMapperProvider) {
            return ((ISourceMapperProvider)((Object)parent)).getSourceMapper();
        }
        return null;
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected char getHandleMementoDelimiter() {
        return '}';
    }

    public void printNode(CorePrinter output) {
    }

    public int getElementType() {
        return 5;
    }

    public String getSource() throws ModelException {
        String content;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (content = mapper.getSource(this)) != null) {
            return content;
        }
        return "//Binary source are not available";
    }

    public ISourceRange getSourceRange() throws ModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return mapper.getSourceRange(this);
        }
        return null;
    }

    public char[] getSourceAsCharArray() throws ModelException {
        return this.getSource().toCharArray();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
    }

    public void discardWorkingCopy() throws ModelException {
    }

    public ISourceModule getPrimary() {
        return this;
    }

    public ISourceModule getWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this;
    }

    public ISourceModule getWorkingCopy(WorkingCopyOwner owner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        return this;
    }

    public boolean isBuiltin() {
        return false;
    }

    public boolean isPrimary() {
        return true;
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void reconcile(boolean forceProblemDetection, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    protected char[] getBufferContent() throws ModelException {
        return this.getSource().toCharArray();
    }

    protected String getModuleType() {
        return "Binary Source Module";
    }

    protected ISourceModule getOriginalSourceModule() {
        return this;
    }

    protected String getNatureId() {
        IDLTKLanguageToolkit lookupLanguageToolkit = this.lookupLanguageToolkit(this.getScriptProject());
        if (lookupLanguageToolkit == null) {
            return null;
        }
        return lookupLanguageToolkit.getNatureId();
    }

    public String getFileName() {
        return this.getPath().toOSString();
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getElementName());
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.getSource().getBytes());
    }

    public IPath getFullPath() {
        return this.getPath();
    }

    public String getName() {
        return this.getPath().lastSegment();
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento(memento, this, workingCopyOwner);
            }
        }
        return null;
    }

    public IType getType(String typeName) {
        try {
            IType[] types;
            IType[] iTypeArray = types = this.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (type.getElementName().equals(typeName)) {
                    return type;
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
        return new BinaryType(this.parent, typeName);
    }

    public IMethod getMethod(String selector) {
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(selector)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
        return new BinaryMethod(this.parent, selector);
    }

    public IField getField(String fieldName) {
        try {
            IField[] fields;
            IField[] iFieldArray = fields = this.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (field.getElementName().equals(fieldName)) {
                    return field;
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
        return new BinaryField(this.parent, fieldName);
    }
}

