/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptDebugElement;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;

public abstract class ScriptDebugElement
extends PlatformObject
implements IScriptDebugElement {
    @Override
    public IScriptDebugTarget getScriptDebugTarget() {
        return (IScriptDebugTarget)this.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDebugElement.class) {
            return this;
        }
        if (adapter == IDebugTarget.class) {
            return this.getDebugTarget();
        }
        if (adapter == ITerminate.class) {
            return this.getDebugTarget();
        }
        if (adapter == IScriptDebugTarget.class) {
            return this.getScriptDebugTarget();
        }
        if (adapter == ILaunch.class) {
            return this.getLaunch();
        }
        return super.getAdapter(adapter);
    }

    protected void abort(String message, Throwable e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.dltk.debug", 120, message, e));
    }

    protected DebugException makeNotSupported(String message, Throwable e) throws DebugException {
        return new DebugException((IStatus)new Status(4, "org.eclipse.dltk.debug", 5011, message, e));
    }

    protected DebugException wrapDbgpException(String message, DbgpException e) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, message, (Throwable)e));
    }

    protected DebugException wrapIOException(String message, IOException e) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, message, (Throwable)e));
    }
}

