/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.environment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.FileHandles;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.osgi.util.NLS;

public class FileAsFileHandle
implements IFileHandle {
    private final IEnvironment environment;
    private final File file;

    public FileAsFileHandle(File file) {
        this(LocalEnvironment.getInstance(), file);
    }

    public FileAsFileHandle(IEnvironment environment, File file) {
        this.environment = environment;
        this.file = file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public String getCanonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return this.file.getPath();
        }
    }

    @Override
    public IFileHandle getChild(String path) {
        return new FileAsFileHandle(this.environment, new File(this.file, path));
    }

    @Override
    public IFileHandle[] getChildren() {
        File[] children = this.file.listFiles();
        if (children != null) {
            IFileHandle[] result = new IFileHandle[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new FileAsFileHandle(this.environment, children[i]);
                ++i;
            }
            return result;
        }
        return null;
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getEnvironmentId() {
        return this.environment.getId();
    }

    @Override
    public IPath getFullPath() {
        return EnvironmentPathUtils.getFullPath(this.environment, this.getPath());
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IFileHandle getParent() {
        File parentFile = this.file.getParentFile();
        if (parentFile != null) {
            return new FileAsFileHandle(this.environment, parentFile);
        }
        return null;
    }

    @Override
    public IPath getPath() {
        return new Path(this.file.getPath());
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isSymlink() {
        return EFS.getLocalFileSystem().getStore(this.file.toURI()).fetchInfo().getAttribute(32);
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream(IProgressMonitor monitor) throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String toOSString() {
        return this.file.getPath();
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public void move(IFileHandle destination) throws CoreException {
        File destFile = FileHandles.asFile(destination);
        if (!this.file.renameTo(destFile)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", NLS.bind((String)"Rename {0} to {1} failed", (Object)this.file, (Object)destFile)));
        }
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }
}

