/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;

public class RubyEvaluatorFactory
implements IGoalEvaluatorFactory {
    private static final String GOAL_EVALUATOR_FACTORIES_EXT = "org.eclipse.dltk.ruby.core.goalEvaluatorFactories";
    private static final FactoryInfo[] f;

    static {
        ArrayList<FactoryInfo> factories = new ArrayList<FactoryInfo>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(GOAL_EVALUATOR_FACTORIES_EXT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            try {
                int priority = RubyEvaluatorFactory.getPriority(element);
                IGoalEvaluatorFactory factory = (IGoalEvaluatorFactory)element.createExecutableExtension("class");
                if (factory != null) {
                    factories.add(new FactoryInfo(priority, factory));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        f = factories.toArray(new FactoryInfo[factories.size()]);
        Arrays.sort(f, new Comparator<FactoryInfo>(){

            @Override
            public int compare(FactoryInfo f1, FactoryInfo f2) {
                return f2.priority - f1.priority;
            }
        });
    }

    private static int getPriority(IConfigurationElement element) {
        String priority = element.getAttribute("priority");
        if (priority == null) {
            return 0;
        }
        try {
            int parseInt = Integer.parseInt(priority);
            return parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public GoalEvaluator createEvaluator(IGoal goal) {
        if (f == null) {
            return null;
        }
        int i = 0;
        while (i < f.length) {
            GoalEvaluator evaluator = RubyEvaluatorFactory.f[i].factory.createEvaluator(goal);
            if (evaluator != null) {
                return evaluator;
            }
            ++i;
        }
        return null;
    }

    private static class FactoryInfo {
        int priority;
        IGoalEvaluatorFactory factory;

        public FactoryInfo(int priority, IGoalEvaluatorFactory factory) {
            this.priority = priority;
            this.factory = factory;
        }
    }
}

