/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.text.completion.ScriptTypeCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class RubyOverrideCompletionProposal
extends ScriptTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private String fMethodName;

    public RubyOverrideCompletionProposal(ISourceModule cu, String methodName, int start, int length, String displayName, String completionProposal) {
        super(completionProposal, cu, start, length, null, displayName, 0);
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)cu);
        this.fMethodName = methodName;
        StringBuffer buffer = new StringBuffer();
        buffer.append(completionProposal);
        this.setReplacementString(buffer.toString());
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fMethodName;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset) throws CoreException, BadLocationException {
        Document buffer = new Document(document.get());
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(buffer.getChar(index))) {
            --index;
        }
        int length = offset - index - 1;
        buffer.replace(index + 1, length, " ");
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getDisplayString(), this.getDisplayString());
    }
}

