/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.jsjdtdebugger;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JavaScriptAndJdtDebuggerPlugin
extends AbstractUIPlugin
implements IDebugEventSetListener,
Preferences.IPropertyChangeListener {
    private static final String SUSPEND_ON_ENTRY = "suspendOnEntry";
    private static final String SUSPEND_ON_EXIT = "suspendOnExit";
    private static final String SUSPEND_ON_EXCEPTION = "suspendOnException";
    public static final String PLUGIN_ID = "org.eclipse.dltk.javascript.jsjdtdebugger";
    private static JavaScriptAndJdtDebuggerPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Preferences prefs = this.getPluginPreferences();
        this.resetSuspendProperties(prefs);
        prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    private void resetSuspendProperties(Preferences prefs) {
        prefs.setValue("breakOnMethodEntry", false);
        prefs.setValue("breakOnMethodExit", false);
        prefs.setValue("breakOnException", false);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        plugin = null;
        super.stop(context);
    }

    public static JavaScriptAndJdtDebuggerPlugin getDefault() {
        return plugin;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 4 && this.checkThread(event.getSource())) {
                IScriptThread thread = (IScriptThread)event.getSource();
                this.setupBreakOnMethodEntry(thread);
                this.setupBreakOnMethodExit(thread);
                this.setupBreakOnException(thread);
            }
            ++i;
        }
    }

    private boolean checkThread(Object source) {
        if (source instanceof IScriptThread) {
            IScriptThread thread = (IScriptThread)source;
            return "org.eclipse.dltk.debug.javascriptModel".equals(thread.getModelIdentifier());
        }
        return false;
    }

    private void setupBreakOnMethodEntry(IScriptThread thread) {
        IDbgpCoreCommands propCmds = thread.getDbgpSession().getCoreCommands();
        try {
            Preferences prefs = this.getPluginPreferences();
            String suspendOnEntry = prefs.getString("breakOnMethodEntry");
            propCmds.setProperty(SUSPEND_ON_ENTRY, -1, suspendOnEntry);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    private void setupBreakOnMethodExit(IScriptThread thread) {
        IDbgpCoreCommands propCmds = thread.getDbgpSession().getCoreCommands();
        try {
            Preferences prefs = this.getPluginPreferences();
            String suspendOnExit = prefs.getString("breakOnMethodExit");
            propCmds.setProperty(SUSPEND_ON_EXIT, -1, suspendOnExit);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    private void setupBreakOnException(IScriptThread thread) {
        IDbgpCoreCommands propCmds = thread.getDbgpSession().getCoreCommands();
        try {
            Preferences prefs = this.getPluginPreferences();
            String suspendOnException = prefs.getString("breakOnException");
            propCmds.setProperty(SUSPEND_ON_EXCEPTION, -1, suspendOnException);
        }
        catch (DbgpException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    private boolean isThisDebuggerLaunch(ILaunch launch) {
        String engineId = launch.getAttribute("debugging_engine_id");
        return PLUGIN_ID.equals(engineId);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("breakOnMethodEntry".equals(event.getProperty())) {
            this.runForEachDebuggerThread(new IDebuggerThreadVisitor(){

                @Override
                public void visit(IScriptThread thread) {
                    JavaScriptAndJdtDebuggerPlugin.this.setupBreakOnMethodEntry(thread);
                }
            });
        } else if ("breakOnMethodExit".equals(event.getProperty())) {
            this.runForEachDebuggerThread(new IDebuggerThreadVisitor(){

                @Override
                public void visit(IScriptThread thread) {
                    JavaScriptAndJdtDebuggerPlugin.this.setupBreakOnMethodExit(thread);
                }
            });
        } else if ("breakOnException".equals(event.getProperty())) {
            this.runForEachDebuggerThread(new IDebuggerThreadVisitor(){

                @Override
                public void visit(IScriptThread thread) {
                    JavaScriptAndJdtDebuggerPlugin.this.setupBreakOnException(thread);
                }
            });
        }
    }

    private void runForEachDebuggerThread(IDebuggerThreadVisitor visitor) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IDebugTarget target = launch.getDebugTarget();
            if (target != null && "org.eclipse.dltk.debug.javascriptModel".equals(target.getModelIdentifier())) {
                IThread[] threads = null;
                try {
                    threads = target.getThreads();
                }
                catch (DebugException e) {
                    DLTKDebugUIPlugin.log((Throwable)e);
                }
                if (threads != null && threads.length != 0) {
                    int t = 0;
                    while (t < threads.length) {
                        if (this.checkThread(threads[t])) {
                            IScriptThread scriptThread = (IScriptThread)threads[t];
                            visitor.visit(scriptThread);
                        }
                        ++t;
                    }
                }
            }
            ++i;
        }
    }

    private static interface IDebuggerThreadVisitor {
        public void visit(IScriptThread var1);
    }
}

