/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;

public class ResourceOperationTypeAdapter
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!ResourceOperation.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        return new InnerResourceOperationTypeAdapter(this, gson).nullSafe();
    }

    private static class InnerResourceOperationTypeAdapter
    extends TypeAdapter<ResourceOperation> {
        TypeAdapter<CreateFile> createFileAdapter;
        TypeAdapter<DeleteFile> deleteFileAdapter;
        TypeAdapter<RenameFile> renameFileAdapter;

        InnerResourceOperationTypeAdapter(TypeAdapterFactory factory, Gson gson) {
            this.createFileAdapter = gson.getDelegateAdapter(factory, TypeToken.get(CreateFile.class));
            this.deleteFileAdapter = gson.getDelegateAdapter(factory, TypeToken.get(DeleteFile.class));
            this.renameFileAdapter = gson.getDelegateAdapter(factory, TypeToken.get(RenameFile.class));
        }

        public void write(JsonWriter out, ResourceOperation value) throws IOException {
            if (value.getClass().isAssignableFrom(CreateFile.class)) {
                this.createFileAdapter.write(out, (Object)((CreateFile)value));
            } else if (value.getClass().isAssignableFrom(DeleteFile.class)) {
                this.deleteFileAdapter.write(out, (Object)((DeleteFile)value));
            } else if (value.getClass().isAssignableFrom(RenameFile.class)) {
                this.renameFileAdapter.write(out, (Object)((RenameFile)value));
            }
        }

        public ResourceOperation read(JsonReader in) throws IOException {
            JsonObject objectJson = JsonParser.parseReader((JsonReader)in).getAsJsonObject();
            JsonElement value = objectJson.get("kind");
            if (value != null && value.isJsonPrimitive()) {
                String kindValue = value.getAsString();
                if ("create".equals(kindValue)) {
                    return (ResourceOperation)this.createFileAdapter.fromJsonTree((JsonElement)objectJson);
                }
                if ("delete".equals(kindValue)) {
                    return (ResourceOperation)this.deleteFileAdapter.fromJsonTree((JsonElement)objectJson);
                }
                if ("rename".equals(kindValue)) {
                    return (ResourceOperation)this.renameFileAdapter.fromJsonTree((JsonElement)objectJson);
                }
            }
            throw new JsonParseException("The ResourceOperation object either has null \"kind\" value or the \"kind\" value is not valid.");
        }
    }
}

