/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.io.IOException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.internet.monitor.core.internal.IContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.provisional.ContentFilterDelegate;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class ContentFilter
implements IContentFilter {
    protected IConfigurationElement element;
    protected ContentFilterDelegate delegate;

    protected ContentFilter(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            return Integer.parseInt(this.element.getAttribute("order"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String getName() {
        return this.element.getAttribute("name");
    }

    @Override
    public byte[] filter(Request request, boolean isRequest, byte[] content) throws IOException {
        if (this.delegate == null) {
            try {
                this.delegate = (ContentFilterDelegate)this.element.createExecutableExtension("class");
            }
            catch (Exception e) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Could not create content filter delegate: " + this.getId(), e);
                }
                return new byte[0];
            }
        }
        return this.delegate.filter(request, isRequest, content);
    }
}

