/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.progress.DetailedProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.JobsViewPreferenceDialog;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ViewPreferencesAction;

public class ProgressView
extends ViewPart {
    DetailedProgressViewer viewer;
    Action cancelAction;
    Action clearAllAction;
    private IPartListener2 partListener;
    boolean visible;
    ProgressViewerContentProvider provider;

    @Override
    public void createPartControl(Composite parent) {
        this.viewer = new DetailedProgressViewer(parent, 2);
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.responsive_ui_context");
        this.initContentProvider();
        this.createClearAllAction();
        this.createCancelAction();
        this.initContextMenu();
        this.initPulldownMenu();
        this.initToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.partListener = new ActivationListener();
        this.getViewSite().getPage().addPartListener(this.partListener);
    }

    @Override
    public void dispose() {
        IViewSite site = this.getViewSite();
        if (this.partListener != null && site != null) {
            site.getPage().removePartListener(this.partListener);
            this.partListener = null;
        }
        super.dispose();
    }

    @Override
    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    protected void initContentProvider() {
        this.provider = new ProgressViewerContentProvider(this.viewer, true, true);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setInput(ProgressManager.getInstance());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.add((IAction)this.cancelAction);
        menuMgr.addMenuListener(manager -> {
            JobInfo info = this.getSelectedInfo();
            if (info == null) {
                return;
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.viewer.getControl().setMenu(menu);
    }

    private void initPulldownMenu() {
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add((IAction)this.clearAllAction);
        menuMgr.add((IAction)new ViewPreferencesAction(){

            @Override
            public void openViewPreferencesDialog() {
                new JobsViewPreferenceDialog(ProgressView.this.viewer.getControl().getShell()).open();
            }
        });
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        tm.add((IAction)this.clearAllAction);
    }

    private IStructuredSelection getSelection() {
        ISelectionProvider provider = this.getSite().getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection currentSelection = provider.getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)currentSelection;
        }
        return null;
    }

    JobInfo getSelectedInfo() {
        JobTreeElement element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() == 1 && (element = (JobTreeElement)selection.getFirstElement()).isJobInfo()) {
            return (JobInfo)element;
        }
        return null;
    }

    private void createCancelAction() {
        this.cancelAction = new Action(ProgressMessages.ProgressView_CancelAction){

            public void run() {
                ProgressView.this.viewer.cancelSelection();
            }
        };
    }

    private void createClearAllAction() {
        this.clearAllAction = new Action(ProgressMessages.ProgressView_ClearAllAction){

            public void run() {
                FinishedJobs.getInstance().clearAll();
            }
        };
        this.clearAllAction.setToolTipText(ProgressMessages.NewProgressView_RemoveAllJobsToolTip);
        ImageDescriptor id = WorkbenchImages.getWorkbenchImageDescriptor("/elcl16/progress_remall.svg");
        if (id != null) {
            this.clearAllAction.setImageDescriptor(id);
        }
    }

    public DetailedProgressViewer getViewer() {
        return this.viewer;
    }

    class ActivationListener
    implements IPartListener2 {
        ActivationListener() {
        }

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
        }

        @Override
        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        @Override
        public void partClosed(IWorkbenchPartReference partRef) {
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        @Override
        public void partOpened(IWorkbenchPartReference partRef) {
        }

        @Override
        public void partHidden(IWorkbenchPartReference partRef) {
            if (this.isMyPart(partRef)) {
                ProgressView.this.visible = false;
                ProgressView.this.provider.stopListening();
            }
        }

        @Override
        public void partVisible(IWorkbenchPartReference partRef) {
            if (this.isMyPart(partRef)) {
                ProgressView.this.visible = true;
                ProgressView.this.provider.startListening();
            }
        }

        @Override
        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        boolean isMyPart(IWorkbenchPartReference partRef) {
            return ProgressView.this == partRef.getPart(false);
        }
    }
}

