/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassName;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.ast.nodes.TraitStatement;
import org.eclipse.php.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class DeprecatedHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new DeprecatedApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setStrikethroughByDefault(true).setEnabledByDefault(true);
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public String getDisplayName() {
        return Messages.DeprecatedHighlighting_0;
    }

    private void highlightStatic(StaticDispatch dispatch) {
        this.highlightIdentifier((ASTNode)dispatch.getClassName());
    }

    private void highlightIdentifier(ASTNode node) {
        if (node instanceof Identifier) {
            Identifier identifier = (Identifier)node;
            String typeName = identifier.getName();
            if (!("self".equalsIgnoreCase(typeName) || "class".equalsIgnoreCase(typeName) || "parent".equalsIgnoreCase(typeName))) {
                super.highlight((ASTNode)identifier);
            }
            if (node instanceof NamespaceName) {
                this.highlightLastNamespaceSegment((NamespaceName)node);
            }
        } else {
            super.highlight(node);
        }
    }

    private void highlightLastNamespaceSegment(NamespaceName name) {
        List segments = name.segments();
        if (segments.size() > 0) {
            Identifier segment = (Identifier)segments.get(segments.size() - 1);
            if (segments.size() > 1 || name.isGlobal()) {
                super.highlight((ASTNode)segment);
            }
        }
    }

    private void highlightWhenIdentifierIsDeprecated(Identifier identifier) {
        this.highlightWhenIdentifierIsDeprecated(identifier, false);
    }

    private void highlightWhenIdentifierIsDeprecated(Identifier identifier, boolean isTrait) {
        block4: {
            String typeName = identifier.getName();
            IModelAccessCache cache = identifier.getAST().getBindingResolver().getModelAccessCache();
            try {
                IType[] types;
                IType[] iTypeArray = types = isTrait ? PHPModelUtils.getTraits((String)typeName, (ISourceModule)this.getSourceModule(), (int)identifier.getStart(), (IModelAccessCache)cache, (IProgressMonitor)new NullProgressMonitor()) : PHPModelUtils.getTypes((String)typeName, (ISourceModule)this.getSourceModule(), (int)identifier.getStart(), (IModelAccessCache)cache, (IProgressMonitor)new NullProgressMonitor());
                if (types == null) break block4;
                IType[] iTypeArray2 = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray2[n2];
                    if (ModelUtils.isDeprecated((IModelElement)type)) {
                        this.highlightIdentifier((ASTNode)identifier);
                        break;
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
    }

    @Override
    protected AbstractSemanticHighlighting highlight(ASTNode node) {
        if (node instanceof NamespaceName) {
            List segments = ((NamespaceName)node).segments();
            if (!segments.isEmpty()) {
                return super.highlight((ASTNode)segments.get(segments.size() - 1));
            }
            return null;
        }
        return super.highlight(node);
    }

    protected class DeprecatedApply
    extends AbstractSemanticApply {
        protected DeprecatedApply() {
        }

        public boolean visit(Program program) {
            try {
                DeprecatedHighlighting.this.getSourceModule().accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        if (element instanceof IMember) {
                            try {
                                if (ModelUtils.isDeprecated(element)) {
                                    DeprecatedHighlighting.this.highlight(((IMember)element).getNameRange());
                                }
                            }
                            catch (ModelException e) {
                                Logger.logException(e);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
            return true;
        }

        public boolean visit(ClassDeclaration clazz) {
            Expression superClass = clazz.getSuperClass();
            if (superClass instanceof Identifier) {
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)superClass);
            }
            for (Identifier identifier : clazz.interfaces()) {
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated(identifier);
            }
            return true;
        }

        public boolean visit(TraitDeclaration trait) {
            Expression superClass = trait.getSuperClass();
            if (superClass instanceof Identifier) {
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)superClass);
            }
            for (Identifier identifier : trait.interfaces()) {
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated(identifier);
            }
            return true;
        }

        public boolean visit(ClassName className) {
            Expression classNode = className.getName();
            if (classNode instanceof Identifier) {
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)classNode);
            }
            return true;
        }

        public boolean visit(StaticConstantAccess staticConstantAccess) {
            ITypeBinding type = staticConstantAccess.getClassName().resolveTypeBinding();
            if (type != null && ModelUtils.isDeprecated(type.getPHPElement())) {
                DeprecatedHighlighting.this.highlightStatic((StaticDispatch)staticConstantAccess);
            }
            String fieldName = staticConstantAccess.getConstant().getName();
            if (type != null && fieldName != null) {
                IVariableBinding[] fields;
                IVariableBinding[] iVariableBindingArray = fields = type.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariableBinding field = iVariableBindingArray[n2];
                    if (field.getName().equalsIgnoreCase(fieldName)) {
                        if (!ModelUtils.isDeprecated(field.getPHPElement())) break;
                        DeprecatedHighlighting.this.highlight((ASTNode)staticConstantAccess.getConstant());
                        break;
                    }
                    ++n2;
                }
            }
            return super.visit(staticConstantAccess);
        }

        public boolean visit(TraitUseStatement node) {
            List traitList = node.getTraitList();
            for (NamespaceName namespaceName : traitList) {
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)namespaceName, true);
            }
            List tsList = node.getTsList();
            for (TraitStatement traitStatement : tsList) {
                FullyQualifiedTraitMethodReference reference;
                TraitAliasStatement statement;
                if (traitStatement instanceof TraitAliasStatement) {
                    statement = (TraitAliasStatement)traitStatement;
                    if (!(statement.getAlias().getTraitMethod() instanceof FullyQualifiedTraitMethodReference)) continue;
                    reference = (FullyQualifiedTraitMethodReference)statement.getAlias().getTraitMethod();
                    DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)reference.getClassName(), true);
                    continue;
                }
                if (!(traitStatement instanceof TraitPrecedenceStatement)) continue;
                statement = (TraitPrecedenceStatement)traitStatement;
                reference = statement.getPrecedence().getMethodReference();
                DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)reference.getClassName(), true);
                traitList = statement.getPrecedence().getTrList();
                for (NamespaceName namespaceName : traitList) {
                    DeprecatedHighlighting.this.highlightWhenIdentifierIsDeprecated((Identifier)namespaceName, true);
                }
            }
            return false;
        }

        public boolean visit(CatchClause catchStatement) {
            catchStatement.getClassNames().stream().forEach(e -> {
                ITypeBinding type = e.resolveTypeBinding();
                if (type != null && ModelUtils.isDeprecated(type.getPHPElement())) {
                    DeprecatedHighlighting.this.highlightIdentifier((ASTNode)e);
                }
            });
            return true;
        }

        public boolean visit(StaticFieldAccess staticFieldAccess) {
            ITypeBinding type = staticFieldAccess.getClassName().resolveTypeBinding();
            if (type != null && ModelUtils.isDeprecated(type.getPHPElement())) {
                DeprecatedHighlighting.this.highlightStatic((StaticDispatch)staticFieldAccess);
            }
            String fieldName = null;
            if (staticFieldAccess.getField().getName() instanceof Identifier) {
                fieldName = ((Identifier)staticFieldAccess.getField().getName()).getName();
            }
            if (type != null && fieldName != null) {
                IVariableBinding[] fields;
                IVariableBinding[] iVariableBindingArray = fields = type.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariableBinding field = iVariableBindingArray[n2];
                    if (field.getName().substring(1).equalsIgnoreCase(fieldName) && ModelUtils.isDeprecated(field.getPHPElement())) {
                        DeprecatedHighlighting.this.highlight((ASTNode)staticFieldAccess.getField());
                    }
                    ++n2;
                }
            }
            return super.visit(staticFieldAccess);
        }

        public boolean visit(FieldAccess fieldAccess) {
            IField field = ModelUtils.getField(fieldAccess);
            if (field != null && ModelUtils.isDeprecated((IModelElement)field)) {
                DeprecatedHighlighting.this.highlight((ASTNode)fieldAccess.getMember());
            } else if (field != null && field.getParent() instanceof IType && ModelUtils.isDeprecated(field.getParent())) {
                DeprecatedHighlighting.this.highlight((ASTNode)fieldAccess.getMember());
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInv) {
            IMethod method = ModelUtils.getMethod(methodInv);
            if (method != null && ModelUtils.isDeprecated((IModelElement)method)) {
                DeprecatedHighlighting.this.highlight((ASTNode)methodInv.getMethod().getFunctionName());
            } else if (method != null && method.getParent() instanceof IType && ModelUtils.isDeprecated(method.getParent())) {
                DeprecatedHighlighting.this.highlight((ASTNode)methodInv.getMethod().getFunctionName());
            }
            return true;
        }

        public boolean visit(FunctionInvocation funcInv) {
            block4: {
                Collection functions;
                String functionName;
                IModelAccessCache cache;
                block3: {
                    IMethod method;
                    if (!(funcInv.getParent() instanceof StaticMethodInvocation)) break block3;
                    StaticMethodInvocation methodInvocation = (StaticMethodInvocation)funcInv.getParent();
                    ITypeBinding type = methodInvocation.getClassName().resolveTypeBinding();
                    if (type != null && ModelUtils.isDeprecated(type.getPHPElement())) {
                        DeprecatedHighlighting.this.highlightStatic((StaticDispatch)methodInvocation);
                    }
                    if ((method = ModelUtils.getMethod(methodInvocation)) == null || !ModelUtils.isDeprecated((IModelElement)method)) break block4;
                    DeprecatedHighlighting.this.highlight((ASTNode)methodInvocation.getMethod().getFunctionName());
                    break block4;
                }
                if (!(funcInv.getParent() instanceof MethodInvocation) && (cache = funcInv.getAST().getBindingResolver().getModelAccessCache()) != null && (functionName = ModelUtils.getFunctionName(funcInv.getFunctionName())) != null && (functions = cache.getGlobalFunctions(DeprecatedHighlighting.this.getSourceModule(), functionName, null)) != null) {
                    for (IMethod function : functions) {
                        if (!ModelUtils.isDeprecated((IModelElement)function)) continue;
                        DeprecatedHighlighting.this.highlight((ASTNode)funcInv.getFunctionName());
                        break;
                    }
                }
            }
            return true;
        }
    }
}

