/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ui.ListContentProvider;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class SaveFilesDialog
extends ListDialog {
    public SaveFilesDialog(Shell parent) {
        super(parent);
        this.setTitle(ValidationUIMessages.SaveFilesDialog_save_all_resources);
        this.setAddCancelButton(true);
        this.setLabelProvider(this.createDialogLabelProvider());
        this.setMessage(ValidationUIMessages.SaveFilesDialog_must_save);
        this.setContentProvider(new ListContentProvider());
    }

    protected Control createDialogArea(Composite container) {
        Composite result = (Composite)super.createDialogArea(container);
        boolean fAllowSaveAlways = true;
        if (fAllowSaveAlways) {
            final Button check = new Button(result, 32);
            check.setText(ValidationUIMessages.SaveFilesDialog_always_save);
            check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        GlobalConfiguration config = ConfigurationManager.getManager().getGlobalConfiguration();
                        config.setSaveAutomatically(check.getSelection());
                        config.store();
                    }
                    catch (InvocationTargetException exc) {
                        Logger.getLogger(ValidationUIPlugin.getBundleName()).log(Level.WARNING, ValidationUIMessages.UnableToSave + String.valueOf(exc));
                    }
                }
            });
            SaveFilesDialog.applyDialogFont((Control)result);
        }
        return result;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

