/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.net.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.p2.internal.ui.Messages;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class CacheUsageConfirmerUI
extends CacheUsageConfirmer {
    private Boolean cacheUsageConfirmed;

    public boolean confirmCacheUsage(final URI uri, File file) {
        if (this.cacheUsageConfirmed == null) {
            Shell shell;
            this.cacheUsageConfirmed = Boolean.FALSE;
            final long lastModified = file.lastModified();
            if (lastModified != 0L && (shell = this.getShell()) != null) {
                UIUtil.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        long minutes;
                        long hours;
                        long age = System.currentTimeMillis() - lastModified;
                        long days = age / 86400000L;
                        String message = days > 0L ? NLS.bind((String)Messages.CacheUsageConfirmerUI_cacheAge_days, (Object)days) : ((hours = age / 3600000L) > 0L ? NLS.bind((String)Messages.CacheUsageConfirmerUI_cacheAge_hours, (Object)hours) : ((minutes = age / 60000L) > 0L ? NLS.bind((String)Messages.CacheUsageConfirmerUI_cacheAge_minutes, (Object)minutes) : Messages.CacheUsageConfirmerUI_cacheAge_fewSeconds));
                        CacheUsageConfirmerUI.this.cacheUsageConfirmed = MessageDialog.openQuestion((Shell)shell, (String)Messages.CacheUsageConfirmerUI_downloadFailure, (String)(Messages.CacheUsageConfirmerUI_uriCouldNotBeDownloaded + "\n\n" + String.valueOf(uri) + "\n\n" + NLS.bind((String)Messages.CacheUsageConfirmerUI_cacheAge_useCachedVersionsSuggestion, (Object)message)));
                    }
                });
            }
        }
        return this.cacheUsageConfirmed;
    }

    public void reset() {
        this.cacheUsageConfirmed = null;
    }

    protected Shell getShell() {
        try {
            return UIUtil.getShell();
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

