/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.core.resources.IProject;

public final class InfoContext {
    private IProject fProject;
    private String fInstanceId;
    private ILanguage fLanguage;

    public InfoContext(IProject project) {
        this(project, null);
    }

    public InfoContext(IProject project, String instanceId) {
        this.fProject = project;
        this.fInstanceId = instanceId != null ? instanceId : "";
    }

    public InfoContext(IProject project, String instanceId, ILanguage language) {
        this.fProject = project;
        this.fInstanceId = instanceId != null ? instanceId : "";
        this.fLanguage = language;
    }

    public String getInstanceId() {
        return this.fInstanceId;
    }

    public ILanguage getLanguage() {
        return this.fLanguage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InfoContext)) {
            return false;
        }
        InfoContext other = (InfoContext)obj;
        if (this.fProject == null ? other.fProject != null : !this.fProject.equals((Object)other.fProject)) {
            return false;
        }
        return this.fInstanceId.equals(other.fInstanceId);
    }

    public int hashCode() {
        int code = this.fProject != null ? this.fProject.hashCode() : 0;
        return code += this.fInstanceId.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.fProject != null) {
            buf.append(this.fProject.toString());
        } else {
            buf.append("no project");
        }
        if (this.fInstanceId.length() != 0) {
            buf.append(" , instance: ");
            buf.append(this.fInstanceId);
        }
        return buf.toString();
    }

    public boolean isDefaultContext() {
        return this.fInstanceId.length() == 0;
    }

    public IProject getProject() {
        return this.fProject;
    }
}

