/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.core.SeriesMapper;

public class SeriesEditingSupport
extends EditingSupport {
    private SeriesListUI seriesListUI;
    private int columnIndex = 0;

    public SeriesEditingSupport(SeriesListUI seriesListUI, int columnIndex) {
        super((ColumnViewer)seriesListUI);
        this.columnIndex = columnIndex;
        this.seriesListUI = seriesListUI;
    }

    protected boolean canEdit(Object element) {
        return switch (this.columnIndex) {
            case 2 -> true;
            case 3 -> true;
            case 4 -> true;
            case 5 -> true;
            case 1 -> true;
            default -> false;
        };
    }

    protected CellEditor getCellEditor(Object element) {
        return switch (this.columnIndex) {
            case 2 -> new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
            case 3 -> new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
            case 4 -> new ColorCellEditor((Composite)this.seriesListUI.getTable());
            case 5 -> new TextCellEditor((Composite)this.seriesListUI.getTable());
            case 1 -> new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
            default -> null;
        };
    }

    protected Object getValue(Object element) {
        Object object = null;
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            BaseChart baseChart = this.seriesListUI.getBaseChart();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
            switch (this.columnIndex) {
                case 2: {
                    object = seriesSettings.isVisible();
                    break;
                }
                case 3: {
                    object = seriesSettings.isVisibleInLegend();
                    break;
                }
                case 4: {
                    Color color = SeriesLabelProvider.getColor(seriesSettings);
                    object = color != null ? color.getRGB() : null;
                    break;
                }
                case 5: {
                    object = seriesSettings.getDescription();
                    break;
                }
                case 1: {
                    object = SeriesMapper.get(series, baseChart) != null;
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    protected void setValue(Object element, Object object) {
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            BaseChart baseChart = this.getBaseChart();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
            switch (this.columnIndex) {
                case 2: {
                    seriesSettings.setVisible(Boolean.valueOf(object.toString()));
                    break;
                }
                case 3: {
                    seriesSettings.setVisibleInLegend(Boolean.valueOf(object.toString()));
                    break;
                }
                case 4: {
                    if (!(object instanceof RGB)) break;
                    RGB rgbNew = (RGB)object;
                    Color color = ResourceSupport.getColor((RGB)rgbNew);
                    SeriesLabelProvider.setColor(seriesSettings, color);
                    break;
                }
                case 5: {
                    seriesSettings.setDescription(object.toString());
                    break;
                }
                case 1: {
                    boolean map = Boolean.valueOf(object.toString());
                    if (map) {
                        SeriesMapper.map(series, baseChart);
                        break;
                    }
                    SeriesMapper.unmap(series, baseChart);
                }
            }
            baseChart.applySeriesSettings(series, seriesSettings, true);
            this.refresh();
        }
    }

    private BaseChart getBaseChart() {
        return this.seriesListUI.getBaseChart();
    }

    private void refresh() {
        this.getBaseChart().redraw();
        this.seriesListUI.refresh();
    }
}

