/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.IResumeAtAddress;
import org.eclipse.cdt.debug.internal.ui.actions.IResumeAtLineTarget;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblySelection;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class DisassemblyResumeAtLineAdapter
implements IResumeAtLineTarget {
    public void resumeAtLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        if (part instanceof IDisassemblyPart && selection instanceof ITextSelection) {
            IResumeAtAddress resumeAtAddress;
            IDisassemblySelection disassemblySelection;
            IAddress address;
            if (!(selection instanceof IDisassemblySelection)) {
                selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
            }
            if ((address = (disassemblySelection = (IDisassemblySelection)selection).getStartAddress()) != null && target instanceof IAdaptable && (resumeAtAddress = (IResumeAtAddress)((IAdaptable)target).getAdapter(IResumeAtAddress.class)) != null && resumeAtAddress.canResumeAtAddress(address)) {
                try {
                    resumeAtAddress.resumeAtAddress(address);
                }
                catch (DebugException e) {
                    this.failed(e);
                }
            }
        }
    }

    public boolean canResumeAtLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IDisassemblyPart && selection instanceof ITextSelection) {
            IDisassemblySelection disassemblySelection;
            IAddress address;
            IResumeAtAddress resumeAtAddress = (IResumeAtAddress)((IAdaptable)target).getAdapter(IResumeAtAddress.class);
            if (resumeAtAddress == null) {
                return false;
            }
            if (!(selection instanceof IDisassemblySelection)) {
                selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
            }
            if ((address = (disassemblySelection = (IDisassemblySelection)selection).getStartAddress()) == null) {
                return false;
            }
            return resumeAtAddress.canResumeAtAddress(address);
        }
        return false;
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10004, "Resume At Line failed", null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10004, e.getMessage(), e));
        DsfUIPlugin.log((IStatus)ms);
    }
}

