/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.Map;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.core.runtime.IStatus;

public class ExecutionContextLabelText
extends LabelText {
    public static final String PROP_STATE_CHANGE_REASON_KNOWN = "state_change_reason_known";
    public static final String PROP_STATE_CHANGE_DETAILS_KNOWN = "state_change_details_known";
    public static final String PROP_ID_KNOWN = "id_known";
    public static final String PROP_NAME_KNOWN = "name_known";

    public ExecutionContextLabelText(String formatPattern, String[] propertyNames) {
        super(formatPattern, propertyNames);
    }

    @Override
    protected Object getPropertyValue(String propertyName, IStatus status, Map<String, Object> properties) {
        if ("state_change_reason".equals(propertyName)) {
            String reason = (String)properties.get("state_change_reason");
            String reasonLabel = "invalid reason";
            if (reason == null) {
                reasonLabel = "";
            } else if (IRunControl.StateChangeReason.BREAKPOINT.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Breakpoint__label;
            } else if (IRunControl.StateChangeReason.CONTAINER.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Container__label;
            } else if (IRunControl.StateChangeReason.ERROR.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Error__label;
            } else if (IRunControl.StateChangeReason.EVALUATION.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Evaluation__label;
            } else if (IRunControl.StateChangeReason.EXCEPTION.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Exception__label;
            } else if (IRunControl.StateChangeReason.SHAREDLIB.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Shared_lib__label;
            } else if (IRunControl.StateChangeReason.SIGNAL.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Signal__label;
            } else if (IRunControl.StateChangeReason.STEP.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Step__label;
            } else if (IRunControl.StateChangeReason.USER_REQUEST.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__User_request__label;
            } else if (IRunControl.StateChangeReason.WATCHPOINT.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Watchpoint__label;
            } else if (IRunControl.StateChangeReason.EVENT_BREAKPOINT.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__EventBreakpoint__label;
            } else if (IRunControl.StateChangeReason.UNKNOWN.name().equals(reason)) {
                reasonLabel = MessagesForLaunchVM.State_change_reason__Unknown__label;
            } else assert (false) : "unexpected state change reason: " + reason;
            return reasonLabel;
        }
        if ("state_change_details".equals(propertyName)) {
            return properties.get(propertyName);
        }
        if ("is_suspended".equals(propertyName)) {
            Boolean suspended = (Boolean)properties.get(propertyName);
            return suspended != false ? 1 : 0;
        }
        if (PROP_STATE_CHANGE_REASON_KNOWN.equals(propertyName)) {
            String reason = (String)properties.get("state_change_reason");
            return reason != null && !IRunControl.StateChangeReason.UNKNOWN.name().equals(reason) ? 1 : 0;
        }
        if (PROP_STATE_CHANGE_DETAILS_KNOWN.equals(propertyName)) {
            String details = (String)properties.get("state_change_details");
            return details != null ? 1 : 0;
        }
        if (PROP_NAME_KNOWN.equals(propertyName)) {
            return properties.get("name") != null ? 1 : 0;
        }
        if ("name".equals(propertyName)) {
            Object val = properties.get("name");
            return val != null ? val : "";
        }
        if (PROP_ID_KNOWN.equals(propertyName)) {
            return properties.get("id") != null ? 1 : 0;
        }
        if ("id".equals(propertyName)) {
            Object val = properties.get("id");
            return val != null ? val : "";
        }
        return super.getPropertyValue(propertyName, status, properties);
    }

    @Override
    protected boolean checkProperty(String propertyName, IStatus status, Map<String, Object> properties) {
        if (PROP_NAME_KNOWN.equals(propertyName) || "name".equals(propertyName) || PROP_STATE_CHANGE_REASON_KNOWN.equals(propertyName) || "state_change_reason".equals(propertyName) || PROP_STATE_CHANGE_DETAILS_KNOWN.equals(propertyName) || "state_change_details".equals(propertyName) || PROP_ID_KNOWN.equals(propertyName) || "id".equals(propertyName)) {
            return true;
        }
        return super.checkProperty(propertyName, status, properties);
    }
}

