/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.Optional;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStructuredBindingDeclaration;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.parser.util.ArrayUtil;

public abstract class VariableReadWriteFlags {
    protected static final int READ = 32;
    protected static final int WRITE = 64;

    public static boolean mayBeWriteAccess(Optional<Integer> flags) {
        return !flags.isPresent() || (flags.get() & 0x40) != 0;
    }

    protected Optional<Integer> rwAnyNode(IASTNode node, int indirection) {
        IASTNode parent = node.getParent();
        if (parent instanceof IASTExpression) {
            return this.rwInExpression((IASTExpression)parent, node, indirection);
        }
        if (parent instanceof IASTStatement) {
            return this.rwInStatement((IASTStatement)parent, node, indirection);
        }
        if (parent instanceof IASTDeclarator) {
            return this.rwInDeclarator((IASTDeclarator)parent, indirection);
        }
        if (parent instanceof IASTEqualsInitializer) {
            return this.rwInEqualsInitializer((IASTEqualsInitializer)parent, indirection);
        }
        if (parent instanceof IASTArrayModifier) {
            return Optional.of(32);
        }
        if (parent instanceof IASTInitializerList) {
            return this.rwInInitializerList((IASTInitializerList)parent, indirection);
        }
        if (parent instanceof IASTDeclSpecifier) {
            return Optional.of(32);
        }
        return Optional.empty();
    }

    protected Optional<Integer> rwInDeclarator(IASTDeclarator parent, int indirection) {
        if (parent.getInitializer() != null) {
            return Optional.of(64);
        }
        return Optional.of(0);
    }

    protected Optional<Integer> rwInEqualsInitializer(IASTEqualsInitializer parent, int indirection) {
        IASTNode grand = parent.getParent();
        if (grand instanceof IASTDeclarator) {
            IBinding binding = ((IASTDeclarator)grand).getName().getBinding();
            if (binding instanceof IVariable) {
                return this.rwAssignmentToType(((IVariable)binding).getType(), indirection);
            }
        } else if (grand instanceof ICPPASTStructuredBindingDeclaration) {
            return this.rwInStructuredBinding((ICPPASTStructuredBindingDeclaration)grand);
        }
        return Optional.empty();
    }

    protected Optional<Integer> rwInInitializerList(IASTInitializerList parent, int indirection) {
        IASTNode grand = parent.getParent();
        if (grand instanceof IASTEqualsInitializer) {
            IType type;
            IBinding binding;
            IASTNode grandGrand = grand.getParent();
            if (grandGrand instanceof IASTDeclarator && (binding = ((IASTDeclarator)grandGrand).getName().resolveBinding()) instanceof IVariable && (type = ((IVariable)binding).getType()) instanceof IArrayType) {
                return this.rwAssignmentToType(type, indirection);
            }
        } else if (grand instanceof ICPPASTStructuredBindingDeclaration) {
            return this.rwInStructuredBinding((ICPPASTStructuredBindingDeclaration)grand);
        }
        return Optional.empty();
    }

    protected Optional<Integer> rwInStructuredBinding(ICPPASTStructuredBindingDeclaration declaration) {
        ICPPASTFunctionDeclarator.RefQualifier refQualifier = declaration.getRefQualifier();
        if (refQualifier != null && !declaration.getDeclSpecifier().isConst()) {
            return Optional.of(96);
        }
        return Optional.of(32);
    }

    private boolean isAssignment(IASTBinaryExpression node) {
        switch (node.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    protected Optional<Integer> rwInExpression(IASTExpression expr, IASTNode node, int indirection) {
        if (expr instanceof IASTIdExpression) {
            return this.rwAnyNode(expr, indirection);
        }
        if (expr instanceof IASTBinaryExpression) {
            return this.rwInBinaryExpression(node, (IASTBinaryExpression)expr, indirection);
        }
        if (expr instanceof IASTFieldReference) {
            return this.rwInFieldReference(node, (IASTFieldReference)expr, indirection);
        }
        if (expr instanceof IASTCastExpression) {
            return this.rwAnyNode(expr, indirection);
        }
        if (expr instanceof IASTUnaryExpression) {
            return this.rwInUnaryExpression(node, (IASTUnaryExpression)expr, indirection);
        }
        if (expr instanceof IASTArraySubscriptExpression) {
            if (indirection > 0 && node.getPropertyInParent() == IASTArraySubscriptExpression.ARRAY) {
                return this.rwAnyNode(expr, indirection - 1);
            }
            if (expr.getParent() instanceof IASTBinaryExpression && expr.getPropertyInParent() == IASTBinaryExpression.OPERAND_ONE && this.isAssignment((IASTBinaryExpression)expr.getParent())) {
                return Optional.of(96);
            }
            return Optional.of(32);
        }
        if (expr instanceof IASTConditionalExpression) {
            if (node.getPropertyInParent() == IASTConditionalExpression.LOGICAL_CONDITION) {
                return Optional.of(32);
            }
            return this.rwAnyNode(expr, indirection);
        }
        if (expr instanceof IASTExpressionList) {
            IASTExpression[] expressions = ((IASTExpressionList)expr).getExpressions();
            if (expressions.length > 0 && expressions[0] == node) {
                return this.rwAnyNode(expr, indirection);
            }
            return Optional.of(0);
        }
        if (expr instanceof IASTFunctionCallExpression) {
            if (node.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                return this.rwInFunctionName((IASTExpression)node);
            }
            return this.rwArgumentForFunctionCall((IASTFunctionCallExpression)expr, node, indirection);
        }
        if (expr instanceof IASTProblemExpression) {
            return Optional.of(96);
        }
        if (expr instanceof IASTTypeIdExpression) {
            return Optional.of(0);
        }
        return Optional.empty();
    }

    protected Optional<Integer> rwInFieldReference(IASTNode node, IASTFieldReference expr, int indirection) {
        if (node.getPropertyInParent() == IASTFieldReference.FIELD_NAME) {
            if (expr.getPropertyInParent() != IASTFunctionCallExpression.FUNCTION_NAME) {
                return this.rwAnyNode(expr, indirection);
            }
        } else {
            if (expr.isPointerDereference()) {
                --indirection;
            }
            if (indirection >= 0) {
                return this.rwAnyNode(expr, indirection);
            }
        }
        return Optional.of(32);
    }

    protected Optional<Integer> rwInFunctionName(IASTExpression node) {
        return Optional.of(32);
    }

    protected Optional<Integer> union(Optional<Integer> a, Optional<Integer> b) {
        if (a.isPresent() && b.isPresent()) {
            return Optional.of(a.get() | b.get());
        }
        return Optional.empty();
    }

    protected Optional<Integer> rwArgumentForFunctionCall(IASTFunctionCallExpression funcCall, IASTNode argument, int indirection) {
        IASTImplicitName name;
        IBinding binding;
        IASTImplicitName[] implicitNames;
        IASTInitializerClause[] args = funcCall.getArguments();
        int index = ArrayUtil.indexOf(args, argument);
        if (index == -1) {
            return Optional.empty();
        }
        IASTExpression functionNameExpression = funcCall.getFunctionNameExpression();
        if (functionNameExpression == null) {
            return Optional.empty();
        }
        IType type = functionNameExpression.getExpressionType();
        IFunctionType functionType = null;
        if (type instanceof IFunctionType) {
            functionType = (IFunctionType)type;
        } else if (funcCall instanceof IASTImplicitNameOwner && (implicitNames = ((IASTImplicitNameOwner)((Object)funcCall)).getImplicitNames()).length == 1 && (binding = (name = implicitNames[0]).resolveBinding()) instanceof IFunction) {
            functionType = ((IFunction)binding).getType();
        }
        if (functionType == null) {
            return Optional.empty();
        }
        return this.rwArgumentForFunctionCall(functionType, index, args[index], indirection);
    }

    private IType getArgumentType(IASTInitializerClause argument) {
        if (argument instanceof ICPPASTInitializerClause) {
            return ((ICPPASTInitializerClause)argument).getEvaluation().getType();
        }
        if (argument instanceof IASTExpression) {
            return ((IASTExpression)argument).getExpressionType();
        }
        return null;
    }

    protected Optional<Integer> rwArgumentForFunctionCall(IFunctionType type, int parameterIdx, IASTInitializerClause argument, int indirection) {
        IType[] ptypes = type.getParameterTypes();
        IType parameterType = null;
        if (ptypes != null && ptypes.length > parameterIdx) {
            parameterType = ptypes[parameterIdx];
        } else if (type.takesVarArgs()) {
            parameterType = this.getArgumentType(argument);
        }
        if (parameterType != null) {
            return this.rwAssignmentToType(parameterType, indirection);
        }
        return Optional.empty();
    }

    protected abstract Optional<Integer> rwAssignmentToType(IType var1, int var2);

    protected Optional<Integer> rwInStatement(IASTStatement stmt, IASTNode node, int indirection) {
        if (stmt instanceof IASTCaseStatement) {
            if (node.getPropertyInParent() == IASTCaseStatement.EXPRESSION) {
                return Optional.of(32);
            }
        } else if (stmt instanceof IASTDoStatement) {
            if (node.getPropertyInParent() == IASTDoStatement.CONDITION) {
                return Optional.of(32);
            }
        } else if (stmt instanceof IASTExpressionStatement) {
            IASTNode parent = stmt.getParent();
            while (parent instanceof IASTCompoundStatement) {
                IASTCompoundStatement compound = (IASTCompoundStatement)parent;
                IASTStatement[] statements = compound.getStatements();
                if (statements[statements.length - 1] != stmt) {
                    return Optional.of(0);
                }
                stmt = compound;
                parent = stmt.getParent();
            }
            if (parent instanceof IGNUASTCompoundStatementExpression) {
                return this.rwAnyNode(parent, indirection);
            }
        } else if (stmt instanceof IASTForStatement) {
            if (node.getPropertyInParent() == IASTForStatement.CONDITION) {
                return Optional.of(32);
            }
        } else if (stmt instanceof ICPPASTRangeBasedForStatement) {
            if (node.getPropertyInParent() == ICPPASTRangeBasedForStatement.INITIALIZER) {
                return Optional.of(32);
            }
        } else if (stmt instanceof IASTIfStatement) {
            if (node.getPropertyInParent() == IASTIfStatement.CONDITION) {
                return Optional.of(32);
            }
        } else {
            if (stmt instanceof IASTProblemStatement) {
                return Optional.empty();
            }
            if (stmt instanceof IASTReturnStatement) {
                return indirection == 0 ? Optional.of(32) : Optional.of(64);
            }
            if (stmt instanceof IASTSwitchStatement ? node.getPropertyInParent() == IASTSwitchStatement.CONTROLLER_EXP : stmt instanceof IASTWhileStatement && node.getPropertyInParent() == IASTWhileStatement.CONDITIONEXPRESSION) {
                return Optional.of(32);
            }
        }
        return Optional.of(0);
    }

    protected Optional<Integer> rwInUnaryExpression(IASTNode node, IASTUnaryExpression expr, int indirection) {
        switch (expr.getOperator()) {
            case 11: {
                return this.rwAnyNode(expr, indirection);
            }
            case 5: {
                return this.rwAnyNode(expr, indirection + 1);
            }
            case 4: {
                if (indirection > 0) {
                    return this.rwAnyNode(expr, indirection - 1);
                }
                return Optional.of(32);
            }
            case 0: 
            case 1: 
            case 9: 
            case 10: {
                return Optional.of(96);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return Optional.of(32);
            }
            case 8: 
            case 15: 
            case 16: {
                return Optional.of(0);
            }
        }
        return Optional.of(32);
    }

    protected Optional<Integer> rwInBinaryExpression(IASTNode node, IASTBinaryExpression expr, int indirection) {
        switch (expr.getOperator()) {
            case 17: {
                if (node.getPropertyInParent() == IASTBinaryExpression.OPERAND_ONE) {
                    return Optional.of(64);
                }
                return this.rwAssignmentToType(expr.getOperand1().getExpressionType(), indirection);
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (node.getPropertyInParent() == IASTBinaryExpression.OPERAND_ONE) {
                    return Optional.of(96);
                }
                return Optional.of(32);
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 28: 
            case 29: 
            case 35: {
                return Optional.of(32);
            }
            case 4: 
            case 5: {
                if (indirection > 0) {
                    return this.rwAnyNode(expr, indirection);
                }
                return Optional.of(32);
            }
        }
        return Optional.of(32);
    }
}

