/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUnary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;

public class TemplateArgumentDeduction {
    private final CPPTemplateParameterMap fExplicitArgs;
    private CPPTemplateParameterMap fDeducedArgs;
    private Set<Integer> fTemplateParameterPacks;
    private int fPackOffset;
    private final int fPackSize;

    static ICPPTemplateArgument[] deduceForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argIsLValue, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        if (tmplArgs != null && !TemplateArgumentDeduction.addExplicitArguments(template, tmplParams, tmplArgs, map)) {
            return null;
        }
        if (!TemplateArgumentDeduction.deduceFromFunctionArgs(template, fnArgs, argIsLValue, map)) {
            return null;
        }
        return TemplateArgumentDeduction.createArguments(map, tmplParams);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static boolean deduceFromFunctionArgs(ICPPFunctionTemplate template, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, CPPTemplateParameterMap map) {
        try {
            IType[] fnPars = template.getType().getParameterTypes();
            int fnParCount = fnPars.length;
            ICPPTemplateParameter[] tmplPars = template.getTemplateParameters();
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, map, new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            int j = 0;
            while (j < fnArgs.size()) {
                block32: {
                    IType par;
                    block34: {
                        block33: {
                            if (fnParPack == null) break block33;
                            par = fnParPack;
                            deduct.incPackOffset();
                            break block34;
                        }
                        if (j >= fnParCount) break;
                        par = fnPars[j];
                        if (!(par instanceof ICPPParameterPackType)) break block34;
                        if (j != fnParCount - 1) break block32;
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.size() - j);
                    }
                    par = CPPTemplates.instantiateType(par, InstantiationContext.forDeduction(map));
                    if (!SemanticUtil.isValidType(par)) {
                        return false;
                    }
                    if (CPPTemplates.isDependentType(par)) {
                        IType arg = fnArgs.get(j);
                        par = SemanticUtil.getNestedType(par, 1);
                        if (arg instanceof InitializerListType) {
                            par = SemanticUtil.getNestedType(par, 13);
                            IType inner = null;
                            if (par instanceof IArrayType) {
                                inner = ((IArrayType)par).getType();
                                IntegralValue as = IntegralValue.create(((InitializerListType)arg).getEvaluation().getClauses().length);
                                IValue ps = ((IArrayType)par).getSize();
                                if (!deduct.fromArraySize(ps, as)) {
                                    return false;
                                }
                            } else {
                                inner = Conversions.getInitListType(par);
                            }
                            if (inner != null) {
                                EvalInitList eval = ((InitializerListType)arg).getEvaluation();
                                ICPPEvaluation[] iCPPEvaluationArray = eval.getClauses();
                                int n = iCPPEvaluationArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ICPPEvaluation clause = iCPPEvaluationArray[n2];
                                    if (!TemplateArgumentDeduction.deduceFromFunctionArg(inner, clause.getType(), clause.getValueCategory(), deduct)) {
                                        return false;
                                    }
                                    ++n2;
                                }
                            }
                        } else if (arg instanceof FunctionSetType) {
                            ICPPFunction[] fs;
                            ICPPFunction[] iCPPFunctionArray = fs = ((FunctionSetType)arg).getFunctionSet().getBindings();
                            int n = fs.length;
                            int clause = 0;
                            while (clause < n) {
                                ICPPFunction f = iCPPFunctionArray[clause];
                                if (!(f instanceof ICPPFunctionTemplate)) {
                                    ++clause;
                                    continue;
                                }
                                break block32;
                            }
                            CPPTemplateParameterMap success = null;
                            HashSet<String> handled = new HashSet<String>();
                            ICPPFunction[] iCPPFunctionArray2 = fs;
                            int n3 = fs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ICPPFunction f = iCPPFunctionArray2[n4];
                                arg = f.getType();
                                if (f instanceof ICPPMethod && !f.isStatic()) {
                                    arg = new CPPPointerToMemberType(arg, ((ICPPMethod)f).getClassOwner(), false, false, false);
                                }
                                if (handled.add(ASTTypeUtil.getType(arg, true))) {
                                    CPPTemplateParameterMap state = deduct.saveState();
                                    if (TemplateArgumentDeduction.deduceFromFunctionArg(par, arg, argCats.get(j), deduct)) {
                                        if (success != null) {
                                            deduct.restoreState(state);
                                            break block32;
                                        }
                                        success = deduct.saveState();
                                    }
                                    deduct.restoreState(state);
                                }
                                ++n4;
                            }
                            if (success == null) {
                                return false;
                            }
                            deduct.restoreState(success);
                        } else if (!TemplateArgumentDeduction.deduceFromFunctionArg(par, arg, argCats.get(j), deduct)) {
                            return false;
                        }
                    }
                }
                ++j;
            }
            if (!map.addDeducedArgs(deduct.fDeducedArgs)) {
                return false;
            }
            ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplPars;
            int n = tmplPars.length;
            int n5 = 0;
            while (n5 < n) {
                ICPPTemplateArgument arg;
                ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n5];
                if (tpar instanceof ICPPTemplateNonTypeParameter && (arg = deduct.fDeducedArgs.getArgument(tpar)) != null) {
                    IType type1 = ((ICPPTemplateNonTypeParameter)tpar).getType();
                    type1 = CPPTemplates.instantiateType(type1, new InstantiationContext(map));
                    IType type2 = arg.getTypeOfNonTypeValue();
                    if (type2 instanceof TypeOfValueDeducedFromArraySize && TemplateArgumentDeduction.isIntegralType(type1)) {
                        IValue value = TemplateArgumentDeduction.isBooleanType(type1) ? IntegralValue.create(true) : arg.getNonTypeValue();
                        arg = new CPPTemplateNonTypeArgument(value, type1);
                        deduct.fDeducedArgs.put(tpar, arg);
                    } else if (!type1.isSameType(type2)) {
                        return false;
                    }
                }
                ++n5;
            }
            return TemplateArgumentDeduction.verifyDeduction(tmplPars, map, true);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean isIntegralType(IType type) {
        if (!((type = SemanticUtil.getNestedType(type, 1)) instanceof IBasicType)) {
            return false;
        }
        switch (((IBasicType)type).getKind()) {
            case eChar: 
            case eWChar: 
            case eInt: 
            case eBoolean: 
            case eChar16: 
            case eChar32: 
            case eInt128: 
            case eChar8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBooleanType(IType type) {
        return (type = SemanticUtil.getNestedType(type, 1)) instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eBoolean;
    }

    private static boolean deduceFromFunctionArg(IType par, IType arg, IASTExpression.ValueCategory valueCat, TemplateArgumentDeduction deduct) throws DOMException {
        IType pcheck;
        boolean isReferenceTypeParameter = false;
        if (par instanceof ICPPReferenceType) {
            if (SemanticUtil.isVoidType(arg)) {
                return false;
            }
            isReferenceTypeParameter = true;
            ICPPReferenceType refPar = (ICPPReferenceType)par;
            arg = refPar.isRValueReference() && refPar.getType() instanceof ICPPTemplateParameter && valueCat == IASTExpression.ValueCategory.LVALUE ? new CPPReferenceType(SemanticUtil.getSimplifiedType(arg), false) : TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, true);
            par = SemanticUtil.getNestedType(par, 5);
        } else {
            arg = TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, false);
        }
        CVQualifier cvPar = SemanticUtil.getCVQualifier(par);
        CVQualifier cvArg = SemanticUtil.getCVQualifier(arg);
        if ((cvPar == cvArg || isReferenceTypeParameter && cvPar.isAtLeastAsQualifiedAs(cvArg)) && !((pcheck = SemanticUtil.getNestedType(par, 8)) instanceof ICPPTemplateParameter)) {
            ICPPTemplateInstance pInst;
            ICPPClassTemplate pTemplate;
            par = pcheck;
            IType argcheck = arg = SemanticUtil.getNestedType(arg, 8);
            if (par instanceof IPointerType && arg instanceof IPointerType) {
                pcheck = ((IPointerType)par).getType();
                argcheck = ((IPointerType)arg).getType();
                if (pcheck instanceof ICPPTemplateParameter) {
                    pcheck = null;
                } else {
                    cvPar = SemanticUtil.getCVQualifier(pcheck);
                    if (cvPar.isAtLeastAsQualifiedAs(cvArg = SemanticUtil.getCVQualifier(argcheck))) {
                        pcheck = SemanticUtil.getNestedType(pcheck, 8);
                        argcheck = SemanticUtil.getNestedType(argcheck, 8);
                    } else {
                        pcheck = null;
                    }
                }
            }
            while (pcheck instanceof ITypedef) {
                pcheck = ((ITypedef)pcheck).getType();
            }
            if (pcheck instanceof ICPPTemplateInstance && argcheck instanceof ICPPClassType && (pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst = (ICPPTemplateInstance)((Object)pcheck))) != null) {
                ICPPClassType[] aInstances = TemplateArgumentDeduction.findBaseInstances((ICPPClassType)argcheck, pTemplate);
                boolean attempted = false;
                ICPPClassType[] iCPPClassTypeArray = aInstances;
                int n = aInstances.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassType aInst = iCPPClassTypeArray[n2];
                    if (aInst != null && aInst != argcheck) {
                        par = pcheck;
                        arg = aInst;
                        attempted = true;
                        if (deduct.fromType(par, arg, true, false)) {
                            return true;
                        }
                    }
                    ++n2;
                }
                if (attempted) {
                    return false;
                }
            }
        }
        return deduct.fromType(par, arg, true, false);
    }

    static ICPPTemplateArgument[] deduceForAddressOf(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, IFunctionType arg, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        if (!TemplateArgumentDeduction.addExplicitArguments(template, tmplParams, tmplArgs, map)) {
            return null;
        }
        IType par = template.getType();
        InstantiationContext context = InstantiationContext.forDeduction(map);
        if (!SemanticUtil.isValidType(par = CPPTemplates.instantiateType(par, context))) {
            return null;
        }
        boolean isDependentPar = CPPTemplates.isDependentType(par);
        if (isDependentPar) {
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, map, new CPPTemplateParameterMap(tmplParams.length), 0);
            par = SemanticUtil.getNestedType(par, 1);
            if (arg != null && !deduct.fromType(par, arg, false, false)) {
                return null;
            }
            if (!map.addDeducedArgs(deduct.fDeducedArgs)) {
                return null;
            }
        }
        if (!TemplateArgumentDeduction.verifyDeduction(tmplParams, map, true)) {
            return null;
        }
        if (isDependentPar) {
            par = CPPTemplates.instantiateType(par, context);
        }
        if (arg == null || arg.isSameType(par)) {
            return TemplateArgumentDeduction.createArguments(map, tmplParams);
        }
        return null;
    }

    static ICPPTemplateArgument[] deduceForConversion(ICPPFunctionTemplate template, IType conversionType, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int length = tmplParams.length;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[length];
        IType a = SemanticUtil.getSimplifiedType(conversionType);
        IType p = template.getType().getReturnType();
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, null, map, 0);
        if (!deduct.fromType(p = TemplateArgumentDeduction.getArgumentTypeForDeduction(p, a instanceof ICPPReferenceType), a = SemanticUtil.getNestedType(a, 5), true, false)) {
            return null;
        }
        InstantiationContext context = InstantiationContext.forDeduction(map);
        int i = 0;
        while (i < length) {
            if (result[i] == null) {
                ICPPTemplateParameter tpar = tmplParams[i];
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null && !CPPTemplates.isValidArgument(deducedArg = CPPTemplates.instantiateArgument(tpar.getDefaultValue(), context))) {
                    return null;
                }
                result[i] = deducedArg;
            }
            ++i;
        }
        return result;
    }

    static ICPPTemplateArgument[] deduceForDeclaration(ICPPFunctionTemplate template, ICPPTemplateArgument[] args, ICPPFunctionType ftype, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        if (!TemplateArgumentDeduction.addExplicitArguments(template, tmplParams, args, map)) {
            return null;
        }
        IType a = SemanticUtil.getSimplifiedType(ftype);
        InstantiationContext context = InstantiationContext.forDeduction(map);
        IType p = CPPTemplates.instantiateType(template.getType(), context);
        if (!SemanticUtil.isValidType(p)) {
            return null;
        }
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, map, new CPPTemplateParameterMap(tmplParams.length), 0);
        if (!deduct.fromType(p, a, false, false)) {
            return null;
        }
        if (!map.addDeducedArgs(deduct.fDeducedArgs)) {
            return null;
        }
        if (!TemplateArgumentDeduction.verifyDeduction(tmplParams, map, true)) {
            return null;
        }
        IType type = CPPTemplates.instantiateType(p, context);
        if (!ftype.isSameType(type)) {
            return null;
        }
        return TemplateArgumentDeduction.createArguments(map, tmplParams);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int deduceForPartialOrdering(ICPPTemplateParameter[] tmplPars, IType[] fnPars, IType[] fnArgs) {
        try {
            int fnParCount = fnPars.length;
            int fnArgCount = fnArgs.length;
            int result = 0;
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, new CPPTemplateParameterMap(0), new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            HashSet<Integer> usedTemplateParIds = new HashSet<Integer>();
            int j = 0;
            while (true) {
                block12: {
                    IType par;
                    block11: {
                        block10: {
                            if (j >= fnArgCount) {
                                if (!TemplateArgumentDeduction.verifyDeductionForPartialOrdering(tmplPars, usedTemplateParIds, deduct.fDeducedArgs)) return -1;
                                int n = result;
                                return n;
                            }
                            if (fnParPack == null) break block10;
                            par = fnParPack;
                            deduct.incPackOffset();
                            break block11;
                        }
                        if (j >= fnParCount) {
                            return -1;
                        }
                        par = fnPars[j];
                        if (!(par instanceof ICPPParameterPackType)) break block11;
                        if (j != fnParCount - 1) break block12;
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.length - j);
                    }
                    IType arg = fnArgs[j];
                    TemplateArgumentDeduction.addReferencedTemplateParameters(par, usedTemplateParIds);
                    int cmpSpecialized = TemplateArgumentDeduction.deduceForPartialOrdering(par, arg, deduct);
                    if (cmpSpecialized < 0) {
                        return cmpSpecialized;
                    }
                    if (cmpSpecialized > 0) {
                        result = cmpSpecialized;
                    }
                }
                ++j;
            }
        }
        catch (DOMException dOMException) {
            return -1;
        }
    }

    private static void addReferencedTemplateParameters(IType t, Set<Integer> usedTemplateParIds) {
        while (true) {
            int n;
            int n2;
            Object[] objectArray;
            if (t instanceof ICPPTemplateParameter) {
                usedTemplateParIds.add(((ICPPTemplateParameter)((Object)t)).getParameterID());
                return;
            }
            if (t instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)t;
                objectArray = ft.getParameterTypes();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object par = objectArray[n];
                    TemplateArgumentDeduction.addReferencedTemplateParameters((IType)par, usedTemplateParIds);
                    ++n;
                }
                t = ft.getReturnType();
                continue;
            }
            if (t instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType ptmt = (ICPPPointerToMemberType)t;
                TemplateArgumentDeduction.addReferencedTemplateParameters(ptmt.getMemberOfClass(), usedTemplateParIds);
                t = ptmt.getType();
                continue;
            }
            if (t instanceof ICPPTemplateInstance) {
                ICPPTemplateInstance inst = (ICPPTemplateInstance)((Object)t);
                objectArray = inst.getTemplateArguments();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object arg = objectArray[n];
                    if (arg instanceof CPPTemplateTypeArgument) {
                        TemplateArgumentDeduction.addReferencedTemplateParameters(arg.getTypeValue(), usedTemplateParIds);
                    } else {
                        TemplateArgumentDeduction.addReferencedTemplateParameters(arg.getNonTypeValue(), usedTemplateParIds);
                    }
                    ++n;
                }
                if (inst.getTemplateDefinition() instanceof IType) {
                    t = (IType)((Object)inst.getTemplateDefinition());
                    continue;
                }
                return;
            }
            if (t instanceof ICPPUnknownMember) {
                t = ((ICPPUnknownMember)((Object)t)).getOwnerType();
                continue;
            }
            if (!(t instanceof ITypeContainer)) break;
            if (t instanceof IArrayType) {
                TemplateArgumentDeduction.addReferencedTemplateParameters(((IArrayType)t).getSize(), usedTemplateParIds);
            }
            t = ((ITypeContainer)t).getType();
        }
    }

    private static void addReferencedTemplateParameters(IValue v, Set<Integer> usedTemplatePars) {
        IBinding binding;
        if (v != null && v.getEvaluation() instanceof EvalBinding && (binding = ((EvalBinding)v.getEvaluation()).getBinding()) instanceof ICPPTemplateParameter) {
            usedTemplatePars.add(((ICPPTemplateParameter)binding).getParameterID());
        }
    }

    private static boolean verifyDeductionForPartialOrdering(ICPPTemplateParameter[] pars, Set<Integer> usedParIds, CPPTemplateParameterMap tpMap) {
        ICPPTemplateParameter[] iCPPTemplateParameterArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (usedParIds.contains(tpar.getParameterID())) {
                if (tpar.isParameterPack()) {
                    ICPPTemplateArgument[] deducedArgs = tpMap.getPackExpansion(tpar);
                    if (deducedArgs != null) {
                        ICPPTemplateArgument[] iCPPTemplateArgumentArray = deducedArgs;
                        int n3 = deducedArgs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n4];
                            if (arg == null) {
                                return false;
                            }
                            ++n4;
                        }
                    }
                } else if (tpMap.getArgument(tpar) == null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static int deduceForPartialOrdering(IType parOrig, IType argOrig, TemplateArgumentDeduction deduct) throws DOMException {
        IType parNested = SemanticUtil.getNestedType(parOrig, 1);
        IType argNested = SemanticUtil.getNestedType(argOrig, 1);
        boolean isMoreCVQualified = false;
        boolean preferForLValueRef = false;
        if (parNested instanceof ICPPReferenceType && argNested instanceof ICPPReferenceType) {
            preferForLValueRef = TemplateArgumentDeduction.compareRValueRValueTemplateFunctions(parNested, argNested);
            parNested = SemanticUtil.getNestedType(parNested, 5);
            argNested = SemanticUtil.getNestedType(argNested, 5);
            CVQualifier cvp = SemanticUtil.getCVQualifier(parNested);
            CVQualifier cva = SemanticUtil.getCVQualifier(argNested);
            isMoreCVQualified = cva.isMoreQualifiedThan(cvp);
        }
        if (!deduct.fromType(parNested = SemanticUtil.getNestedType(parNested, 21), argNested = SemanticUtil.getNestedType(argNested, 21), false, false)) {
            return -1;
        }
        return isMoreCVQualified || preferForLValueRef ? 1 : 0;
    }

    private static boolean compareRValueRValueTemplateFunctions(IType f1, IType f2) {
        boolean sndRv;
        ICPPReferenceType fstTp = (ICPPReferenceType)f1;
        ICPPReferenceType sndTp = (ICPPReferenceType)f2;
        boolean fstRv = fstTp.isRValueReference();
        if (fstRv != (sndRv = sndTp.isRValueReference())) {
            return fstRv;
        }
        return false;
    }

    private static boolean isReferenceType(IType fstSpecP) {
        return ICPPReferenceType.class.isAssignableFrom(fstSpecP.getClass());
    }

    public static boolean addExplicitArguments(ICPPFunctionTemplate template, ICPPTemplateParameter[] tmplParams, ICPPTemplateArgument[] tmplArgs, CPPTemplateParameterMap map) {
        tmplArgs = SemanticUtil.getSimplifiedArguments(tmplArgs);
        ICPPTemplateParameter tmplParam = null;
        int packOffset = -1;
        int i = 0;
        while (i < tmplArgs.length) {
            if (packOffset < 0 || tmplParam == null) {
                if (i >= tmplParams.length) {
                    return false;
                }
                tmplParam = tmplParams[i];
                if (tmplParam.isParameterPack()) {
                    packOffset = i;
                }
            }
            ICPPTemplateArgument tmplArg = tmplArgs[i];
            if ((tmplArg = CPPTemplates.matchTemplateParameterAndArgument(template, tmplParam, tmplArg, map)) == null) {
                return false;
            }
            if (packOffset < 0) {
                map.put(tmplParam, tmplArg);
            }
            ++i;
        }
        if (packOffset >= 0) {
            int packSize = tmplArgs.length - packOffset;
            ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
            System.arraycopy(tmplArgs, packOffset, pack, 0, packSize);
            map.put(tmplParam, pack);
        }
        return true;
    }

    private static ICPPTemplateArgument[] createArguments(CPPTemplateParameterMap map, ICPPTemplateParameter[] tmplParams) {
        ArrayList<ICPPTemplateArgument> result = new ArrayList<ICPPTemplateArgument>(tmplParams.length);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplParams;
        int n = tmplParams.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = map.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    return null;
                }
                result.addAll(Arrays.asList(deducedArgs));
            } else {
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null) {
                    return null;
                }
                result.add(deducedArg);
            }
            ++n2;
        }
        return result.toArray(new ICPPTemplateArgument[result.size()]);
    }

    private static ICPPClassType[] findBaseInstances(ICPPClassType a, ICPPClassTemplate pTemplate) throws DOMException {
        return TemplateArgumentDeduction.findBaseInstances(a, pTemplate, 40, new HashSet<Object>());
    }

    private static ICPPClassType[] findBaseInstances(ICPPClassType a, ICPPClassTemplate pTemplate, int maxdepth, HashSet<Object> handled) throws DOMException {
        ICPPTemplateInstance inst;
        ICPPClassTemplate tmpl;
        if (a instanceof ICPPTemplateInstance && pTemplate.isSameType(tmpl = TemplateArgumentDeduction.getPrimaryTemplate(inst = (ICPPTemplateInstance)((Object)a)))) {
            return new ICPPClassType[]{a};
        }
        ICPPClassType[] results = ICPPClassType.EMPTY_CLASS_ARRAY;
        if (maxdepth-- > 0) {
            ICPPBase[] iCPPBaseArray = a.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof ICPPClassType && handled.add(base)) {
                    Object[] inst2 = TemplateArgumentDeduction.findBaseInstances((ICPPClassType)base, pTemplate, maxdepth, handled);
                    results = ArrayUtil.addAll(results, inst2);
                }
                ++n2;
            }
        }
        return ArrayUtil.trim(results);
    }

    private static ICPPClassTemplate getPrimaryTemplate(ICPPTemplateInstance inst) throws DOMException {
        ICPPTemplateDefinition template = inst.getTemplateDefinition();
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPClassTemplatePartialSpecialization)template).getPrimaryClassTemplate();
        }
        if (template instanceof ICPPClassTemplate) {
            return (ICPPClassTemplate)template;
        }
        return null;
    }

    private static IType getArgumentTypeForDeduction(IType type, boolean parameterIsAReferenceType) {
        if ((type = SemanticUtil.getSimplifiedType(type)) instanceof ICPPReferenceType) {
            type = ((ICPPReferenceType)type).getType();
        }
        IType result = type;
        if (!parameterIsAReferenceType) {
            result = type instanceof IArrayType ? new CPPPointerType(((IArrayType)type).getType()) : (type instanceof IFunctionType ? new CPPPointerType(type) : SemanticUtil.getNestedType(type, 17));
        }
        return result;
    }

    public static boolean fromTemplateArguments(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] p, ICPPTemplateArgument[] a, CPPTemplateParameterMap map) throws DOMException {
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(pars, null, map, 0);
        if (p == null) {
            return false;
        }
        boolean containsPackExpansion = false;
        int j = 0;
        while (j < p.length) {
            if (p[j].isPackExpansion()) {
                deduct = new TemplateArgumentDeduction(deduct, a.length - j);
                containsPackExpansion = true;
                if (j != p.length - 1) {
                    return false;
                }
                ICPPTemplateArgument pattern = p[j].getExpansionPattern();
                int i = j;
                while (i < a.length) {
                    if (i != j) {
                        deduct.incPackOffset();
                    }
                    if (!deduct.fromTemplateArgument(pattern, a[i])) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            if (j >= a.length) {
                return false;
            }
            if (!deduct.fromTemplateArgument(p[j], a[j])) {
                return false;
            }
            ++j;
        }
        if (!containsPackExpansion && p.length < a.length) {
            return false;
        }
        return TemplateArgumentDeduction.verifyDeduction(pars, map, false);
    }

    private static boolean verifyDeduction(ICPPTemplateParameter[] pars, CPPTemplateParameterMap tpMap, boolean useDefaults) {
        InstantiationContext context = InstantiationContext.forDeduction(tpMap);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = tpMap.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    context.addToParameterMap(tpar, ICPPTemplateArgument.EMPTY_ARGUMENTS);
                } else {
                    ICPPTemplateArgument[] iCPPTemplateArgumentArray = deducedArgs;
                    int n3 = deducedArgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n4];
                        if (arg == null) {
                            return false;
                        }
                        ++n4;
                    }
                }
            } else {
                ICPPTemplateArgument deducedArg = tpMap.getArgument(tpar);
                if (deducedArg == null && useDefaults && (deducedArg = tpar.getDefaultValue()) != null && CPPTemplates.isValidArgument(deducedArg = CPPTemplates.instantiateArgument(deducedArg, context))) {
                    context.addToParameterMap(tpar, deducedArg);
                }
                if (deducedArg == null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private TemplateArgumentDeduction(ICPPTemplateParameter[] tpars, CPPTemplateParameterMap explicit, CPPTemplateParameterMap result, int packSize) {
        this.fExplicitArgs = explicit;
        this.fDeducedArgs = result;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tpars;
        int n = tpars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                if (this.fTemplateParameterPacks == null) {
                    this.fTemplateParameterPacks = new HashSet<Integer>();
                }
                this.fTemplateParameterPacks.add(tpar.getParameterID());
            }
            ++n2;
        }
    }

    private TemplateArgumentDeduction(TemplateArgumentDeduction base, int packSize) {
        this.fExplicitArgs = base.fExplicitArgs;
        this.fDeducedArgs = base.fDeducedArgs;
        this.fTemplateParameterPacks = base.fTemplateParameterPacks;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
    }

    private CPPTemplateParameterMap saveState() {
        return new CPPTemplateParameterMap(this.fDeducedArgs);
    }

    private void restoreState(CPPTemplateParameterMap saved) {
        this.fDeducedArgs = saved;
    }

    private void incPackOffset() {
        ++this.fPackOffset;
        assert (this.fPackOffset < this.fPackSize);
    }

    private boolean fromTemplateArgument(ICPPTemplateArgument p, ICPPTemplateArgument a) throws DOMException {
        if (p.isNonTypeValue() != a.isNonTypeValue()) {
            return false;
        }
        if (p.isNonTypeValue()) {
            IValue tval = p.getNonTypeValue();
            if (IntegralValue.referencesTemplateParameter(tval)) {
                int parId = IntegralValue.isTemplateParameter(tval);
                if (parId >= 0) {
                    ICPPTemplateArgument old = this.fDeducedArgs.getArgument(parId, this.fPackOffset);
                    if (old == null) {
                        return this.deduce(parId, a);
                    }
                    return old.isSameValue(a);
                }
                return true;
            }
            IValue sval = a.getNonTypeValue();
            tval = CPPTemplates.instantiateValue(tval, InstantiationContext.forDeduction(this.fDeducedArgs), 25);
            return tval.equals(sval);
        }
        return this.fromType(p.getTypeValue(), a.getOriginalTypeValue(), false, true) || a.getTypeValue() != a.getOriginalTypeValue() && this.fromType(p.getTypeValue(), a.getTypeValue(), false, true);
    }

    private boolean fromArraySize(IValue ps, IValue as) {
        if (as != ps) {
            ICPPTemplateArgument old;
            if (as == null || ps == null) {
                return false;
            }
            int parID = IntegralValue.isTemplateParameter(ps);
            if (parID >= 0 ? ((old = this.fDeducedArgs.getArgument(parID, this.fPackOffset)) == null ? !this.deduce(parID, new CPPTemplateNonTypeArgument(as, new TypeOfValueDeducedFromArraySize())) : !as.equals(old.getNonTypeValue())) : !as.equals(ps)) {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean fromType(IType p, IType a, boolean allowCVQConversion, boolean verifyNonDeduced) throws DOMException {
        originalArgType = a;
        a = SemanticUtil.getSimplifiedType(a);
        ** GOTO lbl128
        {
            a = ((ITypedef)a).getType();
            do {
                if (a instanceof ITypedef) continue block4;
                while (p instanceof ITypedef) {
                    p = ((ITypedef)p).getType();
                }
                if (p instanceof IBasicType) {
                    return p.isSameType(a);
                }
                if (p instanceof ICPPPointerToMemberType) {
                    if (!(a instanceof ICPPPointerToMemberType)) {
                        return false;
                    }
                    ptrP = (ICPPPointerToMemberType)p;
                    ptrA = (ICPPPointerToMemberType)a;
                    if (!(allowCVQConversion || ptrP.isConst() == ptrA.isConst() && ptrP.isVolatile() == ptrA.isVolatile())) {
                        return false;
                    }
                    if (!this.fromType(ptrP.getMemberOfClass(), ptrA.getMemberOfClass(), false, false)) {
                        return false;
                    }
                    p = ptrP.getType();
                    a = ptrA.getType();
                    continue;
                }
                if (p instanceof IPointerType) {
                    ptrP = (IPointerType)p;
                    p = ptrP.getType();
                    if (a instanceof TypeOfDependentExpression) {
                        eval = ((TypeOfDependentExpression)a).getEvaluation();
                        eval = new EvalUnary(4, eval, null, eval.getTemplateDefinition());
                        a = new TypeOfDependentExpression(eval);
                        continue;
                    }
                    if (!(a instanceof IPointerType)) {
                        return false;
                    }
                    ptrA = (IPointerType)a;
                    if (!(allowCVQConversion || ptrP.isConst() == ptrA.isConst() && ptrP.isVolatile() == ptrA.isVolatile())) {
                        return false;
                    }
                    a = ptrA.getType();
                    continue;
                }
                if (p instanceof ICPPReferenceType) {
                    if (!(a instanceof ICPPReferenceType)) {
                        return false;
                    }
                    rp = (ICPPReferenceType)p;
                    ra = (ICPPReferenceType)a;
                    if (ra.isRValueReference() != rp.isRValueReference()) {
                        return false;
                    }
                    p = rp.getType();
                    a = ra.getType();
                    continue;
                }
                if (p instanceof IArrayType) {
                    if (!(a instanceof IArrayType)) {
                        return false;
                    }
                    aa = (IArrayType)a;
                    pa = (IArrayType)p;
                    as = aa.getSize();
                    ps = pa.getSize();
                    if (!this.fromArraySize(ps, as)) {
                        return false;
                    }
                    p = pa.getType();
                    a = aa.getType();
                    continue;
                }
                if (p instanceof IQualifierType) {
                    cvqP = SemanticUtil.getCVQualifier(p);
                    cvqA = SemanticUtil.getCVQualifier(a);
                    remaining = CVQualifier.NONE;
                    if (cvqP != cvqA) {
                        if (!allowCVQConversion && !cvqA.isAtLeastAsQualifiedAs(cvqP)) {
                            return false;
                        }
                        remaining = cvqA.remove(cvqP);
                    }
                    p = SemanticUtil.getNestedType(p, 16);
                    a = SemanticUtil.getNestedType(a, 16);
                    if (p instanceof IQualifierType) {
                        return false;
                    }
                    if (remaining == CVQualifier.NONE) continue;
                    a = SemanticUtil.addQualifiers(a, remaining.isConst(), remaining.isVolatile(), remaining.isRestrict());
                    continue;
                }
                if (p instanceof ICPPFunctionType) {
                    ftp = (ICPPFunctionType)p;
                    if (a instanceof ICPPFunctionType) {
                        return this.fromFunctionType(ftp, (ICPPFunctionType)a);
                    }
                    if (a instanceof FunctionSetType) {
                        success = null;
                        var12_10 = fs = ((FunctionSetType)a).getFunctionSet().getBindings();
                        var11_11 = fs.length;
                        var10_12 = 0;
                        while (var10_12 < var11_11) {
                            f = var12_10[var10_12];
                            fta = f.getType();
                            saved = this.saveState();
                            try {
                                if (this.fromFunctionType(ftp, fta)) {
                                    if (success != null) {
                                        return false;
                                    }
                                    success = this.saveState();
                                }
                            }
                            finally {
                                this.restoreState(saved);
                            }
                            ++var10_12;
                        }
                        if (success != null) {
                            this.restoreState(success);
                            return true;
                        }
                    }
                    return false;
                }
                if (p instanceof ICPPTemplateParameter) {
                    current = this.fDeducedArgs.getArgument(((ICPPTemplateParameter)p).getParameterID(), this.fPackOffset);
                    if (current != null) {
                        if (current.isNonTypeValue()) {
                            return false;
                        }
                        return current.getTypeValue().isSameType(a);
                    }
                    if (a == null) {
                        return false;
                    }
                    return this.deduce(((ICPPTemplateParameter)p).getParameterID(), new CPPTemplateTypeArgument(a, ExpressionTypes.restoreTypedefs(a, originalArgType)));
                }
                if (p instanceof ICPPTemplateInstance) {
                    if (!(a instanceof ICPPTemplateInstance)) {
                        return false;
                    }
                    return this.fromTemplateInstance((ICPPTemplateInstance)p, (ICPPTemplateInstance)a);
                }
                if (p instanceof ICPPUnknownBinding) {
                    if (!verifyNonDeduced) {
                        return true;
                    }
                    context = InstantiationContext.forDeduction(this.fDeducedArgs);
                    bindingType = CPPTemplates.resolveUnknownBindingOrType((ICPPUnknownBinding)p, context);
                    if (bindingType.getBinding() instanceof ICPPUnknownBinding) {
                        return true;
                    }
                    if (bindingType.getType() == null) continue;
                    return bindingType.getType().isSameType(a);
                }
                return p.isSameType(a);
lbl128:
                // 9 sources

            } while (p != null);
        }
        return false;
    }

    private boolean fromTemplateInstance(ICPPTemplateInstance pInst, ICPPTemplateInstance aInst) throws DOMException {
        int tparId;
        ICPPTemplateArgument current;
        ICPPClassTemplate pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst);
        ICPPClassTemplate aTemplate = TemplateArgumentDeduction.getPrimaryTemplate(aInst);
        if (pTemplate == null || aTemplate == null) {
            return false;
        }
        if (pTemplate instanceof ICPPTemplateTemplateParameter ? ((current = this.fDeducedArgs.getArgument(tparId = ((ICPPTemplateTemplateParameter)pTemplate).getParameterID(), this.fPackOffset)) != null ? current.isNonTypeValue() || !current.getTypeValue().isSameType(aTemplate) : !this.deduce(tparId, new CPPTemplateTypeArgument(aTemplate))) : !aTemplate.isSameType(pTemplate)) {
            return false;
        }
        ICPPTemplateArgument[] pArgs = pInst.getTemplateArguments();
        int i = 0;
        while (i < pArgs.length - 1) {
            if (pArgs[i].isPackExpansion()) {
                return true;
            }
            ++i;
        }
        ICPPTemplateArgument[] aArgs = aInst.getTemplateArguments();
        if (pArgs.length != aArgs.length) {
            if (pArgs.length == 0 || pArgs.length > aArgs.length + 1) {
                return false;
            }
            ICPPTemplateArgument lastPParam = pArgs[pArgs.length - 1];
            if (!lastPParam.isPackExpansion()) {
                return false;
            }
        }
        ICPPTemplateArgument expansionPattern = null;
        TemplateArgumentDeduction deduct = this;
        int i2 = 0;
        while (i2 < aArgs.length) {
            ICPPTemplateArgument p;
            if (expansionPattern != null) {
                p = expansionPattern;
                deduct.incPackOffset();
                context = new InstantiationContext((ICPPTemplateParameterMap)this.fExplicitArgs, deduct.fPackOffset);
                p = CPPTemplates.instantiateArgument(p, context);
                if (!CPPTemplates.isValidArgument(p)) {
                    return false;
                }
            } else {
                p = pArgs[i2];
                if (p.isPackExpansion()) {
                    p = expansionPattern = p.getExpansionPattern();
                    deduct = new TemplateArgumentDeduction(this, aArgs.length - i2);
                    context = new InstantiationContext((ICPPTemplateParameterMap)this.fExplicitArgs, deduct.fPackOffset);
                    if (!CPPTemplates.isValidArgument(p = CPPTemplates.instantiateArgument(p, context))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromTemplateArgument(p, aArgs[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean fromFunctionType(ICPPFunctionType ftp, ICPPFunctionType fta) throws DOMException {
        IType[] aParams;
        if (ftp.isConst() != fta.isConst() || ftp.isVolatile() != fta.isVolatile() || ftp.takesVarArgs() != fta.takesVarArgs() || ftp.hasRefQualifier() != fta.hasRefQualifier() || ftp.isRValueReference() != fta.isRValueReference()) {
            return false;
        }
        if (!this.fromType(ftp.getReturnType(), fta.getReturnType(), false, false)) {
            return false;
        }
        IType[] pParams = ftp.getParameterTypes();
        if (pParams.length != (aParams = fta.getParameterTypes()).length) {
            if (SemanticUtil.isEmptyParameterList(pParams) && SemanticUtil.isEmptyParameterList(aParams)) {
                return true;
            }
            if (pParams.length == 0 || pParams.length > aParams.length + 1) {
                return false;
            }
            IType lastPParam = pParams[pParams.length - 1];
            if (!(lastPParam instanceof ICPPParameterPackType)) {
                return false;
            }
        }
        IType parameterPack = null;
        TemplateArgumentDeduction deduct = this;
        int i = 0;
        while (i < aParams.length) {
            IType p;
            if (parameterPack != null) {
                p = parameterPack;
                deduct.incPackOffset();
                context = new InstantiationContext((ICPPTemplateParameterMap)this.fExplicitArgs, deduct.fPackOffset);
                p = CPPTemplates.instantiateType(p, context);
                if (!SemanticUtil.isValidType(p)) {
                    return false;
                }
            } else {
                p = pParams[i];
                if (p instanceof ICPPParameterPackType) {
                    p = parameterPack = ((ICPPParameterPackType)p).getType();
                    deduct = new TemplateArgumentDeduction(this, aParams.length - i);
                    context = new InstantiationContext((ICPPTemplateParameterMap)this.fExplicitArgs, deduct.fPackOffset);
                    if (!SemanticUtil.isValidType(p = CPPTemplates.instantiateType(p, context))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromType(p, aParams[i], false, true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean deduce(int parID, ICPPTemplateArgument arg) {
        if (this.fTemplateParameterPacks != null && this.fTemplateParameterPacks.contains(parID)) {
            if (this.fPackSize == 0) {
                return false;
            }
            return this.fDeducedArgs.putPackElement(parID, this.fPackOffset, arg, this.fPackSize);
        }
        if (SemanticUtil.isUniqueTypeForParameterPack(arg.getTypeValue())) {
            return false;
        }
        this.fDeducedArgs.put(parID, arg);
        return true;
    }

    private static class TypeOfValueDeducedFromArraySize
    extends CPPBasicType {
        public TypeOfValueDeducedFromArraySize() {
            super(IBasicType.Kind.eInt, 0);
        }
    }
}

