/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.bugs.DefaultSupportHandler;
import org.eclipse.mylyn.internal.tasks.bugs.SupportRequest;
import org.eclipse.mylyn.tasks.bugs.AbstractSupportHandler;
import org.eclipse.mylyn.tasks.bugs.ISupportResponse;
import org.eclipse.mylyn.tasks.bugs.ITaskContribution;

public class SupportHandlerManager {
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_TASK_HANDLER = "handler";
    private static final String EXTENSION_ID_TASK_CONTRIBUTORS = "support";
    private final DefaultSupportHandler defaultSupportHandler = new DefaultSupportHandler();
    private boolean readExtensions;
    private final List<AbstractSupportHandler> taskContributors = new CopyOnWriteArrayList<AbstractSupportHandler>();

    public void addErrorReporter(AbstractSupportHandler taskContributor) {
        this.taskContributors.add(taskContributor);
    }

    public void process(final ITaskContribution contribution, final IProgressMonitor monitor) {
        this.readExtensions();
        for (final AbstractSupportHandler contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.process(contribution, monitor);
                }
            });
            if (contribution.isHandled()) break;
        }
        if (!contribution.isHandled()) {
            this.defaultSupportHandler.process(contribution, monitor);
        }
    }

    public void postProcess(final ISupportResponse response, final IProgressMonitor monitor) {
        this.readExtensions();
        for (final AbstractSupportHandler contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.postProcess(response, monitor);
                }
            });
        }
        this.defaultSupportHandler.postProcess(response, monitor);
    }

    public void preProcess(final SupportRequest request) {
        this.readExtensions();
        for (final AbstractSupportHandler contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.preProcess(request);
                }
            });
        }
        this.defaultSupportHandler.preProcess(request);
    }

    private synchronized void readExtensions() {
        if (this.readExtensions) {
            return;
        }
        this.readExtensions = true;
        ExtensionPointReader<AbstractSupportHandler> reader = new ExtensionPointReader<AbstractSupportHandler>("org.eclipse.mylyn.tasks.bugs", EXTENSION_ID_TASK_CONTRIBUTORS, ELEMENT_TASK_HANDLER, AbstractSupportHandler.class){

            protected AbstractSupportHandler readElement(IConfigurationElement element, MultiStatus result) {
                return SupportHandlerManager.this.readTaskContributor(element, result);
            }
        };
        reader.read();
        this.taskContributors.addAll(reader.getItems());
    }

    private AbstractSupportHandler readTaskContributor(IConfigurationElement element, MultiStatus result) {
        try {
            Object object = element.createExecutableExtension(ELEMENT_CLASS);
            if (object instanceof AbstractSupportHandler) {
                return (AbstractSupportHandler)object;
            }
            result.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", "Could not load task contributor extenstion: \"" + object.getClass().getCanonicalName() + "\" does not implement \"" + AbstractSupportHandler.class.getCanonicalName() + "\""));
        }
        catch (Throwable e) {
            result.add((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", "Could not load task contributor extension", e));
        }
        return null;
    }

    public void removeErrorReporter(AbstractSupportHandler taskContributor) {
        this.taskContributors.remove(taskContributor);
    }
}

