/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.synchronization.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.graph.Edge;

public class SyncGraph<V, E> {
    private Multimap<V, Edge<V, E>> fAdjacentEdges = ArrayListMultimap.create();
    private Set<V> fVertices = new HashSet<V>();

    public void addEdge(V from, V to, E label) {
        this.fAdjacentEdges.put(from, new Edge<V, E>(from, to, label));
        this.fVertices.add(from);
        this.fVertices.add(to);
    }

    public int getNbEdges() {
        return this.fAdjacentEdges.entries().size();
    }

    public int getNbVertices() {
        return this.fVertices.size();
    }

    public Collection<Edge<V, E>> getAdjacentEdges(V v) {
        return this.fAdjacentEdges.get(v);
    }

    public List<Edge<V, E>> path(V start, V end) {
        Object node;
        ArrayList<Edge<V, Edge>> path = new ArrayList<Edge<V, Edge>>();
        HashMap<V, Edge<V, E>> hist = new HashMap<V, Edge<V, E>>();
        HashSet<V> visited = new HashSet<V>();
        LinkedList<V> queue = new LinkedList<V>();
        queue.offer(start);
        while (!queue.isEmpty()) {
            node = queue.poll();
            visited.add(node);
            for (Edge<V, E> e : this.getAdjacentEdges(node)) {
                V to = e.getTo();
                if (visited.contains(to)) continue;
                queue.offer(e.getTo());
                if (hist.containsKey(e.getTo())) continue;
                hist.put(e.getTo(), e);
            }
        }
        node = end;
        Edge edge = (Edge)hist.get(node);
        while (edge != null && node != start) {
            path.add(edge);
            node = edge.getFrom();
            edge = (Edge)hist.get(node);
        }
        Collections.reverse(path);
        return path;
    }

    public boolean isConnected() {
        HashSet visited = new HashSet();
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(this.fVertices.iterator().next());
        while (!stack.isEmpty()) {
            Object node = stack.removeFirst();
            visited.add(node);
            for (Edge edge : this.getAdjacentEdges(node)) {
                if (visited.contains(edge.getTo())) continue;
                stack.addFirst(edge.getTo());
            }
        }
        return visited.size() == this.fVertices.size();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Object key : this.fAdjacentEdges.keySet()) {
            str.append(String.valueOf(key) + ": " + String.valueOf(this.fAdjacentEdges.get(key)) + "\n");
        }
        return str.toString();
    }
}

