/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class CommentGroupStrategy {
    public static final int MAX_CURRENT = 12;
    public static final int MAX_RECENT = 20;

    public List<CommentGroup> groupComments(List<ITaskComment> comments, String currentPersonId) {
        int recentToIndex;
        int recentFromIndex;
        ArrayList<ITaskComment> recent;
        if (comments.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<CommentGroup> commentGroups = new ArrayList<CommentGroup>(3);
        ArrayList<ITaskComment> current = new ArrayList(12);
        if (comments.size() > 12) {
            int i = comments.size() - 1;
            while (i >= 0) {
                ITaskComment comment = comments.get(i);
                if (this.isCurrent(current, comment, currentPersonId)) {
                    current.add(comment);
                }
                --i;
            }
            Collections.reverse(current);
        } else {
            current = comments;
        }
        commentGroups.add(new CommentGroup(CommentGroup.CURRENT, current, this.hasIncomingChanges(current)));
        if (comments.size() > current.size() && (recent = new ArrayList<ITaskComment>(comments.subList(recentFromIndex = Math.max((recentToIndex = comments.size() - current.size()) - 20, 0), recentToIndex))).size() > 0) {
            commentGroups.add(new CommentGroup(CommentGroup.RECENT, recent, this.hasIncomingChanges(recent)));
            if (comments.size() > current.size() + recent.size()) {
                int olderToIndex = comments.size() - current.size() - recent.size();
                ArrayList<ITaskComment> older = new ArrayList<ITaskComment>(comments.subList(0, olderToIndex));
                commentGroups.add(new CommentGroup(CommentGroup.OLDER, older, this.hasIncomingChanges(older)));
            }
        }
        Collections.reverse(commentGroups);
        return commentGroups;
    }

    protected boolean hasIncomingChanges(ITaskComment taskComment) {
        return false;
    }

    private boolean hasIncomingChanges(List<ITaskComment> comments) {
        for (ITaskComment comment : comments) {
            if (!this.hasIncomingChanges(comment)) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrent(List<ITaskComment> current, ITaskComment comment, String currentPersonId) {
        ITaskComment lastComment;
        IRepositoryPerson lastPerson;
        if (current.size() >= 12) {
            return false;
        }
        if (this.hasIncomingChanges(comment)) {
            return true;
        }
        if (!current.isEmpty() && (lastPerson = (lastComment = current.get(current.size() - 1)).getAuthor()) != null && lastPerson.matchesUsername(currentPersonId)) {
            IRepositoryPerson person = comment.getAuthor();
            return person != null && person.getPersonId().equals(currentPersonId) && lastComment.getText() != null && lastComment.getText().contains("mylyn/context/zip");
        }
        return true;
    }

    public static class CommentGroup {
        public static final String CURRENT = Messages.CommentGroupStrategy_Current;
        public static final String OLDER = Messages.CommentGroupStrategy_Older;
        public static final String RECENT = Messages.CommentGroupStrategy_Recent;
        private final List<ITaskComment> comments;
        private final String groupName;
        private final boolean incoming;

        public CommentGroup(String groupName, List<ITaskComment> comments, boolean incoming) {
            this.groupName = groupName;
            this.comments = comments;
            this.incoming = incoming;
        }

        public List<TaskAttribute> getCommentAttributes() {
            ArrayList<TaskAttribute> commentAttributes = new ArrayList<TaskAttribute>(this.comments.size());
            for (ITaskComment comment : this.comments) {
                commentAttributes.add(comment.getTaskAttribute());
            }
            return Collections.unmodifiableList(commentAttributes);
        }

        public List<ITaskComment> getComments() {
            return Collections.unmodifiableList(this.comments);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean hasIncoming() {
            return this.incoming;
        }
    }
}

