/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PriorityEditor {
    private Control control;
    private boolean ignoreNotification;
    private Label label;
    private Map<String, String> labelByValue;
    private Menu menu;
    private boolean readOnly;
    private ToolItem selectionButton;
    private ToolBar toolBar;
    private String value;
    private final TaskAttribute attribute;

    public PriorityEditor() {
        this(null);
    }

    public PriorityEditor(TaskAttribute attribute) {
        this.attribute = attribute;
    }

    public void createControl(final Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.label = toolkit.createLabel(parent, "");
            this.setControl((Control)this.label);
        } else {
            this.toolBar = new ToolBar(parent, 0x800000);
            this.selectionButton = new ToolItem(this.toolBar, 4);
            this.selectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (PriorityEditor.this.menu == null) {
                        PriorityEditor.this.createMenu(PriorityEditor.this.toolBar);
                    }
                    Point location = parent.toDisplay(PriorityEditor.this.toolBar.getLocation());
                    location.y += PriorityEditor.this.selectionButton.getBounds().height;
                    if (PriorityEditor.this.value != null) {
                        MenuItem[] items;
                        MenuItem[] menuItemArray = items = PriorityEditor.this.menu.getItems();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MenuItem item = menuItemArray[n2];
                            item.setSelection(PriorityEditor.this.value.equals(item.getData()));
                            ++n2;
                        }
                    }
                    PriorityEditor.this.menu.setLocation(location);
                    PriorityEditor.this.menu.setVisible(true);
                }
            });
            this.selectionButton.addDisposeListener(e -> {
                if (this.menu != null) {
                    this.menu.dispose();
                }
            });
            toolkit.adapt((Composite)this.toolBar);
            this.setControl((Control)this.toolBar);
        }
    }

    private void createMenu(ToolBar bar) {
        this.menu = new Menu((Control)bar);
        for (String key : this.labelByValue.keySet()) {
            final MenuItem item = new MenuItem(this.menu, 32);
            item.setText(this.labelByValue.get(key));
            item.setData((Object)key);
            item.setImage(this.getSmallImage(key));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!PriorityEditor.this.ignoreNotification) {
                        PriorityEditor.this.value = (String)item.getData();
                        PriorityEditor.this.valueChanged(PriorityEditor.this.value);
                    }
                }
            });
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Map<String, String> getLabelByValue() {
        return Collections.unmodifiableMap(this.labelByValue);
    }

    private ImageDescriptor getLargeImageDescriptor(ITask.PriorityLevel priorityLevel) {
        if (priorityLevel != null) {
            return switch (priorityLevel) {
                case ITask.PriorityLevel.P1 -> CommonImages.PRIORITY_1_LARGE;
                case ITask.PriorityLevel.P2 -> CommonImages.PRIORITY_2_LARGE;
                case ITask.PriorityLevel.P3 -> CommonImages.PRIORITY_3_LARGE;
                case ITask.PriorityLevel.P4 -> CommonImages.PRIORITY_4_LARGE;
                case ITask.PriorityLevel.P5 -> CommonImages.PRIORITY_5_LARGE;
                default -> throw new MatchException(null, null);
            };
        }
        return CommonImages.PRIORITY_3_LARGE;
    }

    private Image getSmallImage(String value) {
        ImageDescriptor descriptor = this.getSmallImageDescriptor(value);
        if (descriptor != null) {
            return CommonImages.getImage((ImageDescriptor)descriptor);
        }
        return null;
    }

    private ImageDescriptor getSmallImageDescriptor(String value) {
        ITask.PriorityLevel priorityLevel = this.getPriorityLevel(value);
        if (priorityLevel != null) {
            return TasksUiImages.getImageDescriptorForPriority(priorityLevel);
        }
        return null;
    }

    private ITask.PriorityLevel getPriorityLevel(String value) {
        if (this.attribute != null) {
            return this.attribute.getTaskData().getAttributeMapper().getPriorityLevel(this.attribute, value);
        }
        return ITask.PriorityLevel.fromString((String)value);
    }

    public String getToolTipText() {
        if (this.label != null) {
            return this.label.getToolTipText();
        }
        if (this.selectionButton != null) {
            return this.selectionButton.getToolTipText();
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void select(String value, ITask.PriorityLevel level) {
        try {
            this.ignoreNotification = true;
            this.value = value;
            if (this.label != null) {
                this.label.setImage(CommonImages.getImage((ImageDescriptor)this.getLargeImageDescriptor(level)));
            }
            if (this.selectionButton != null && this.toolBar != null) {
                this.selectionButton.setImage(CommonImages.getImage((ImageDescriptor)this.getLargeImageDescriptor(level)));
            }
        }
        finally {
            this.ignoreNotification = false;
        }
    }

    private void setControl(Control control) {
        this.control = control;
    }

    public void setLabelByValue(Map<String, String> labelByValue) {
        this.labelByValue = new LinkedHashMap<String, String>(labelByValue);
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setToolTipText(String text) {
        if (this.label != null) {
            this.label.setToolTipText(text);
        }
        if (this.selectionButton != null) {
            this.selectionButton.setToolTipText(text);
        }
    }

    protected void valueChanged(String key) {
    }

    public String getValue() {
        return this.value;
    }
}

