/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringMatch;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessorDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CRenameLocalProcessor
extends CRenameProcessorDelegate {
    private IScope fScope;

    public CRenameLocalProcessor(CRenameProcessor input, String kind, IScope scope) {
        super(input, kind);
        this.fScope = scope;
        this.setAvailableOptions(0);
        this.setOptionsForcingPreview(0);
    }

    @Override
    protected int getAcceptedLocations(int selectedOptions) {
        return 0x21 | selectedOptions;
    }

    @Override
    protected int getSearchScope() {
        return 1;
    }

    @Override
    protected void analyzeTextMatches(IBinding[] renameBindings, Collection<CRefactoringMatch> matches, IProgressMonitor monitor, RefactoringStatus status) {
        super.analyzeTextMatches(renameBindings, matches, monitor, status);
        if (this.fScope != null) {
            IASTFileLocation loc;
            CRefactoringArgument argument = this.getArgument();
            int[] nArray = new int[2];
            nArray[1] = Integer.MAX_VALUE;
            int[] result = nArray;
            IScope scope = argument.getScope();
            IASTNode node = null;
            node = ASTInternal.getPhysicalNodeOfScope((IScope)scope);
            if (argument.getBinding() instanceof IParameter) {
                node = node.getParent();
            }
            if (node != null && (loc = ASTManager.getLocationInTranslationUnit(node)) != null) {
                result[0] = loc.getNodeOffset();
                result[1] = result[0] + loc.getNodeLength();
            }
            int[] range = result;
            Iterator<CRefactoringMatch> iter = matches.iterator();
            while (iter.hasNext()) {
                int off;
                CRefactoringMatch m = iter.next();
                if (m.getAstInformation() == 1 || (off = m.getOffset()) >= range[0] && off <= range[1]) continue;
                iter.remove();
            }
        }
    }

    @Override
    public int getSaveMode() {
        return 3;
    }
}

