/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleStrategyFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ToggleRefactoring
extends CRefactoring {
    private ITextSelection selection;
    private IToggleRefactoringStrategy strategy;
    private ToggleRefactoringContext context;

    public ToggleRefactoring(ICElement element, ITextSelection selection, ICProject project) {
        super(element, (ISelection)selection, project);
        if (selection == null || this.tu.getResource() == null || project == null) {
            this.initStatus.addFatalError(Messages.ToggleRefactoring_InvalidSelection);
        }
        this.selection = selection;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.subTask(Messages.ToggleRefactoring_WaitingForIndexer);
            this.prepareIndexer(pm);
            pm.subTask(Messages.ToggleRefactoring_AnalyseSelection);
            this.context = new ToggleRefactoringContext(this.refactoringContext, this.getIndex(), this.tu, this.selection);
            this.strategy = new ToggleStrategyFactory(this.context).getAppropriateStategy();
            IASTTranslationUnit definitionAST = this.context.getDefinitionAST();
            if (definitionAST != null && this.checkAST(definitionAST)) {
                this.initStatus.addFatalError(Messages.ToggleRefactoring_SyntaxError);
            }
        }
        catch (NotSupportedException e) {
            this.initStatus.addFatalError(e.getMessage());
        }
        return this.initStatus;
    }

    private void prepareIndexer(IProgressMonitor pm) throws CoreException {
        IIndexManager im = CCorePlugin.getIndexManager();
        while (!im.isProjectIndexed(this.project)) {
            im.joinIndexer(500, pm);
            if (!pm.isCanceled()) continue;
            throw new NotSupportedException(Messages.ToggleRefactoring_NoIndex);
        }
        if (!im.isProjectIndexed(this.project)) {
            throw new NotSupportedException(Messages.ToggleRefactoring_NoIndex);
        }
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector modifications) throws CoreException {
        pm.subTask(Messages.ToggleRefactoring_CalculateModifications);
        this.strategy.run(modifications);
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }

    public ToggleRefactoringContext getContext() {
        return this.context;
    }
}

