/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.SourceHeaderPartnerFinder;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.IndexToASTNameHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.DeclaratorFinder;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;

public class ToggleRefactoringContext {
    private IASTFunctionDefinition targetDefinition;
    private IASTFunctionDeclarator targetDeclaration;
    private IASTTranslationUnit targetDefinitionAST;
    private IASTTranslationUnit targetDeclarationAST;
    private final CRefactoringContext refactoringContext;
    private final IIndex index;
    private final ITranslationUnit selectionTU;
    private IASTTranslationUnit selectionAST;
    private IBinding binding;
    private IASTName selectionName;
    private boolean defaultAnswer;
    private boolean settedDefaultAnswer;

    public ToggleRefactoringContext(CRefactoringContext refactoringContext, IIndex index, ITranslationUnit translationUnit, ITextSelection selection) throws OperationCanceledException, CoreException {
        this.refactoringContext = refactoringContext;
        this.index = index;
        this.selectionTU = translationUnit;
        this.findSelectionAST();
        this.findSelectedFunctionDeclarator(selection);
        this.findBinding();
        this.findDeclaration();
        this.findDefinition();
    }

    public void findSelectedFunctionDeclarator(ITextSelection selection) {
        this.selectionName = new DeclaratorFinder(selection, this.selectionAST).getName();
    }

    public void findBinding() {
        try {
            this.binding = this.index.findBinding((IName)this.selectionName);
            if (this.binding == null) {
                this.binding = this.selectionName.resolveBinding();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public void findDeclaration() {
        try {
            IIndexName[] decnames = this.index.findNames(this.binding, 1);
            if (decnames.length > 1) {
                throw new NotSupportedException(Messages.ToggleRefactoringContext_MultipleDeclarations);
            }
            IIndexName[] iIndexNameArray = decnames;
            int n = decnames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName iname = iIndexNameArray[n2];
                this.selectionAST = this.getASTForIndexName(iname);
                IASTName astname = IndexToASTNameHelper.findMatchingASTName(this.selectionAST, (IName)iname, this.index);
                if (astname != null) {
                    this.targetDeclaration = this.findFunctionDeclarator((IASTNode)astname);
                    this.targetDeclarationAST = this.selectionAST;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public void findDefinition() {
        try {
            IIndexName[] defnames = this.index.findNames(this.binding, 2);
            if (defnames.length > 1) {
                throw new NotSupportedException(Messages.ToggleRefactoringContext_MultipleDefinitions);
            }
            IIndexName[] iIndexNameArray = defnames;
            int n = defnames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName iname = iIndexNameArray[n2];
                IASTTranslationUnit unit = this.getASTForIndexName(iname);
                IASTName astname = IndexToASTNameHelper.findMatchingASTName(unit, (IName)iname, this.index);
                if (astname != null) {
                    this.targetDefinition = this.findFunctionDefinition((IASTNode)astname);
                    this.targetDefinitionAST = unit;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        if (this.targetDefinition == null) {
            throw new NotSupportedException(Messages.ToggleRefactoringContext_NoDefinitionFound);
        }
    }

    public IASTFunctionDeclarator getDeclaration() {
        return this.targetDeclaration;
    }

    public IASTFunctionDefinition getDefinition() {
        return this.targetDefinition;
    }

    public IASTTranslationUnit getDeclarationAST() {
        return this.targetDeclarationAST;
    }

    public IASTTranslationUnit getDefinitionAST() {
        return this.targetDefinitionAST;
    }

    public ITranslationUnit getSelectionTU() {
        return this.selectionTU;
    }

    public IFile getSelectionFile() {
        return (IFile)this.selectionTU.getResource();
    }

    public IASTTranslationUnit getASTForPartnerFile() throws CoreException {
        ITranslationUnit tu = SourceHeaderPartnerFinder.getPartnerTranslationUnit(this.selectionTU, this.refactoringContext);
        if (tu == null) {
            return null;
        }
        return this.refactoringContext.getAST(tu, null);
    }

    private void findSelectionAST() throws OperationCanceledException, CoreException {
        this.selectionAST = this.refactoringContext.getAST(this.selectionTU, null);
        if (this.selectionAST == null) {
            throw new NotSupportedException(Messages.ToggleRefactoringContext_NoTuFound);
        }
    }

    private IASTTranslationUnit getASTForIndexName(IIndexName indexName) throws CModelException, CoreException {
        if (this.isSameFileAsInTU(indexName)) {
            return this.selectionAST;
        }
        ITranslationUnit tu = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)indexName.getFile().getLocation(), null);
        if (tu == null) {
            return null;
        }
        return this.refactoringContext.getAST(tu, null);
    }

    private boolean isSameFileAsInTU(IIndexName indexName) {
        return indexName.getFileLocation().getFileName().equals(this.selectionAST.getFileLocation().getFileName());
    }

    private IASTFunctionDeclarator findFunctionDeclarator(IASTNode node) {
        if (node instanceof IASTSimpleDeclaration) {
            return (IASTFunctionDeclarator)((IASTSimpleDeclaration)node).getDeclarators()[0];
        }
        return (IASTFunctionDeclarator)ASTQueries.findAncestorWithType((IASTNode)node, IASTFunctionDeclarator.class);
    }

    private IASTFunctionDefinition findFunctionDefinition(IASTNode node) {
        return (IASTFunctionDefinition)ASTQueries.findAncestorWithType((IASTNode)node, IASTFunctionDefinition.class);
    }

    public void setDefaultAnswer(boolean defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
    }

    public boolean getDefaultAnswer() {
        return this.defaultAnswer;
    }

    public void setSettedDefaultAnswer(boolean settedDefaultAnswer) {
        this.settedDefaultAnswer = settedDefaultAnswer;
    }

    public boolean isSettedDefaultAnswer() {
        return this.settedDefaultAnswer;
    }

    public IASTTranslationUnit getAST(IFile file, IProgressMonitor pm) throws OperationCanceledException, CoreException {
        ITranslationUnit tu = CoreModelUtil.findTranslationUnit((IFile)file);
        if (tu == null) {
            return null;
        }
        tu = CModelUtil.toWorkingCopy(tu);
        return this.refactoringContext.getAST(tu, pm);
    }
}

