/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PlainMessageDialog
extends IconAndMessageDialog {
    private final String title;
    private final Image titleImage;
    private final Image image;
    private final List<String> buttonLabels;
    private final int defaultButtonIndex;
    private Control customArea;

    public static Builder getBuilder(Shell shell, String dialogTitle) {
        return new Builder(shell, dialogTitle);
    }

    private PlainMessageDialog(Builder builder) {
        super(builder.shell);
        this.title = builder.dialogTitle;
        this.titleImage = builder.titleImage;
        this.image = builder.image == null && builder.iconId != -1 ? builder.shell.getDisplay().getSystemImage(builder.iconId) : builder.image;
        this.message = builder.message;
        this.buttonLabels = builder.buttonLabels;
        this.defaultButtonIndex = builder.defaultButtonIndex;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        if (this.titleImage != null) {
            shell.setImage(this.titleImage);
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        int id = 0;
        while (id < this.buttonLabels.size()) {
            this.createButton(parent, id, this.buttonLabels.get(id), this.defaultButtonIndex == id);
            ++id;
        }
    }

    protected Control createCustomArea(Composite parent) {
        Label dummyLabelForSpacingPurposes = new Label(parent, 0);
        return dummyLabelForSpacingPurposes;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.customArea = this.createCustomArea(composite);
        return composite;
    }

    @Override
    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }

    public int open(int style) {
        this.setShellStyle(this.getShellStyle() | (style &= 0x10000000));
        return this.open();
    }

    @Override
    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (defaultButton && !this.customShouldTakeFocus()) {
            button.setFocus();
        }
        return button;
    }

    private boolean customShouldTakeFocus() {
        if (this.customArea instanceof Label) {
            return false;
        }
        if (this.customArea instanceof CLabel) {
            return (this.customArea.getStyle() & 0x80000) > 0;
        }
        return true;
    }

    @Override
    protected Image getImage() {
        return this.image;
    }

    public static class Builder {
        private final Shell shell;
        private final String dialogTitle;
        private Image titleImage;
        private Image image;
        private int iconId = -1;
        private String message;
        private List<String> buttonLabels = Arrays.asList(IDialogConstants.OK_LABEL);
        private int defaultButtonIndex = 0;

        private Builder(Shell shell, String dialogTitle) {
            this.shell = shell;
            this.dialogTitle = dialogTitle;
        }

        public Builder titleImage(Image image) {
            this.titleImage = image;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public Builder image(int iconId) {
            this.iconId = iconId;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder buttonLabels(List<String> buttonLabels) {
            this.buttonLabels = buttonLabels;
            return this;
        }

        public Builder defaultButtonIndex(int defaultButtonIndex) {
            this.defaultButtonIndex = defaultButtonIndex;
            return this;
        }

        public PlainMessageDialog build() {
            return new PlainMessageDialog(this);
        }
    }
}

