/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryConstants;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Bundle;

public class GitHub {
    public static final String BUNDLE_ID = "org.eclipse.mylyn.github.core";
    public static final String CONNECTOR_KIND = "github";
    public static final String HTTPS_GITHUB_COM = "https://github.com";
    public static final Pattern URL_PATTERN = Pattern.compile("https?://github.com/([^/]+)/([^/]+)");
    public static final String USER_AGENT = "GitHubEclipse/1.3.0";
    public static final String REPOSITORY_SEGMENTS = "/user/repository";
    @Deprecated(since="4.1")
    public static final String PROPERTY_USE_TOKEN = GitHub.class.getPackage().getName() + ".REPO_USE_TOKEN";

    public static GitHubClient configureClient(GitHubClient client) {
        return client.setUserAgent(USER_AGENT);
    }

    public static GitHubClient addCredentials(GitHubClient client, TaskRepository repository) {
        AuthenticationCredentials credentials = repository.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            if (Boolean.parseBoolean(repository.getProperty(IRepositoryConstants.PROPERTY_USE_TOKEN))) {
                client.setOAuth2Token(credentials.getPassword());
            } else {
                client.setCredentials(credentials.getUserName(), credentials.getPassword());
            }
        }
        return client;
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, BUNDLE_ID, message);
    }

    public static IStatus createStatus(int severity, String message, Throwable e) {
        return new Status(severity, BUNDLE_ID, message, e);
    }

    public static IStatus createErrorStatus(String message) {
        return GitHub.createStatus(4, message);
    }

    public static IStatus createErrorStatus(String message, Throwable t) {
        return GitHub.createStatus(4, message, t);
    }

    public static IStatus createErrorStatus(Throwable e) {
        return GitHub.createStatus(4, "Unexpected error: " + e.getLocalizedMessage(), e);
    }

    public static IStatus createWrappedStatus(IOException e) {
        return GitHub.createErrorStatus(GitHubException.wrap(e));
    }

    public static ILog getLog() {
        return Platform.getLog((Bundle)Platform.getBundle((String)BUNDLE_ID));
    }

    public static void logError(String message, Throwable t) {
        GitHub.getLog().log(GitHub.createErrorStatus(message, t));
    }

    public static void logError(Throwable t) {
        GitHub.getLog().log(GitHub.createErrorStatus(t.getMessage(), t));
    }

    public static RepositoryId getRepository(String repositoryUrl) {
        return RepositoryId.createFromUrl((String)repositoryUrl);
    }

    public static String createGitHubUrl(String user, String project) {
        return "https://github.com/" + user + "/" + project;
    }
}

