/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlocksTreeViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class SwitchMemoryBlockAction
extends Action
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    private MenuCreator fMenuCreator;
    private IAction fAction;
    private final UpdateActionEnablementJob fUpdateJob = new UpdateActionEnablementJob();
    private final IMemoryBlockListener fListener = new IMemoryBlockListener(){

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            if (SwitchMemoryBlockAction.this.fAction != null) {
                SwitchMemoryBlockAction.this.fUpdateJob.schedule();
            }
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            if (SwitchMemoryBlockAction.this.fAction != null) {
                SwitchMemoryBlockAction.this.fUpdateJob.schedule();
            }
        }
    };
    private final IDebugContextListener fDebugContextListener = event -> {
        if (this.fAction != null) {
            this.fUpdateJob.schedule();
        }
    };

    public void init(IViewPart view) {
        this.fView = view;
        DebugUITools.getDebugContextManager().getContextService(this.fView.getViewSite().getWorkbenchWindow()).addDebugContextListener(this.fDebugContextListener);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener(this.fListener);
        this.fUpdateJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    private StructuredViewer getViewer() {
        MemoryView memView;
        IMemoryViewPane pane;
        IViewPart iViewPart = this.fView;
        if (iViewPart instanceof MemoryView && (pane = (memView = (MemoryView)iViewPart).getViewPane(MemoryBlocksTreeViewPane.PANE_ID)) instanceof MemoryBlocksTreeViewPane) {
            StructuredViewer viewer = ((MemoryBlocksTreeViewPane)pane).getViewer();
            return viewer;
        }
        return null;
    }

    public void run(IAction action) {
        this.switchToNext();
    }

    public void run() {
        this.switchToNext();
    }

    private void switchToNext() {
        IDebugElement debugContext;
        IMemoryBlockRetrieval retrieval;
        IAdaptable context = this.getDebugContext();
        if (context instanceof IDebugElement && (retrieval = MemoryViewUtil.getMemoryBlockRetrieval(debugContext = (IDebugElement)context)) != null) {
            IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
            this.doSwitchToNext(memoryBlocks);
        }
    }

    private void doSwitchToNext(IMemoryBlock[] memoryBlocks) {
        if (memoryBlocks.length > 1) {
            IMemoryBlock current = this.getCurrentMemoryBlock();
            int next = 0;
            if (current != null) {
                int i = 0;
                while (i < memoryBlocks.length) {
                    if (memoryBlocks[i] == current) {
                        next = i + 1;
                    }
                    ++i;
                }
            }
            if (next > memoryBlocks.length - 1) {
                next = 0;
            }
            SwitchToAction switchAction = new SwitchToAction(memoryBlocks[next], false);
            switchAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        this.fAction = action;
        this.fUpdateJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
        this.fMenuCreator = new MenuCreator();
        action.setMenuCreator((IMenuCreator)this.fMenuCreator);
    }

    public void dispose() {
        this.fAction = null;
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener(this.fListener);
        DebugUITools.getDebugContextManager().getContextService(this.fView.getViewSite().getWorkbenchWindow()).removeDebugContextListener(this.fDebugContextListener);
        if (this.fMenuCreator != null) {
            this.fMenuCreator.dispose();
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.switchToNext();
    }

    private IMemoryBlock getCurrentMemoryBlock() {
        if (this.fView == null) {
            return null;
        }
        ISelection memBlkSelection = this.fView.getSite().getSelectionProvider().getSelection();
        IMemoryBlock memoryBlock = null;
        if (memBlkSelection != null && !memBlkSelection.isEmpty() && memBlkSelection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)memBlkSelection).getFirstElement();
            if (obj instanceof IMemoryBlock) {
                memoryBlock = (IMemoryBlock)obj;
            } else if (obj instanceof IMemoryRendering) {
                memoryBlock = ((IMemoryRendering)obj).getMemoryBlock();
            }
        }
        return memoryBlock;
    }

    private String decorateLabel(IMemoryBlock memBlk, String label) {
        ILabelDecorator decorator = (ILabelDecorator)memBlk.getAdapter(ILabelDecorator.class);
        if (decorator != null) {
            label = decorator.decorateText(label, (Object)memBlk);
        }
        return label;
    }

    private IAdaptable getDebugContext() {
        if (this.fView != null) {
            return DebugUITools.getPartDebugContext(this.fView.getSite());
        }
        return DebugUITools.getDebugContext();
    }

    class MenuCreator
    implements IMenuCreator {
        Menu dropdown;

        MenuCreator() {
        }

        public void dispose() {
            if (this.dropdown != null) {
                this.dropdown.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.dropdown != null) {
                this.dropdown.dispose();
                this.dropdown = null;
            }
            if (this.dropdown == null) {
                this.dropdown = new Menu(parent);
                IMemoryBlock[] allMemoryBlocks = null;
                IMemoryBlock memoryBlock = SwitchMemoryBlockAction.this.getCurrentMemoryBlock();
                IAdaptable context = SwitchMemoryBlockAction.this.getDebugContext();
                IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
                if (retrieval != null) {
                    allMemoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                }
                if (allMemoryBlocks != null) {
                    IMemoryBlock[] iMemoryBlockArray = allMemoryBlocks;
                    int n = allMemoryBlocks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemoryBlock block = iMemoryBlockArray[n2];
                        SwitchToAction action = new SwitchToAction(block, true);
                        if (block == memoryBlock) {
                            action.setChecked(true);
                        }
                        ActionContributionItem item = new ActionContributionItem((IAction)action);
                        item.fill(this.dropdown, -1);
                        item.getAction().setChecked(true);
                        ++n2;
                    }
                }
            }
            return this.dropdown;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    class SwitchToAction
    extends Action {
        private IMemoryBlock fMemoryblock;

        public void run() {
            if (SwitchMemoryBlockAction.this.fView == null) {
                return;
            }
            SwitchMemoryBlockAction.this.fView.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.fMemoryblock));
        }

        public SwitchToAction(final IMemoryBlock memBlk, boolean buildLabel) {
            if (buildLabel) {
                this.setText(DebugUIMessages.SwitchMemoryBlockAction_4);
                Job job = new Job("SwtichToAction"){

                    protected IStatus run(IProgressMonitor monitor) {
                        SwitchToAction.this.getLabels(memBlk);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            this.fMemoryblock = memBlk;
        }

        public SwitchToAction(IMemoryBlock memBlk, String label) {
            super(label);
            this.fMemoryblock = memBlk;
        }

        private void getLabels(IMemoryBlock memBlk) {
            StringBuilder text = new StringBuilder("");
            String label = new String("");
            if (memBlk instanceof IMemoryBlockExtension) {
                String expression = ((IMemoryBlockExtension)memBlk).getExpression();
                if (expression == null) {
                    expression = DebugUIMessages.SwitchMemoryBlockAction_0;
                }
                text.append(expression);
            } else {
                long address = memBlk.getStartAddress();
                text.append(Long.toHexString(address));
            }
            label = text.toString();
            final String finalLabel = label = SwitchMemoryBlockAction.this.decorateLabel(memBlk, label);
            WorkbenchJob job = new WorkbenchJob("SwtichToAction Update Label"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    SwitchToAction.super.setText(finalLabel);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    class UpdateActionEnablementJob
    extends UIJob {
        public UpdateActionEnablementJob() {
            super("Update Action Enablement");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (SwitchMemoryBlockAction.this.fAction != null) {
                IAdaptable context = SwitchMemoryBlockAction.this.getDebugContext();
                if (context != null) {
                    Object input;
                    IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
                    if (retrieval != null) {
                        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                        SwitchMemoryBlockAction.this.fAction.setEnabled(memoryBlocks.length > 0);
                        return Status.OK_STATUS;
                    }
                    if (SwitchMemoryBlockAction.this.getViewer() != null && (input = SwitchMemoryBlockAction.this.getViewer().getInput()) instanceof IMemoryBlockRetrieval) {
                        retrieval = (IMemoryBlockRetrieval)input;
                        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                        SwitchMemoryBlockAction.this.fAction.setEnabled(memoryBlocks.length > 0);
                        return Status.OK_STATUS;
                    }
                }
                SwitchMemoryBlockAction.this.fAction.setEnabled(false);
            }
            return Status.CANCEL_STATUS;
        }
    }
}

