/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.macos;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.Homebrew;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.core.runtime.Path;

public class MacosEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static final String ENV_PATH = "PATH";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if ("HOMEBREW_HOME".equals(variableName)) {
            IEnvironmentVariable homebrewHomeVar = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable("HOMEBREW_HOME", null, false);
            if (homebrewHomeVar == null) {
                String homebrewHome = Homebrew.getHomebrewHome();
                if (homebrewHome == null) {
                    homebrewHome = "";
                }
                return new BuildEnvVar("HOMEBREW_HOME", new Path(homebrewHome).toOSString(), 1);
            }
        } else if (variableName.equals(ENV_PATH)) {
            String path = "${HOMEBREW_HOME}/bin";
            return new BuildEnvVar(ENV_PATH, path, 3);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return new IBuildEnvironmentVariable[]{this.getVariable("HOMEBREW_HOME", configuration, provider), this.getVariable(ENV_PATH, configuration, provider)};
    }
}

