/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.ILogicalLineNumberProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffEntry;

public class LogicalLineNumberProvider
implements ILogicalLineNumberProvider {
    @NonNull
    private final DiffEntry.Side side;
    @NonNull
    private final ITextViewer viewer;

    public LogicalLineNumberProvider(@NonNull DiffEntry.Side side, @NonNull ITextViewer viewer) {
        this.side = side;
        this.viewer = viewer;
    }

    @Override
    public int getLogicalLine(int lineNumber) {
        IDocument document = this.viewer.getDocument();
        if (document instanceof DiffDocument) {
            return ((DiffDocument)document).getLogicalLine(lineNumber, this.side);
        }
        return lineNumber;
    }

    @Override
    public int getMaximum() {
        IDocument document = this.viewer.getDocument();
        if (document instanceof DiffDocument) {
            return ((DiffDocument)document).getMaximumLineNumber(this.side);
        }
        return -1;
    }
}

