/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TitleAndImageDialog
extends TitleAreaDialog {
    private ResourceManager resourceManager;
    private ImageDescriptor defaultImageDescriptor;
    private boolean explicitImageSet;

    public TitleAndImageDialog(Shell parent, ImageDescriptor defaultImageDescriptor) {
        super(parent);
        this.defaultImageDescriptor = defaultImageDescriptor;
    }

    protected Control createContents(Composite parent) {
        if (this.defaultImageDescriptor != null && !this.explicitImageSet) {
            super.setTitleImage(this.getResourceManager().createImage(this.defaultImageDescriptor));
        }
        Control control = super.createContents(parent);
        control.addDisposeListener(event -> {
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        });
        return control;
    }

    public void setTitleImage(Image newTitleImage) {
        this.explicitImageSet = true;
        super.setTitleImage(newTitleImage);
    }

    protected ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }
}

