/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndex;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class CTFIndexFile {
    private static final int CTF_INDEX_MAGIC = -1041113919;
    private static final int CTF_INDEX_MAJOR = 1;
    private static final int CTF_INDEX_MINOR = 1;
    private static final int PACKET_SIZE = 72;
    private final @NonNull StreamInputPacketIndex fIndex;

    public CTFIndexFile(File indexFile, StructDeclaration tracePacketHeaderDecl, StructDeclaration packetContextDecl) throws CTFIOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DataInputStream dataIn = new DataInputStream(new FileInputStream(indexFile));){
                CtfPacketIndexFileHeader header = new CtfPacketIndexFileHeader(dataIn);
                this.fIndex = new StreamInputPacketIndex();
                long packetHeaderBits = (long)tracePacketHeaderDecl.getMaximumSize() + (long)packetContextDecl.getMaximumSize();
                while (dataIn.available() >= header.packetIndexLen) {
                    StreamInputPacketIndexEntry element = header.oldMagic ? new StreamInputPacketIndexEntry(dataIn, packetHeaderBits, indexFile.getName().replace("\\.idx", "")) : new StreamInputPacketIndexEntry(dataIn, packetHeaderBits);
                    this.fIndex.append(element);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFIOException(e);
        }
    }

    public @NonNull StreamInputPacketIndex getStreamInputPacketIndex() {
        return this.fIndex;
    }

    class CtfPacketIndexFileHeader {
        private final int magic;
        private final int indexMajor;
        private final int indexMinor;
        private final int packetIndexLen;
        private final boolean oldMagic;

        public CtfPacketIndexFileHeader(DataInputStream dataIn) throws IOException, CTFIOException {
            this.magic = dataIn.readInt();
            if (this.magic != -1041113919) {
                this.oldMagic = this.magic == 1129596489 ? dataIn.readShort() == 17496 : false;
                if (!this.oldMagic) {
                    throw new CTFIOException("Magic mismatch in index");
                }
            } else {
                this.oldMagic = false;
            }
            this.indexMajor = dataIn.readInt();
            if (this.indexMajor != 1) {
                throw new CTFIOException("Major version mismatch in index");
            }
            this.indexMinor = dataIn.readInt();
            if (this.indexMinor != 1) {
                throw new CTFIOException("Minor version mismatch in index");
            }
            this.packetIndexLen = !this.oldMagic ? dataIn.readInt() : 72;
            if (this.packetIndexLen != 72) {
                throw new CTFIOException("Packet size wrong in index");
            }
        }
    }
}

