/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class TestResultLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    final StyledString.Styler NO_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };

    public Image getImage(Object element) {
        if (element instanceof ITestSuite) {
            return CommonImages.getImage((ImageDescriptor)this.getImageDescriptor((ITestSuite)element));
        }
        if (element instanceof ITestCase) {
            return CommonImages.getImage((ImageDescriptor)this.getImageDescriptor((ITestCase)element));
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(ITestCase testCase) {
        switch (testCase.getStatus()) {
            case PASSED: 
            case FIXED: {
                return BuildImages.TEST_PASSED;
            }
            case FAILED: 
            case REGRESSION: {
                if (testCase.getMessage() != null) {
                    return BuildImages.TEST_FAILED;
                }
                return BuildImages.TEST_ERROR;
            }
            case SKIPPED: {
                return BuildImages.TEST_IGNORED;
            }
        }
        return BuildImages.TEST;
    }

    private ImageDescriptor getImageDescriptor(ITestSuite suite) {
        int passedCount = 0;
        int failedCount = 0;
        int errorCount = 0;
        int ignoredCount = 0;
        for (ITestCase testCase : suite.getCases()) {
            switch (testCase.getStatus()) {
                case PASSED: 
                case FIXED: {
                    ++passedCount;
                    break;
                }
                case FAILED: 
                case REGRESSION: {
                    if (testCase.getMessage() != null) {
                        ++failedCount;
                    } else {
                        ++errorCount;
                    }
                }
                case SKIPPED: {
                    ++ignoredCount;
                }
            }
        }
        if (errorCount > 0) {
            return BuildImages.TEST_SUITE_ERROR;
        }
        if (failedCount > 0) {
            return BuildImages.TEST_SUITE_FAILED;
        }
        if (ignoredCount > 0) {
            return BuildImages.TEST_SUITE_IGNORED;
        }
        if (passedCount > 0) {
            return BuildImages.TEST_SUITE_PASSED;
        }
        return BuildImages.TEST_SUITE;
    }

    public String getText(Object element) {
        if (element instanceof ITestSuite) {
            return ((ITestSuite)element).getLabel();
        }
        if (element instanceof ITestCase) {
            return ((ITestCase)element).getLabel();
        }
        return super.getText(element);
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text != null) {
            StyledString styledString = new StyledString(text);
            if (element instanceof ITestCase) {
                String duration = " " + DateUtil.getFormattedDurationShort((long)((ITestCase)element).getDuration(), (boolean)true);
                styledString.append(duration, StyledString.DECORATIONS_STYLER);
            }
            return styledString;
        }
        return new StyledString();
    }
}

