/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui;

import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.embedcdt.core.XpackUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Activator;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.ToolchainDefinition;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.ui.EclipseUiUtils;
import org.eclipse.embedcdt.ui.XpackBrowseDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class SetCrossCommandWizardPage
extends MBSCustomPage {
    private PersistentPreferences fPersistentPreferences;
    private DefaultPreferences fDefaultPreferences;
    private Composite fComposite;
    private boolean fFinish = false;
    private Text fPathTxt;
    private Combo fToolchainCombo;
    private int fSelectedToolchainIndex;
    private String fSelectedToolchainId;
    private String fSelectedToolchainName;
    private Button fXpackButton;
    private String[] fXpackNames;
    private String[] fXpackVersions;
    public static final String PAGE_ID = "org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.setCrossCommandWizardPage";
    public static final String CROSS_WIZARD = "wizard";
    public static final String CROSS_PROJECT_NAME = "projectName";
    public static final String CROSS_TOOLCHAIN_ID = "toolchain.id";
    public static final String CROSS_TOOLCHAIN_NAME = "toolchain.name";
    public static final String CROSS_TOOLCHAIN_PATH = "toolchain.path";

    public SetCrossCommandWizardPage() {
        this.pageID = PAGE_ID;
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_PATH, (Object)"");
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_ID, (Object)"");
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_NAME, (Object)"");
        this.fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
        this.fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
    }

    protected boolean isCustomPageComplete() {
        this.updateProjectNameProperty();
        return this.fFinish;
    }

    public String getName() {
        return Messages.SetCrossCommandWizardPage_name;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_WIZARD, (Object)newWizard);
    }

    public void createControl(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(4, false));
        GridData layoutData = new GridData();
        this.fComposite.setLayoutData((Object)layoutData);
        Label toolchainLbl = new Label(this.fComposite, 0);
        toolchainLbl.setText(Messages.SetCrossCommandWizardPage_toolchain);
        this.fToolchainCombo = new Combo(this.fComposite, 4);
        layoutData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.fToolchainCombo.setLayoutData((Object)layoutData);
        String[] toolchains = new String[ToolchainDefinition.getSize()];
        int i2 = 0;
        while (i2 < ToolchainDefinition.getSize()) {
            toolchains[i2] = ToolchainDefinition.getToolchain((int)i2).getFullName();
            ++i2;
        }
        this.fToolchainCombo.setItems(toolchains);
        this.fSelectedToolchainIndex = -1;
        try {
            this.fSelectedToolchainId = this.fPersistentPreferences.getToolchainId();
            if (!this.fSelectedToolchainId.isEmpty()) {
                try {
                    this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainById((String)this.fSelectedToolchainId);
                }
                catch (IndexOutOfBoundsException i2) {
                    // empty catch block
                }
            }
            if (this.fSelectedToolchainIndex == -1) {
                this.fSelectedToolchainName = this.fPersistentPreferences.getToolchainName();
                if (!this.fSelectedToolchainName.isEmpty()) {
                    try {
                        this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainByName((String)this.fSelectedToolchainName);
                    }
                    catch (IndexOutOfBoundsException i2) {}
                }
            }
        }
        catch (Exception i2) {
            // empty catch block
        }
        if (this.fSelectedToolchainIndex == -1) {
            this.fSelectedToolchainIndex = ToolchainDefinition.getDefault();
        }
        this.fSelectedToolchainId = ToolchainDefinition.getToolchain((int)this.fSelectedToolchainIndex).getId();
        this.fSelectedToolchainName = ToolchainDefinition.getToolchain((int)this.fSelectedToolchainIndex).getName();
        this.fXpackNames = this.fDefaultPreferences.getToolchainXpackNames(this.fSelectedToolchainId, this.fSelectedToolchainName);
        this.fXpackVersions = XpackUtils.getPackVersions((String[])this.fXpackNames);
        this.updateToolchainNameProperty();
        String toolchainSel = toolchains[this.fSelectedToolchainIndex];
        this.fToolchainCombo.setText(toolchainSel);
        this.fToolchainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetCrossCommandWizardPage.this.fSelectedToolchainIndex = SetCrossCommandWizardPage.this.fToolchainCombo.getSelectionIndex();
                SetCrossCommandWizardPage.this.fSelectedToolchainId = ToolchainDefinition.getToolchain((int)SetCrossCommandWizardPage.this.fSelectedToolchainIndex).getId();
                SetCrossCommandWizardPage.this.fSelectedToolchainName = ToolchainDefinition.getToolchain((int)SetCrossCommandWizardPage.this.fSelectedToolchainIndex).getName();
                SetCrossCommandWizardPage.this.updateToolchainNameProperty();
                String crossCommandPath = SetCrossCommandWizardPage.this.fPersistentPreferences.getToolchainPath(SetCrossCommandWizardPage.this.fSelectedToolchainId, SetCrossCommandWizardPage.this.fSelectedToolchainName, null);
                SetCrossCommandWizardPage.this.fPathTxt.setText(crossCommandPath);
                SetCrossCommandWizardPage.this.fXpackNames = SetCrossCommandWizardPage.this.fDefaultPreferences.getToolchainXpackNames(SetCrossCommandWizardPage.this.fSelectedToolchainId, SetCrossCommandWizardPage.this.fSelectedToolchainName);
                SetCrossCommandWizardPage.this.fXpackVersions = XpackUtils.getPackVersions((String[])SetCrossCommandWizardPage.this.fXpackNames);
                if (SetCrossCommandWizardPage.this.fXpackVersions.length > 0) {
                    SetCrossCommandWizardPage.this.fXpackButton.setEnabled(true);
                } else {
                    SetCrossCommandWizardPage.this.fXpackButton.setEnabled(false);
                }
            }
        });
        Label label = new Label(this.fComposite, 0);
        label.setText(Messages.SetCrossCommandWizardPage_path);
        this.fPathTxt = new Text(this.fComposite, 2052);
        String crossCommandPath = this.fPersistentPreferences.getToolchainPath(this.fSelectedToolchainId, this.fSelectedToolchainName, null);
        this.fPathTxt.setText(crossCommandPath);
        this.updatePathProperty();
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fPathTxt.setLayoutData((Object)layoutData);
        this.fPathTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SetCrossCommandWizardPage.this.updatePathProperty();
            }
        });
        Button browseButton = new Button(this.fComposite, 0);
        browseButton.setText(Messages.SetCrossCommandWizardPage_browse);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(SetCrossCommandWizardPage.this.fComposite.getShell(), 65536);
                String browsedDirectory = dirDialog.open();
                SetCrossCommandWizardPage.this.fPathTxt.setText(browsedDirectory);
            }
        });
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        browseButton.setLayoutData((Object)layoutData);
        this.fXpackButton = new Button(this.fComposite, 0);
        this.fXpackButton.setText("xPack...");
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        this.fXpackButton.setLayoutData((Object)layoutData);
        this.fXpackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetCrossCommandWizardPage.this.buttonPressed(event);
            }
        });
        if (this.fXpackVersions.length > 0) {
            this.fXpackButton.setEnabled(true);
        } else {
            this.fXpackButton.setEnabled(false);
        }
        Label message = new Label(this.fComposite, 0);
        layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        message.setLayoutData((Object)layoutData);
        message.setText(Messages.SetCrossCommandWizardPage_text);
    }

    private void buttonPressed(SelectionEvent e) {
        XpackBrowseDialog dlg = new XpackBrowseDialog(EclipseUiUtils.getShell(), this.fXpackVersions);
        if (dlg.open() == 0) {
            int index = dlg.getData();
            String version = this.fXpackVersions[index];
            String[] stringArray = this.fXpackNames;
            int n = this.fXpackNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                IPath path = XpackUtils.getPackPath((String)name).append(version);
                if (path.toFile().isDirectory() || (path = XpackUtils.getSysPackPath((String)name).append(version)).toFile().isDirectory()) {
                    path = path.append(".content").append("bin");
                    this.fPathTxt.setText(path.toString());
                    break;
                }
                ++n2;
            }
        }
    }

    public Control getControl() {
        return this.fComposite;
    }

    public String getDescription() {
        return Messages.SetCrossCommandWizardPage_description;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return this.wizard.getDefaultPageImage();
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        return Messages.SetCrossCommandWizardPage_title;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String title) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fFinish = true;
        }
        this.fComposite.setVisible(visible);
    }

    public void dispose() {
    }

    private void updatePathProperty() {
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_PATH, (Object)this.fPathTxt.getText());
    }

    private void updateToolchainNameProperty() {
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_ID, (Object)this.fSelectedToolchainId);
        MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_TOOLCHAIN_NAME, (Object)this.fSelectedToolchainName);
    }

    private void updateProjectNameProperty() {
        String name = SetCrossCommandWizardPage.getProjectName(this.getWizard());
        if (name != null) {
            MBSCustomPageManager.addPageProperty((String)PAGE_ID, (String)CROSS_PROJECT_NAME, (Object)name);
        }
    }

    public static String getProjectName(IWizard wizard) {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = wizard.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage wizardPage = iWizardPageArray[n2];
            if (wizardPage instanceof WizardNewProjectCreationPage) {
                return ((WizardNewProjectCreationPage)wizardPage).getProjectName();
            }
            ++n2;
        }
        return null;
    }
}

