/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.plain.histograms;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.internal.hppc.LongIntHashMap;
import org.apache.lucene.sandbox.facet.plain.histograms.HistogramCollector;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.util.NumericUtils;

class PointTreeBulkCollector {
    PointTreeBulkCollector() {
    }

    private static Function<byte[], Long> bytesToLong(int numBytes) {
        if (numBytes == 8) {
            return a -> NumericUtils.sortableBytesToLong((byte[])a, (int)0);
        }
        if (numBytes == 4) {
            return a -> NumericUtils.sortableBytesToInt((byte[])a, (int)0);
        }
        return null;
    }

    static boolean canCollectEfficiently(PointValues pointValues, long bucketWidth) throws IOException {
        if (pointValues == null || pointValues.getNumDimensions() != 1 || (long)pointValues.getDocCount() != pointValues.size()) {
            return false;
        }
        Function<byte[], Long> byteToLong = PointTreeBulkCollector.bytesToLong(pointValues.getBytesPerDimension());
        if (byteToLong == null) {
            return false;
        }
        long leafMinBucket = Math.floorDiv((long)byteToLong.apply(pointValues.getMinPackedValue()), bucketWidth);
        long leafMaxBucket = Math.floorDiv((long)byteToLong.apply(pointValues.getMaxPackedValue()), bucketWidth);
        return pointValues.size() / 512L >= leafMaxBucket - leafMinBucket;
    }

    static void collect(PointValues pointValues, PointRangeQuery prq, long bucketWidth, LongIntHashMap collectorCounts, int maxBuckets) throws IOException {
        Function<byte[], Long> byteToLong = PointTreeBulkCollector.bytesToLong(pointValues.getBytesPerDimension());
        long leafMin = byteToLong.apply(pointValues.getMinPackedValue());
        long leafMax = byteToLong.apply(pointValues.getMaxPackedValue());
        if (prq != null) {
            leafMin = Math.max(leafMin, byteToLong.apply(prq.getLowerPoint()));
            leafMax = Math.min(leafMax, byteToLong.apply(prq.getUpperPoint()));
        }
        BucketManager collector = new BucketManager(collectorCounts, leafMin, leafMax + 1L, bucketWidth, byteToLong, maxBuckets);
        PointValues.IntersectVisitor visitor = PointTreeBulkCollector.getIntersectVisitor(collector);
        PointTreeBulkCollector.intersectWithRanges(visitor, pointValues.getPointTree(), collector);
        collector.finalizePreviousBucket(null);
    }

    private static void intersectWithRanges(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, BucketManager collector) throws IOException {
        PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r) {
            case CELL_INSIDE_QUERY: {
                collector.countNode((int)pointTree.size());
                break;
            }
            case CELL_CROSSES_QUERY: {
                if (pointTree.moveToChild()) {
                    do {
                        PointTreeBulkCollector.intersectWithRanges(visitor, pointTree, collector);
                    } while (pointTree.moveToSibling());
                    pointTree.moveToParent();
                    break;
                }
                pointTree.visitDocValues(visitor);
                break;
            }
        }
    }

    private static PointValues.IntersectVisitor getIntersectVisitor(final BucketManager collector) {
        return new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                throw new UnsupportedOperationException("This IntersectVisitor does not perform any actions on a docID=" + docID + " node being visited");
            }

            public void visit(int docID, byte[] packedValue) throws IOException {
                if (!collector.withinUpperBound(packedValue)) {
                    collector.finalizePreviousBucket(packedValue);
                    if (!collector.withinUpperBound(packedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (collector.withinRange(packedValue)) {
                    collector.count();
                }
            }

            public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                if (!collector.withinUpperBound(packedValue)) {
                    collector.finalizePreviousBucket(packedValue);
                    if (!collector.withinUpperBound(packedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (collector.withinRange(packedValue)) {
                    int doc = iterator.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        collector.count();
                        doc = iterator.nextDoc();
                    }
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (!collector.withinUpperBound(minPackedValue)) {
                    collector.finalizePreviousBucket(minPackedValue);
                    if (!collector.withinUpperBound(minPackedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (!collector.withinLowerBound(maxPackedValue)) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (collector.withinRange(minPackedValue) && collector.withinRange(maxPackedValue)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        };
    }

    private static class BucketManager {
        private final LongIntHashMap collectorCounts;
        private int counter = 0;
        private long startValue;
        private long maxValue;
        private long endValue;
        private int nonZeroBuckets = 0;
        private int maxBuckets;
        private Function<byte[], Long> byteToLong;
        private long bucketWidth;

        public BucketManager(LongIntHashMap collectorCounts, long minValue, long maxValue, long bucketWidth, Function<byte[], Long> byteToLong, int maxBuckets) {
            this.collectorCounts = collectorCounts;
            this.bucketWidth = bucketWidth;
            this.startValue = minValue;
            this.endValue = Math.min((Math.floorDiv(this.startValue, bucketWidth) + 1L) * bucketWidth, maxValue);
            this.maxValue = maxValue;
            this.byteToLong = byteToLong;
            this.maxBuckets = maxBuckets;
        }

        private void count() {
            ++this.counter;
        }

        private void countNode(int count) {
            this.counter += count;
        }

        private void finalizePreviousBucket(byte[] packedValue) {
            if (this.counter > 0) {
                this.collectorCounts.addTo(Math.floorDiv(this.startValue, this.bucketWidth), this.counter);
                ++this.nonZeroBuckets;
                this.counter = 0;
                HistogramCollector.checkMaxBuckets(this.nonZeroBuckets, this.maxBuckets);
            }
            if (packedValue != null) {
                this.startValue = this.byteToLong.apply(packedValue);
                this.endValue = Math.min((Math.floorDiv(this.startValue, this.bucketWidth) + 1L) * this.bucketWidth, this.maxValue);
            }
        }

        private boolean withinLowerBound(byte[] value) {
            return this.byteToLong.apply(value) >= this.startValue;
        }

        private boolean withinUpperBound(byte[] value) {
            return this.byteToLong.apply(value) < this.endValue;
        }

        private boolean withinRange(byte[] value) {
            return this.withinLowerBound(value) && this.withinUpperBound(value);
        }
    }
}

