/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DsfExecutable;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.StackTraceWrapper;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class DefaultDsfExecutor
extends ScheduledThreadPoolExecutor
implements DsfExecutor {
    private static int fgInstanceCounter = 0;
    private String fName;
    protected static boolean DEBUG_EXECUTOR = false;
    protected static String DEBUG_EXECUTOR_NAME = "";
    protected static boolean ASSERTIONS_ENABLED = false;
    static Map<Thread, DefaultDsfExecutor> fThreadToExecutorMap;
    TracingWrapper fCurrentlyExecuting;
    int fSequenceCounter;

    static {
        DEBUG_EXECUTOR = DsfPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/executor"));
        String string = DEBUG_EXECUTOR_NAME = DsfPlugin.DEBUG ? Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/executorName") : "";
        if (!$assertionsDisabled) {
            ASSERTIONS_ENABLED = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        fThreadToExecutorMap = new HashMap<Thread, DefaultDsfExecutor>();
    }

    public DefaultDsfExecutor() {
        this("DSF Executor");
    }

    public DefaultDsfExecutor(String name) {
        super(1, new DsfThreadFactory(name + " - " + fgInstanceCounter++));
        this.fName = name;
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            this.prestartAllCoreThreads();
            fThreadToExecutorMap.put(((DsfThreadFactory)this.getThreadFactory()).fThread, this);
        }
    }

    @Override
    public boolean isInExecutorThread() {
        return Thread.currentThread().equals(((DsfThreadFactory)this.getThreadFactory()).fThread);
    }

    public int getCurrentExecutionDepth() {
        if (this.fCurrentlyExecuting != null) {
            return this.fCurrentlyExecuting.fDepth;
        }
        return -1;
    }

    protected String getName() {
        return this.fName;
    }

    static void logException(Throwable t) {
        DsfPlugin plugin = DsfPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        ILog log = plugin.getLog();
        if (log != null) {
            log.log((IStatus)new Status(4, "org.eclipse.cdt.dsf", -1, "Uncaught exception in DSF executor thread", t));
        }
        if (ASSERTIONS_ENABLED) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(512);
            PrintStream printStream = new PrintStream(outStream);
            try {
                printStream.write("Uncaught exception in session executor thread: ".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t.printStackTrace(new PrintStream(outStream));
            System.err.println(outStream.toString());
        }
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if ((DEBUG_EXECUTOR || ASSERTIONS_ENABLED) && !(callable instanceof TracingWrapper)) {
            callable = new TracingWrapperCallable<V>(callable);
        }
        return super.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if ((DEBUG_EXECUTOR || ASSERTIONS_ENABLED) && !(command instanceof TracingWrapper)) {
            command = new TracingWrapperRunnable(command);
        }
        return super.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command);
        }
        return super.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command);
        }
        return super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command);
        }
        super.execute(command);
    }

    @Override
    public Future<?> submit(Runnable command) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command);
        }
        return super.submit(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            callable = new TracingWrapperCallable<T>(callable);
        }
        return super.submit(callable);
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        if (DEBUG_EXECUTOR || ASSERTIONS_ENABLED) {
            command = new TracingWrapperRunnable(command);
        }
        return super.submit(command, result);
    }

    @Override
    public void shutdown() {
        if (DEBUG_EXECUTOR && ("".equals(DEBUG_EXECUTOR_NAME) || this.fName.equals(DEBUG_EXECUTOR_NAME))) {
            DsfPlugin.debug(DsfPlugin.getDebugTime() + " Executor (" + ((DsfThreadFactory)this.getThreadFactory()).fThreadName + ") is being shut down. Already submitted tasks will be executed, new ones will not.");
        }
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (DEBUG_EXECUTOR && ("".equals(DEBUG_EXECUTOR_NAME) || this.fName.equals(DEBUG_EXECUTOR_NAME))) {
            DsfPlugin.debug(DsfPlugin.getDebugTime() + " Executor (" + ((DsfThreadFactory)this.getThreadFactory()).fThreadName + ") is being shut down. No queued or new tasks will be executed, and will attempt to cancel active ones.");
        }
        return super.shutdownNow();
    }

    @Override
    protected void terminated() {
        fThreadToExecutorMap.remove(((DsfThreadFactory)this.getThreadFactory()).fThread);
        super.terminated();
    }

    static class DsfThreadFactory
    implements ThreadFactory {
        private String fThreadName;
        Thread fThread;

        DsfThreadFactory(String name) {
            this.fThreadName = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            assert (this.fThread == null);
            this.fThread = new Thread(new ThreadGroup(this.fThreadName), r, this.fThreadName, 0L);
            return this.fThread;
        }
    }

    abstract class TracingWrapper {
        int fSequenceNumber = -1;
        int fDepth = 0;
        StackTraceWrapper fSubmittedAt = null;
        TracingWrapper fSubmittedBy = null;
        private final String[] SUBMITTER_METHOD_NAMES = new String[]{"execute", "submit", "schedule", "scheduleAtFixedRate", "scheduleWithFixedDelay"};

        TracingWrapper() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int frameIgnoreCount = 1;
            String executorClassName = this.getClass().getEnclosingClass().getSimpleName();
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = stackTrace.length;
            int n2 = 0;
            block0: while (n2 < n) {
                StackTraceElement frame = stackTraceElementArray[n2];
                String framestr = frame.toString();
                String[] stringArray = this.SUBMITTER_METHOD_NAMES;
                int n3 = this.SUBMITTER_METHOD_NAMES.length;
                int n4 = 0;
                while (n4 < n3) {
                    String methodName = stringArray[n4];
                    if (framestr.contains(executorClassName + "." + methodName + "(")) break block0;
                    ++n4;
                }
                ++frameIgnoreCount;
                ++n2;
            }
            if (frameIgnoreCount == stackTrace.length) {
                frameIgnoreCount = 0;
            }
            frameIgnoreCount = Math.min(frameIgnoreCount, stackTrace.length);
            this.fSubmittedAt = new StackTraceWrapper(new StackTraceElement[stackTrace.length - frameIgnoreCount]);
            if (this.fSubmittedAt.fStackTraceElements.length > 0) {
                System.arraycopy(stackTrace, frameIgnoreCount, this.fSubmittedAt.fStackTraceElements, 0, this.fSubmittedAt.fStackTraceElements.length);
            }
            if (DefaultDsfExecutor.this.isInExecutorThread() && DefaultDsfExecutor.this.fCurrentlyExecuting != null) {
                this.fSubmittedBy = DefaultDsfExecutor.this.fCurrentlyExecuting;
            }
        }

        void traceExecution() {
            this.fSequenceNumber = DefaultDsfExecutor.this.fSequenceCounter++;
            this.fDepth = this.fSubmittedBy == null ? 0 : this.fSubmittedBy.fDepth + 1;
            DefaultDsfExecutor.this.fCurrentlyExecuting = this;
            if (DEBUG_EXECUTOR && ("".equals(DEBUG_EXECUTOR_NAME) || DefaultDsfExecutor.this.fName.equals(DEBUG_EXECUTOR_NAME))) {
                int submittedBySeqNum;
                StringBuilder traceBuilder = new StringBuilder();
                traceBuilder.append(DsfPlugin.getDebugTime());
                traceBuilder.append(' ');
                traceBuilder.append("DSF execution #");
                traceBuilder.append(this.fSequenceNumber);
                traceBuilder.append(". Executor is (");
                traceBuilder.append(((DsfThreadFactory)DefaultDsfExecutor.this.getThreadFactory()).fThreadName);
                traceBuilder.append(')');
                Object executable = this.getExecutable();
                traceBuilder.append("\n\tExecutable detail: \n\t\ttype = ");
                Class<?> execClass = executable.getClass();
                traceBuilder.append(execClass.isAnonymousClass() ? execClass.getSuperclass().getName() : execClass.getName());
                String refstr = LoggingUtils.toString(executable, false);
                String tostr = LoggingUtils.trimTrailingNewlines(executable.toString());
                traceBuilder.append("\n\t\t");
                traceBuilder.append("instance = ").append(refstr);
                if (!tostr.equals(refstr)) {
                    traceBuilder.append(" [");
                    traceBuilder.append(tostr);
                    traceBuilder.append(']');
                }
                StackTraceElement[] createdAtStack = null;
                StackTraceElement[] submittedAtStack = this.fSubmittedAt == null ? null : this.fSubmittedAt.fStackTraceElements;
                int createdBySeqNum = Integer.MIN_VALUE;
                int n = submittedBySeqNum = this.fSubmittedBy == null ? Integer.MIN_VALUE : this.fSubmittedBy.fSequenceNumber;
                if (executable instanceof DsfExecutable) {
                    DsfExecutable dsfExecutable = (DsfExecutable)executable;
                    createdAtStack = dsfExecutable.fCreatedAt == null ? null : dsfExecutable.fCreatedAt.fStackTraceElements;
                    createdBySeqNum = dsfExecutable.fCreatedBy == null ? Integer.MIN_VALUE : dsfExecutable.fCreatedBy.fSequenceNumber;
                }
                boolean canConsolidate = false;
                if (createdBySeqNum == submittedBySeqNum && createdAtStack != null && submittedAtStack != null && (createdAtStack.length == submittedAtStack.length || createdAtStack.length >= 3 && submittedAtStack.length >= 3)) {
                    canConsolidate = true;
                    int count = Math.min(createdAtStack.length, 3);
                    int i = 0;
                    while (i < count) {
                        if (createdAtStack[i].toString().compareTo(submittedAtStack[i].toString()) != 0) {
                            canConsolidate = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (canConsolidate) {
                    traceBuilder.append("\n\t\tcreated and submitted");
                    if (createdBySeqNum != Integer.MIN_VALUE) {
                        traceBuilder.append(" by #");
                        traceBuilder.append(createdBySeqNum);
                    }
                    if (createdAtStack != null) {
                        traceBuilder.append(" at:");
                        i = 0;
                        while (i < createdAtStack.length && i < 3) {
                            traceBuilder.append("\n\t\t\t");
                            traceBuilder.append(createdAtStack[i].toString());
                            ++i;
                        }
                    }
                } else {
                    if (createdAtStack != null || createdBySeqNum != Integer.MIN_VALUE) {
                        traceBuilder.append("\n\t\tcreated  ");
                        if (createdBySeqNum != Integer.MIN_VALUE) {
                            traceBuilder.append(" by #");
                            traceBuilder.append(createdBySeqNum);
                        }
                        if (createdAtStack != null) {
                            traceBuilder.append(" at:");
                            i = 0;
                            while (i < createdAtStack.length && i < 3) {
                                traceBuilder.append("\n\t\t\t");
                                traceBuilder.append(createdAtStack[i].toString());
                                ++i;
                            }
                        }
                    }
                    traceBuilder.append("\n\t\tsubmitted");
                    if (this.fSubmittedBy != null) {
                        traceBuilder.append(" by #");
                        traceBuilder.append(this.fSubmittedBy.fSequenceNumber);
                    }
                    traceBuilder.append(" at:");
                    i = 0;
                    while (i < this.fSubmittedAt.fStackTraceElements.length && i < 3) {
                        traceBuilder.append("\n\t\t\t");
                        traceBuilder.append(this.fSubmittedAt.fStackTraceElements[i].toString());
                        ++i;
                    }
                }
                DsfPlugin.debug(traceBuilder.toString());
            }
        }

        protected abstract Object getExecutable();
    }

    public class TracingWrapperCallable<T>
    extends TracingWrapper
    implements Callable<T> {
        final Callable<T> fCallable;

        @Deprecated
        public TracingWrapperCallable(Callable<T> callable, int frameIgnoreCount) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.fCallable = callable;
        }

        public TracingWrapperCallable(Callable<T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.fCallable = callable;
        }

        @Override
        protected Object getExecutable() {
            return this.fCallable;
        }

        @Override
        public T call() throws Exception {
            this.traceExecution();
            return this.fCallable.call();
        }
    }

    class TracingWrapperRunnable
    extends TracingWrapper
    implements Runnable {
        final Runnable fRunnable;

        public TracingWrapperRunnable(Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.fRunnable = runnable;
            if (DEBUG_EXECUTOR && this.fRunnable instanceof DsfExecutable) {
                assert (!((DsfExecutable)((Object)this.fRunnable)).getSubmitted()) : "Executable was previously executed.";
                ((DsfExecutable)((Object)this.fRunnable)).setSubmitted();
            }
        }

        @Override
        protected Object getExecutable() {
            return this.fRunnable;
        }

        @Override
        public void run() {
            this.traceExecution();
            try {
                this.fRunnable.run();
            }
            catch (RuntimeException e) {
                DefaultDsfExecutor.logException(e);
                throw e;
            }
            catch (Error e) {
                DefaultDsfExecutor.logException(e);
                throw e;
            }
        }
    }
}

