/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IContainerSnapshot;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.ide.undo.AbstractCreateResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class CreateFileOperation
extends AbstractCreateResourcesOperation {
    public CreateFileOperation(IFile fileHandle, URI linkLocation, InputStream contents, String label) {
        super((IResourceSnapshot<? extends IResource>[])null, label);
        IResourceSnapshot resourceDescription;
        if (fileHandle.getParent().exists()) {
            resourceDescription = ResourceSnapshotFactory.fromFileDetails((IFile)fileHandle, (URI)linkLocation, (InputStream)contents);
        } else {
            IContainerSnapshot containerDescription = ResourceSnapshotFactory.fromContainer((IContainer)fileHandle.getParent());
            IResourceSnapshot fileDescription = ResourceSnapshotFactory.fromFileDetails((IFile)fileHandle, (URI)linkLocation, (InputStream)contents);
            WorkspaceUndoUtil.getFirstLeafFolder((IContainerSnapshot<? extends IContainer>)containerDescription).addMember(fileDescription);
            resourceDescription = containerDescription;
        }
        this.setResourceDescriptions(new IResourceSnapshot[]{resourceDescription});
    }

    @Override
    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = super.computeExecutionStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(false);
        }
        return status;
    }
}

