/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStore;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.state.ContextStateManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class ContextStatePersistenceHandler {
    public static final String FILE_NAME = "context-state.xml";

    public void activated(IInteractionContext context) {
        if (!this.isOnUiThread()) {
            return;
        }
        this.getStateManager().saveDefaultState();
        ICommonStorable storable = this.getStorable(context.getHandleIdentifier());
        if (storable != null) {
            try {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream in = storable.exists(FILE_NAME) ? storable.read(FILE_NAME, null) : null;){
                        this.getStateManager().restoreState(context, in);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", NLS.bind((String)"Unexpected error restoring the context state for {0}", (Object)context.getHandleIdentifier()), (Throwable)e));
                    storable.release();
                }
            }
            finally {
                storable.release();
            }
        }
    }

    public void clear(ITask task) {
        if (!this.isOnUiThread()) {
            return;
        }
        ICommonStorable storable = this.getStorable(task);
        try {
            try {
                storable.delete(FILE_NAME);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", NLS.bind((String)"Unexpected error deleting the context state for {0}", (Object)task.getHandleIdentifier()), (Throwable)e));
                storable.release();
            }
        }
        finally {
            storable.release();
        }
    }

    public void clear(String contextHandle, boolean activeContext) {
        this.getStateManager().clearState(contextHandle, activeContext);
    }

    public void copy(ITask sourceTask, ITask targetTask) {
        if (!this.isOnUiThread()) {
            return;
        }
        this.copyState(sourceTask, targetTask, true);
    }

    public void deactivated(IInteractionContext context) {
        if (!this.isOnUiThread()) {
            return;
        }
        this.save(context, true);
        this.getStateManager().restoreDefaultState();
    }

    public void merge(ITask sourceTask, ITask targetTask) {
        if (!this.isOnUiThread()) {
            return;
        }
        this.copyState(sourceTask, targetTask, false);
    }

    public void save(IInteractionContext context) {
        this.save(context, false);
    }

    public void save(IInteractionContext context, boolean allowModifications) {
        if (!this.isOnUiThread()) {
            return;
        }
        ICommonStorable storable = this.getStorable(context.getHandleIdentifier());
        if (storable != null) {
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (OutputStream out = storable.write(FILE_NAME, null);){
                        this.getStateManager().saveState(context, out, allowModifications);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", NLS.bind((String)"Unexpected error saving the context state for {0}", (Object)context.getHandleIdentifier()), (Throwable)e));
                    storable.release();
                }
            }
            finally {
                storable.release();
            }
        }
    }

    public void saved(ITask task) {
        if (!this.isOnUiThread()) {
            return;
        }
        IInteractionContext context = ContextCore.getContextManager().getActiveContext();
        if (context != null && task.getHandleIdentifier().equals(context.getHandleIdentifier())) {
            this.save(context);
        }
    }

    private void copyState(ITask sourceTask, ITask targetTask, boolean overwrite) {
        block8: {
            ICommonStorable targetStorable = this.getStorable(targetTask);
            try {
                try {
                    if (!overwrite && targetStorable.exists(FILE_NAME)) break block8;
                    ICommonStorable sourceStorable = this.getStorable(sourceTask);
                    try {
                        this.copyStateFile(sourceStorable, targetStorable, FILE_NAME);
                    }
                    finally {
                        sourceStorable.release();
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", NLS.bind((String)"Unexpected error saving the context state for {0}", (Object)targetTask.getHandleIdentifier()), (Throwable)e));
                    targetStorable.release();
                }
            }
            finally {
                targetStorable.release();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyStateFile(ICommonStorable sourceStorable, ICommonStorable targetStorable, String handle) throws CoreException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedInputStream in = new BufferedInputStream(sourceStorable.read(handle, null));
            try {
                int count;
                BufferedOutputStream out = new BufferedOutputStream(targetStorable.write(handle, null));
                byte[] buffer = new byte[4096];
                while (true) {
                    if ((count = in.read(buffer)) != -1) break block13;
                    if (out == null) break block14;
                    break;
                }
                {
                    catch (Throwable throwable2) {
                        if (out == null) throw throwable2;
                        out.close();
                        throw throwable2;
                    }
                }
                {
                    block13: {
                        block14: {
                            out.close();
                        }
                        if (in == null) return;
                        in.close();
                        return;
                    }
                    out.write(buffer, 0, count);
                    continue;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private ContextStateManager getStateManager() {
        return ContextUiPlugin.getDefault().getStateManager();
    }

    private ICommonStorable getStorable(ITask task) {
        return ((TaskContextStore)TasksUiPlugin.getContextStore()).getStorable(task);
    }

    private ICommonStorable getStorable(String contextHandle) {
        ITask task = TasksUi.getRepositoryModel().getTask(contextHandle);
        return task != null ? this.getStorable(task) : null;
    }

    private boolean isOnUiThread() {
        return Display.getCurrent() != null;
    }
}

