/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.core.IOptionDefaultValueGenerator;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionReference
implements IOption {
    private List<String> builtIns;
    private String command;
    private IOption option;
    private ToolReference owner;
    private Object value;
    private boolean resolved = true;

    public OptionReference(ToolReference owner, IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.owner = owner;
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, IOption option) {
        this.owner = owner;
        this.option = option;
        owner.addOptionReference(this);
    }

    public OptionReference(ToolReference owner, Element element) {
        int optValType;
        this.owner = owner;
        try {
            this.option = owner.getTool().getOptionById(element.getAttribute("id"));
        }
        catch (NullPointerException e) {
            this.option = null;
        }
        if (this.option == null) {
            return;
        }
        try {
            optValType = this.option.getValueType();
        }
        catch (BuildException e) {
            return;
        }
        owner.addOptionReference(this);
        switch (optValType) {
            case 0: {
                this.value = Boolean.valueOf(element.getAttribute("defaultValue"));
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                this.value = element.getAttribute("defaultValue");
                break;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -5: 
            case -4: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                ArrayList<String> valueList = new ArrayList<String>();
                NodeList nodes = element.getElementsByTagName("listOptionValue");
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        Boolean isBuiltIn = Boolean.valueOf(((Element)node).getAttribute("builtIn"));
                        if (isBuiltIn.booleanValue()) {
                            this.getBuiltInList().add(((Element)node).getAttribute("value"));
                        } else {
                            valueList.add(((Element)node).getAttribute("value"));
                        }
                    }
                    ++i;
                }
                this.value = valueList;
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            int optValType;
            this.resolved = true;
            IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
            this.option = this.owner.getTool().getOptionById(element.getAttribute("id"));
            if (this.option == null) {
                this.resolved = false;
                return;
            }
            if (this.option instanceof Option) {
                ((Option)this.option).resolveReferences();
            } else if (this.option instanceof OptionReference) {
                ((OptionReference)this.option).resolveReferences();
            }
            try {
                optValType = this.option.getValueType();
            }
            catch (BuildException e) {
                return;
            }
            switch (optValType) {
                case 0: {
                    this.value = Boolean.valueOf(element.getAttribute("defaultValue"));
                    break;
                }
                case 2: {
                    this.value = element.getAttribute("defaultValue");
                    break;
                }
                case 1: 
                case 12: {
                    String temp = element.getAttribute("defaultValue");
                    if (temp == null) break;
                    this.value = temp;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    IManagedConfigElement[] valueElements;
                    ArrayList<String> valueList = new ArrayList<String>();
                    IManagedConfigElement[] iManagedConfigElementArray = valueElements = element.getChildren("listOptionValue");
                    int n = valueElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IManagedConfigElement valueElement = iManagedConfigElementArray[n2];
                        Boolean isBuiltIn = Boolean.valueOf(valueElement.getAttribute("builtIn"));
                        if (isBuiltIn.booleanValue()) {
                            this.getBuiltInList().add(SafeStringInterner.safeIntern((String)valueElement.getAttribute("value")));
                        } else {
                            valueList.add(SafeStringInterner.safeIntern((String)valueElement.getAttribute("value")));
                        }
                        ++n2;
                    }
                    this.value = valueList;
                }
            }
        }
    }

    public void serialize(Document doc, Element element) {
        int optValType;
        element.setAttribute("id", this.option.getId());
        try {
            optValType = this.option.getValueType();
        }
        catch (BuildException e) {
            return;
        }
        switch (optValType) {
            case 0: {
                element.setAttribute("defaultValue", ((Boolean)this.value).toString());
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                element.setAttribute("defaultValue", (String)this.value);
                break;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -5: 
            case -4: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                Element valueElement;
                ArrayList stringList = (ArrayList)this.value;
                for (String val : stringList) {
                    valueElement = doc.createElement("listOptionValue");
                    valueElement.setAttribute("value", val);
                    valueElement.setAttribute("builtIn", "false");
                    element.appendChild(valueElement);
                }
                if (this.builtIns == null) break;
                for (String builtIn : this.builtIns) {
                    valueElement = doc.createElement("listOptionValue");
                    valueElement.setAttribute("value", builtIn);
                    valueElement.setAttribute("builtIn", "true");
                    element.appendChild(valueElement);
                }
                break;
            }
        }
    }

    @Override
    public IOptionContextData getOptionContextData(IHoldsOptions holder) {
        return this.option.getOptionContextData(holder);
    }

    @Override
    public String[] getApplicableValues() {
        return this.option.getApplicableValues();
    }

    @Override
    public IOptionCategory getCategory() {
        return this.option.getCategory();
    }

    @Override
    public String getCommand() {
        return this.option.getCommand();
    }

    @Override
    public IOptionCommandGenerator getCommandGenerator() {
        return this.option.getCommandGenerator();
    }

    @Override
    public String getCommandFalse() {
        return this.option.getCommandFalse();
    }

    @Override
    public String getToolTip() {
        return this.option.getToolTip();
    }

    @Override
    public String getContextId() {
        return this.option.getContextId();
    }

    @Override
    public String[] getDefinedSymbols() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 5) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String getEnumCommand(String id) {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String command = this.option.getEnumCommand(id);
                return command;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getCommand(String id) throws BuildException {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String command = this.option.getCommand(id);
                return command;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getEnumName(String id) {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String name = this.option.getEnumName(id);
                return name;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getName(String id) throws BuildException {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String name = this.option.getName(id);
                return name;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getEnumeratedId(String name) {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String id = this.option.getEnumeratedId(name);
                return id;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getId(String name) throws BuildException {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                String id = this.option.getId(name);
                return id;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getId() {
        return this.option.getId();
    }

    @Override
    public String getBaseId() {
        return this.option.getBaseId();
    }

    @Override
    public String[] getIncludePaths() throws BuildException {
        if (this.value == null) {
            return this.option.getIncludePaths();
        }
        if (this.getValueType() == 4) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String[] getLibraries() throws BuildException {
        if (this.value == null) {
            return this.option.getLibraries();
        }
        if (this.getValueType() == 6) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String[] getLibraryFiles() throws BuildException {
        if (this.value == null) {
            return this.option.getLibraryFiles();
        }
        if (this.getValueType() == 10) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String[] getLibraryPaths() throws BuildException {
        if (this.value == null) {
            return this.option.getLibraryPaths();
        }
        if (this.getValueType() == 9) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String getName() {
        return this.option.getName();
    }

    @Override
    public boolean getBooleanValue() throws BuildException {
        if (this.value == null) {
            return this.option.getBooleanValue();
        }
        if (this.getValueType() == 0) {
            Boolean bool = (Boolean)this.value;
            return bool;
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public int getBrowseType() {
        return this.option.getBrowseType();
    }

    @Override
    public String getBrowseFilterPath() {
        return this.option.getBrowseFilterPath();
    }

    @Override
    public String[] getBrowseFilterExtensions() {
        return this.option.getBrowseFilterExtensions();
    }

    private List<String> getBuiltInList() {
        if (this.builtIns == null) {
            this.builtIns = new ArrayList<String>();
        }
        return this.builtIns;
    }

    @Override
    public String[] getBuiltIns() {
        ArrayList<String> answer = new ArrayList<String>();
        if (this.builtIns != null) {
            answer.addAll(this.builtIns);
        }
        if (this.option != null) {
            String[] optionBuiltIns = this.option.getBuiltIns();
            int index = 0;
            while (index < optionBuiltIns.length) {
                if (!answer.contains(optionBuiltIns[index])) {
                    answer.add(optionBuiltIns[index]);
                }
                ++index;
            }
        }
        return answer.toArray(new String[answer.size()]);
    }

    public IOption getOption() {
        if (!this.resolved) {
            this.resolveReferences();
        }
        return this.option;
    }

    @Override
    public String getSelectedEnum() throws BuildException {
        if (this.value == null) {
            return this.option.getSelectedEnum();
        }
        if (this.getValueType() == 1) {
            return (String)this.value;
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String[] getStringListValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringListValue();
        }
        if (this.getValueType() == 3) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public String getStringValue() throws BuildException {
        if (this.value == null) {
            return this.option.getStringValue();
        }
        if (this.getValueType() == 2) {
            return (String)this.value;
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public IBuildObject getParent() {
        return this.owner;
    }

    @Override
    public IHoldsOptions getOptionHolder() {
        return this.owner;
    }

    public ToolReference getToolReference() {
        return this.owner;
    }

    @Override
    public String[] getUserObjects() throws BuildException {
        if (this.value == null) {
            return this.option.getDefinedSymbols();
        }
        if (this.getValueType() == 7) {
            ArrayList list = (ArrayList)this.value;
            return list.toArray(new String[list.size()]);
        }
        throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
    }

    @Override
    public int getValueType() {
        int optValType;
        try {
            optValType = this.option.getValueType();
        }
        catch (BuildException e) {
            return -1;
        }
        return optValType;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public boolean references(IOption target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.option instanceof OptionReference) {
            return ((OptionReference)this.option).references(target);
        }
        return this.option.equals(target);
    }

    @Override
    public void setValue(boolean value) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
    }

    @Override
    public void setValue(String value) throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1 && this.getValueType() != 12) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
    }

    @Override
    public void setValue(String[] value) throws BuildException {
        if (this.getValueType() != 3 && this.getValueType() != 4 && this.getValueType() != 5 && this.getValueType() != 6 && this.getValueType() != 7 && this.getValueType() != 8 && this.getValueType() != 9 && this.getValueType() != 10 && this.getValueType() != 11 && this.getValueType() != -4 && this.getValueType() != -5 && this.getValueType() != -8 && this.getValueType() != -9 && this.getValueType() != -10 && this.getValueType() != -11) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = new ArrayList<String>(Arrays.asList(value));
    }

    public String toString() {
        Object answer = "";
        if (this.option != null) {
            answer = (String)answer + "Reference to " + this.option.getName();
        }
        if (((String)answer).length() > 0) {
            return answer;
        }
        return super.toString();
    }

    @Override
    public boolean isExtensionElement() {
        return false;
    }

    @Override
    public void setValue(Object v) {
        this.value = v;
    }

    @Override
    public void setValueType(int type) {
    }

    @Override
    public Object getDefaultValue() {
        return this.value;
    }

    @Override
    public IOptionDefaultValueGenerator getDefaultValueGenerator() {
        return this.option.getDefaultValueGenerator();
    }

    @Override
    public void setDefaultValue(Object v) {
    }

    @Override
    public IOption getSuperClass() {
        return null;
    }

    @Override
    public int getResourceFilter() {
        return 0;
    }

    @Override
    public IOptionApplicability getApplicabilityCalculator() {
        return this.option.getApplicabilityCalculator();
    }

    @Override
    public void setResourceFilter(int filter) {
    }

    @Override
    public void setBrowseType(int type) {
    }

    @Override
    public void setBrowseFilterPath(String path) {
    }

    @Override
    public void setBrowseFilterExtensions(String[] extensions) {
    }

    @Override
    public void setCategory(IOptionCategory category) {
    }

    @Override
    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
        }
    }

    @Override
    public void setCommandFalse(String cmd) {
    }

    @Override
    public void setToolTip(String tooltip) {
    }

    @Override
    public void setContextId(String contextId) {
    }

    @Override
    public Version getVersion() {
        return this.option.getVersion();
    }

    @Override
    public void setVersion(Version version) {
        this.option.setVersion(version);
    }

    @Override
    public String getManagedBuildRevision() {
        return this.option.getManagedBuildRevision();
    }

    public IConfigurationElement getValueHandlerElement() {
        return null;
    }

    public void setValueHandlerElement(IConfigurationElement element) {
    }

    @Override
    public IManagedOptionValueHandler getValueHandler() {
        return null;
    }

    @Override
    public String getValueHandlerExtraArgument() {
        return null;
    }

    @Override
    public void setValueHandlerExtraArgument(String extraArgument) {
    }

    @Override
    public String getFieldEditorId() {
        return null;
    }

    @Override
    public String getFieldEditorExtraArgument() {
        return null;
    }

    @Override
    public void setFieldEditorExtraArgument(String extraArgument) {
    }

    @Override
    public boolean isValid() {
        return this.option.isValid();
    }

    @Override
    public String[] getBasicStringListValue() throws BuildException {
        if (this.getBasicValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return new String[0];
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public int getBasicValueType() throws BuildException {
        switch (this.getValueType()) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 12: {
                return 12;
            }
        }
        return 3;
    }

    @Override
    public OptionStringValue[] getBasicStringListValueElements() throws BuildException {
        String[] str = this.getBasicStringListValue();
        OptionStringValue[] ve = new OptionStringValue[str.length];
        int i = 0;
        while (i < str.length) {
            ve[i] = new OptionStringValue(str[i]);
            ++i;
        }
        return ve;
    }

    @Override
    public boolean isForScannerDiscovery() {
        return this.option.isForScannerDiscovery();
    }

    @Override
    public boolean isExcludedFromScannerDiscovery() {
        return this.option.isExcludedFromScannerDiscovery();
    }

    @Override
    public IOption.ITreeRoot getTreeRoot() {
        if (!this.resolved) {
            this.resolveReferences();
        }
        if (this.option != null) {
            try {
                return this.option.getTreeRoot();
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return null;
    }
}

